/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.ExplicitGupEntry;
import com.sygate.scm.common.configobject.schema.ExplicitGupMapping;
import com.sygate.scm.common.configobject.schema.GupRuleSets;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.IPAddressUtil;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AddressObject;
import com.sygate.scm.console.logicobject.RuleSetRootObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.dialog.GUPRuleAddressDlg;
import com.sygate.scm.console.ui.policy.dialog.GUPSettingDlg;
import com.sygate.scm.console.ui.policy.lu.GupMappingDlg;
import com.sygate.scm.console.ui.policy.lu.logiobject.ExplicitGupMappingUIObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuContentSourceInfoObject;
import com.sygate.scm.console.ui.util.AlwaysEnabledButton;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.CompoundBorder;

public class GroupUpdateDlg
extends DialogBase {
    private static final long serialVersionUID = -801401585417611444L;
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    private static final String DLG = "com.sygate.scm.console.ui.policy.dialog.policydialog";
    private static final int MINUTES_INDEX = 0;
    private static final int HOURS_INDEX = 1;
    private static final int DAYS_INDEX = 2;
    private static final int KBS_INDEX = 0;
    private static final int MBS_INDEX = 1;
    private static final int GBS_INDEX = 2;
    private static final int SECONDS_IN_A_DAY = 86400;
    private static final int NEVER_BYPASS = -1;
    private static final int MAX_KBS = 10000000;
    private static final int MAX_MBS = 10000;
    private static final int MAX_GBS = 10;
    private static final int MAX_THREAD_COUNTS = 1000;
    private static final int MAX_DELETE_DAYS = 30;
    private static int MAX_HOSTNAME_LENGTH = 255;
    private static int MIN_THROTTLING_KBPS = 4;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    String allowedCharacters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-.:";
    RestrictedPlainDocument nameDoc = new RestrictedPlainDocument(MAX_HOSTNAME_LENGTH, this.allowedCharacters, true);
    private JPanel jContentPane = null;
    private JTextField jTFPort = null;
    private JCheckBox singleGupCheckBox = null;
    private JCheckBox multiGupCheckBox = null;
    private JCheckBox explicitGupCheckBox = null;
    private JRadioButton neverByPassRadioButton = null;
    private JRadioButton afterRadioButton = null;
    private JRadioButton neverThrottlingRadioButton = null;
    private JRadioButton upToRadioButton = null;
    private JRadioButton neverClientThrottlingRadioButton = null;
    private JRadioButton upToClientRadioButton = null;
    private AlwaysEnabledButton configureSingleRuleButton = null;
    private AlwaysEnabledButton configureRulesButton = null;
    private AlwaysEnabledButton configureExplicitGupButton = null;
    private JSpinner afterSpinner = null;
    private JSpinner maxDiskCacheSpinner = null;
    private JSpinner deleteContentsSpinner = null;
    private JSpinner threadCountSpinner = null;
    private JSpinner downloadThrottling = null;
    private JSpinner clientDownloadThrottling = null;
    private JComboBox<String> unitCombobox = null;
    private JComboBox<String> speedCombobox = null;
    private JComboBox<String> clientSpeedCombobox = null;
    private DefaultComboBoxModel<String> interval = null;
    private DefaultComboBoxModel<String> trafic = null;
    private DefaultComboBoxModel<String> clientTrafic = null;
    private Action configureRules;
    private JLabel undefinedLabel;
    private JLabel explicitGupLabel;
    private JLabel undefinedSingleLabel;
    private GupRuleSets gups = null;
    private LuContentSourceInfoObject sourceInfoObj;
    private ExplicitGupMapping explicitGupMapping;
    private boolean isReadonly;

    public GroupUpdateDlg(boolean isReadonly) {
        this(new LuContentSourceInfoObject(), isReadonly);
    }

    public GroupUpdateDlg(LuContentSourceInfoObject sourceInfoObj, boolean isReadonly) {
        super(Manager.getFrame(), MSGRES.getString(LU, "GroupUpdateDlg.label.title"), true);
        this.isReadonly = isReadonly;
        this.initialize(sourceInfoObj);
        UiUtilities.centerComponent((Component)this);
    }

    @Override
    protected boolean isValidate() {
        String strPort = this.jTFPort.getText().trim();
        if (strPort == null || strPort.length() == 0) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(LU, "GroupUpdateDlg.error.emptyPort"), MSGRES.getString(LU, "LuContentPolicyDialog.error"), 0);
            return false;
        }
        if (Integer.parseInt(strPort) == 0) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(LU, "GroupUpdateDlg.error.invalidPort"), MSGRES.getString(LU, "LuContentPolicyDialog.error"), 0);
            return false;
        }
        if (!(this.singleGupCheckBox.isSelected() || this.multiGupCheckBox.isSelected() || this.explicitGupCheckBox.isSelected())) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(LU, "GroupUpdateDlg.error.noGupConfigurationSpecified"), MSGRES.getString(LU, "LuContentPolicyDialog.error"), 0);
            return false;
        }
        if (this.multiGupCheckBox.isSelected() && this.gups == null) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(LU, "GroupUpdateDlg.error.noGupRuleSetsDefined"), MSGRES.getString(LU, "LuContentPolicyDialog.error"), 0);
            return false;
        }
        if (this.explicitGupCheckBox.isSelected() && this.explicitGupMapping == null) {
            JOptionPane.showMessageDialog(this, MSGRES.getString(LU, "GroupUpdateDlg.error.noExplicitGupsDefined"), MSGRES.getString(LU, "LuContentPolicyDialog.error"), 0);
            return false;
        }
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_lu_server_settings_live_update_group_provider";
    }

    @Override
    protected void commit() {
        block5: {
            if (this.sourceInfoObj == null) {
                this.sourceInfoObj = new LuContentSourceInfoObject();
            }
            String strPort = this.jTFPort.getText().trim();
            try {
                strPort = Integer.valueOf(strPort).toString();
                this.sourceInfoObj.setMasterClientPort(strPort);
            }
            catch (NumberFormatException ex) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        this.sourceInfoObj.setOptStaticGupSelected(this.singleGupCheckBox.isSelected());
        this.sourceInfoObj.setOptDymanicGupSelected(this.multiGupCheckBox.isSelected());
        this.sourceInfoObj.setOptExplicitGupSelected(this.explicitGupCheckBox.isSelected());
        this.sourceInfoObj.getSchemaObject().setOptGupRuleSets(this.gups);
        this.sourceInfoObj.setMasterClientBypassTime(this.getBypassTimeFromUI());
        this.sourceInfoObj.setMasterClientThrottling(this.getThrottlingFromUI());
        this.sourceInfoObj.setClientThrottling(this.getClientThrottlingFromUI());
        this.sourceInfoObj.setMasterClientMaxDiskCache((Integer)this.maxDiskCacheSpinner.getValue());
        Object spinnerValue = this.deleteContentsSpinner.getValue();
        double spinnerValuePrime = 0.0;
        if (spinnerValue instanceof Integer) {
            spinnerValuePrime = ((Integer)spinnerValue).intValue();
        }
        if (spinnerValue instanceof Double) {
            spinnerValuePrime = (Double)spinnerValue;
        }
        long deleteContentsTime = Double.valueOf(spinnerValuePrime * 86400.0).longValue();
        this.sourceInfoObj.setMasterClientDeleteUnusedContentsTime(deleteContentsTime);
        this.sourceInfoObj.setMasterClientThreadCount((Integer)this.threadCountSpinner.getValue());
        this.sourceInfoObj.getSchemaObject().setOptExplicitGupMapping(this.explicitGupMapping);
    }

    private void setObject(LuContentSourceInfoObject sourceInfoObj) {
        long bypassTime;
        if (sourceInfoObj == null) {
            sourceInfoObj = new LuContentSourceInfoObject();
        }
        this.sourceInfoObj = sourceInfoObj;
        this.jTFPort.setText(sourceInfoObj.getMasterClientPort());
        boolean staticGupSelected = sourceInfoObj.getOptStaticGupSelected();
        boolean dynamicGupSelected = sourceInfoObj.getOptDynamicGupSelected();
        boolean explicitGupSelected = sourceInfoObj.getOptExplicitGupSelected();
        if (staticGupSelected) {
            this.singleGupCheckBox.setSelected(true);
        }
        if (dynamicGupSelected) {
            this.multiGupCheckBox.setSelected(true);
        }
        if (explicitGupSelected) {
            this.explicitGupCheckBox.setSelected(true);
        }
        if ((bypassTime = (long)sourceInfoObj.getMasterClientBypassTime()) < 0L) {
            this.neverByPassRadioButton.setSelected(true);
            long bypassTimeForDisabledAfterControls = sourceInfoObj.getDefMasterClientBypassTime();
            if (bypassTimeForDisabledAfterControls == -1L) {
                bypassTimeForDisabledAfterControls = 1800L;
            }
            this.setBypassTimeForAfterUIControls(bypassTimeForDisabledAfterControls);
        } else {
            this.afterRadioButton.setSelected(true);
            this.setBypassTimeForAfterUIControls(bypassTime);
        }
        int throttling = sourceInfoObj.getMasterClientThrottling();
        if (throttling < 0) {
            this.neverThrottlingRadioButton.setSelected(true);
            int throttlingControls = sourceInfoObj.getDefMasterClientThrottling();
            if (throttlingControls == -1) {
                throttlingControls = 32;
            }
            this.setThrottlingForAfterUIControls(throttlingControls);
        } else {
            this.upToRadioButton.setSelected(true);
            this.setThrottlingForAfterUIControls(throttling);
        }
        int clientThrottling = sourceInfoObj.getClientThrottling();
        if (clientThrottling < 0) {
            this.neverClientThrottlingRadioButton.setSelected(true);
            int throttlingControls = sourceInfoObj.getDefClientThrottling();
            if (throttlingControls == -1) {
                throttlingControls = 32;
            }
            this.setClientThrottlingForAfterUIControls(throttlingControls);
        } else {
            this.upToClientRadioButton.setSelected(true);
            this.setClientThrottlingForAfterUIControls(clientThrottling);
        }
        this.maxDiskCacheSpinner.setValue(sourceInfoObj.getMasterClientMaxDiskCache());
        this.deleteContentsSpinner.setValue((int)(sourceInfoObj.getMasterClientDeleteUnusedContentsTime() / 86400L));
        this.threadCountSpinner.setValue(sourceInfoObj.getMasterClientThreadCount());
        this.gups = sourceInfoObj.getSchemaObject().getOptGupRuleSets();
        this.explicitGupMapping = sourceInfoObj.getSchemaObject().getOptExplicitGupMapping();
        this.updatePanelStatus();
    }

    private void setBypassTimeForAfterUIControls(long bypassTime) {
        if ((bypassTime /= 60L) < 60L) {
            this.afterSpinner.setModel(new SpinnerNumberModel((int)bypassTime, 1, 59, 1));
            UIUtilities.enableOnlyValidEdits(this.afterSpinner);
            this.unitCombobox.setSelectedIndex(0);
        } else if (bypassTime <= 1380L) {
            long hours = bypassTime / 60L;
            this.afterSpinner.setModel(new SpinnerNumberModel((int)hours, 1, 23, 1));
            UIUtilities.enableOnlyValidEdits(this.afterSpinner);
            this.unitCombobox.setSelectedIndex(1);
        } else {
            long days = bypassTime / 1440L;
            this.afterSpinner.setModel(new SpinnerNumberModel((int)days, 1, 30, 1));
            UIUtilities.enableOnlyValidEdits(this.afterSpinner);
            this.unitCombobox.setSelectedIndex(2);
        }
    }

    private void setThrottlingForAfterUIControls(int throttling) {
        int kvalue = throttling % 1000;
        int mvalue = throttling / 1000;
        if (kvalue > 0) {
            if (throttling < MIN_THROTTLING_KBPS) {
                throttling = MIN_THROTTLING_KBPS;
            }
            this.downloadThrottling.setModel(new SpinnerNumberModel(throttling, MIN_THROTTLING_KBPS, 10000000, 1));
            UIUtilities.enableOnlyValidEdits(this.downloadThrottling);
            this.speedCombobox.setSelectedIndex(0);
        } else if (mvalue % 1000 > 0) {
            this.downloadThrottling.setModel(new SpinnerNumberModel(mvalue, 1, 10000, 1));
            UIUtilities.enableOnlyValidEdits(this.downloadThrottling);
            this.speedCombobox.setSelectedIndex(1);
        } else {
            int gbs = throttling / 1000000;
            this.downloadThrottling.setModel(new SpinnerNumberModel(gbs, 1, 10, 1));
            UIUtilities.enableOnlyValidEdits(this.downloadThrottling);
            this.speedCombobox.setSelectedIndex(2);
        }
    }

    private void setClientThrottlingForAfterUIControls(int clientThrottling) {
        int kvalue = clientThrottling % 1000;
        int mvalue = clientThrottling / 1000;
        if (kvalue > 0) {
            if (clientThrottling < MIN_THROTTLING_KBPS) {
                clientThrottling = MIN_THROTTLING_KBPS;
            }
            this.clientDownloadThrottling.setModel(new SpinnerNumberModel(clientThrottling, MIN_THROTTLING_KBPS, 10000000, 1));
            UIUtilities.enableOnlyValidEdits(this.clientDownloadThrottling);
            this.clientSpeedCombobox.setSelectedIndex(0);
        } else if (mvalue % 1000 > 0) {
            this.clientDownloadThrottling.setModel(new SpinnerNumberModel(mvalue, 1, 10000, 1));
            UIUtilities.enableOnlyValidEdits(this.clientDownloadThrottling);
            this.clientSpeedCombobox.setSelectedIndex(1);
        } else {
            int gbs = clientThrottling / 1000000;
            this.clientDownloadThrottling.setModel(new SpinnerNumberModel(gbs, 1, 10, 1));
            UIUtilities.enableOnlyValidEdits(this.clientDownloadThrottling);
            this.clientSpeedCombobox.setSelectedIndex(2);
        }
    }

    private void initialize(LuContentSourceInfoObject sourceInfoObj) {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(2);
        borderLayout.setVgap(2);
        Container cont = this.getContentPane();
        cont.setLayout(borderLayout);
        cont.add((Component)this.getJContentPane(sourceInfoObj), "Center");
        cont.add((Component)this.getButtonPanel(), "South");
        this.setObject(sourceInfoObj);
        this.updateUndefinedLabelStatus();
        this.updateUndefinedSingleLabelStatus();
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        if ("en".equalsIgnoreCase(language)) {
            this.setSize(new Dimension(830, 700));
        } else {
            this.setSize(new Dimension(1080, 700));
        }
        UiUtilities.centerComponent((Component)this);
        if (this.isReadonly) {
            UIUtilities.setContainerStatus(this.jContentPane, false);
            this.resetOKButton(false);
        }
        this.setVisible(true);
    }

    private JPanel getJContentPane(LuContentSourceInfoObject soureInfoObj) {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            JPanel centerPanel = new JPanel();
            centerPanel.setLayout(new BorderLayout());
            this.jContentPane.setLayout(new BorderLayout());
            centerPanel.setBorder(BorderFactory.createEmptyBorder(0, 50, 20, 40));
            this.jContentPane.add((Component)centerPanel, "Center");
            centerPanel.add((Component)this.getGupSelectionPanel(soureInfoObj), "North");
            centerPanel.add((Component)this.getGupNetworkSettingPanel(), "Center");
            this.jContentPane.add((Component)this.getDescPanel(centerPanel.getPreferredSize().width), "North");
            this.setListener();
        }
        return this.jContentPane;
    }

    private JPanel getDescPanel(int length) {
        AvTemplatePane descPanel = new AvTemplatePane(MSGRES.getString(LU, "GroupUpdateDlg.label.title"), MSGRES.getString(LU, "GroupUpdateDlg.label.desc"), false, length);
        descPanel.setBorder(BorderFactory.createEmptyBorder(5, 25, 0, 30));
        return descPanel;
    }

    private JLabel getLabel(String key) {
        JLabel label = new JLabel();
        label.setText(MSGRES.getString(LU, key));
        return label;
    }

    private JLabel getUndefinedLabel(String key) {
        if (this.undefinedLabel == null) {
            this.undefinedLabel = new JLabel();
            this.undefinedLabel.setText(MSGRES.getString(LU, key));
        }
        this.undefinedLabel.setText(MSGRES.getString(LU, key));
        this.undefinedLabel.setVisible(true);
        return this.undefinedLabel;
    }

    private JLabel getUndefinedSingleLabel(String key) {
        if (this.undefinedSingleLabel == null) {
            this.undefinedSingleLabel = new JLabel();
            this.undefinedSingleLabel.setText(MSGRES.getString(LU, key));
        }
        this.undefinedSingleLabel.setText(MSGRES.getString(LU, key));
        this.undefinedSingleLabel.setVisible(true);
        return this.undefinedSingleLabel;
    }

    private JLabel getExplicitGupLabel(String key) {
        if (this.explicitGupLabel == null) {
            this.explicitGupLabel = new JLabel();
        }
        this.explicitGupLabel.setText(MSGRES.getString(LU, key));
        this.explicitGupLabel.setVisible(true);
        return this.explicitGupLabel;
    }

    private JPanel getGupSelectionPanel(LuContentSourceInfoObject soureInfoObj) {
        CompoundBorder titledBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MSGRES.getString(LU, "GroupUpdateDlg.selection.title")), BorderFactory.createEmptyBorder(5, 10, 10, 0));
        JPanel gupSelectionPanel = new JPanel();
        gupSelectionPanel.setLayout(new BorderLayout());
        gupSelectionPanel.setBorder(titledBorder);
        gupSelectionPanel.add((Component)this.getJTextArea("GroupUpdateDlg.textarea.content"), "North");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.getGupSelectLeftPanel(), "West");
        panel.add((Component)this.getGupSelectRightPanel(soureInfoObj), "Center");
        gupSelectionPanel.add((Component)panel, "Center");
        return gupSelectionPanel;
    }

    private JPanel getGupSelectLeftPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int row = 0;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.anchor = 17;
        constraints.gridy = row++;
        constraints.weightx = 0.5;
        constraints.weighty = 0.5;
        constraints.fill = 1;
        constraints.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)this.getMultiGUPCheckBox(), constraints);
        constraints.gridy = row++;
        constraints.insets.top = 0;
        constraints.insets.left = 33;
        panel.add((Component)this.getJTextArea("GroupUpdateDlg.multiGUPText"), constraints);
        constraints.gridy = row++;
        constraints.insets.top = 10;
        constraints.insets.left = 10;
        panel.add((Component)this.getExplicitGupCheckBox(), constraints);
        constraints.gridy = row++;
        constraints.insets.top = 0;
        constraints.insets.left = 33;
        panel.add((Component)this.getJTextArea("GroupUpdateDlg.explicitGUPText"), constraints);
        constraints.gridy = row++;
        constraints.insets.top = 10;
        constraints.insets.left = 10;
        panel.add((Component)this.getSingleGUPCheckBox(), constraints);
        constraints.gridy = row++;
        constraints.insets.top = 0;
        constraints.insets.left = 33;
        panel.add((Component)this.getJTextArea("GroupUpdateDlg.singleGUPText"), constraints);
        constraints.gridy = row++;
        constraints.insets.top = 10;
        constraints.insets.left = 0;
        panel.add((Component)this.getJTextArea("GroupUpdateDlg.bypassLabel"), constraints);
        return panel;
    }

    private JPanel getGupSelectRightPanel(LuContentSourceInfoObject srcInfoObj) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int row = 0;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.anchor = 17;
        constraints.gridy = row++;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 15, 0, 10);
        constraints.gridwidth = 3;
        panel.add((Component)this.getConfigureRulesButton(), constraints);
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 10);
        constraints.gridx = 3;
        panel.add((Component)this.getUndefinedLabel("GroupUpdateDlg.label.undefined"), constraints);
        constraints.fill = 2;
        constraints.insets = new Insets(20, 15, 0, 10);
        constraints.gridy = row++;
        constraints.gridx = 0;
        panel.add((Component)this.getConfigureExplicitGupsButton(), constraints);
        constraints.fill = 2;
        constraints.insets = new Insets(20, 0, 0, 10);
        constraints.gridx = 3;
        String labelKey = "GroupUpdateDlg.label.undefined";
        if (srcInfoObj.getSchemaObject().getOptExplicitGupMapping() != null && srcInfoObj.getSchemaObject().getOptExplicitGupMapping().getExplicitGupEntryCount() > 0) {
            labelKey = "GroupUpdateDlg.label.defined";
        }
        panel.add((Component)this.getExplicitGupLabel(labelKey), constraints);
        constraints.fill = 2;
        constraints.insets = new Insets(20, 15, 0, 10);
        constraints.gridy = row++;
        constraints.gridx = 0;
        panel.add((Component)this.getConfigureSingleRuleButton(), constraints);
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 10);
        constraints.gridx = 3;
        panel.add((Component)this.getUndefinedSingleLabel("GroupUpdateDlg.label.undefined"), constraints);
        constraints.gridy = row++;
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        constraints.weightx = 0.25;
        constraints.insets = new Insets(0, 15, 0, 10);
        panel.add((Component)this.getNeverByPassRadioButton(), constraints);
        constraints.gridx = 1;
        constraints.insets = new Insets(0, 10, 0, 0);
        panel.add((Component)this.getAfterRadioButton(), constraints);
        constraints.gridx = 2;
        constraints.insets = new Insets(0, 0, 0, 10);
        panel.add((Component)this.getAfterSpinner(), constraints);
        constraints.gridx = 3;
        constraints.insets = new Insets(0, 0, 0, 10);
        constraints.fill = 2;
        constraints.ipadx = 10;
        panel.add(this.getUnitCombobox(), constraints);
        ButtonGroup group = new ButtonGroup();
        group.add(this.getNeverByPassRadioButton());
        group.add(this.getAfterRadioButton());
        return panel;
    }

    private JPanel getGupNetworkSettingPanel() {
        CompoundBorder titledBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MSGRES.getString(LU, "GroupUpdateDlg.networkSetting.title")), BorderFactory.createEmptyBorder(5, 10, 10, 0));
        JPanel gupNetworkSetting = new JPanel();
        gupNetworkSetting.setBorder(titledBorder);
        gupNetworkSetting.setLayout(new BorderLayout());
        gupNetworkSetting.add((Component)this.getGupNetworkSettingsPanel(), "North");
        return gupNetworkSetting;
    }

    private JPanel getGupNetworkSettingsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int row = 0;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.anchor = 17;
        constraints.gridy = row++;
        constraints.weightx = 0.5;
        constraints.weighty = 0.5;
        constraints.fill = 2;
        constraints.insets = new Insets(10, 0, 0, 10);
        panel.add((Component)this.getLabel("GroupUpdateDlg.label.port"), constraints);
        constraints.gridx = 1;
        panel.add((Component)this.getTFPort(), constraints);
        constraints.gridy = row++;
        constraints.gridx = 0;
        panel.add((Component)this.getLabel("GroupUpdateDlg.maxDiskCache"), constraints);
        constraints.gridx = 1;
        panel.add((Component)this.getMaxDiskCacheSpinner(), constraints);
        constraints.gridy = row++;
        constraints.gridx = 0;
        panel.add((Component)this.getLabel("GroupUpdateDlg.deleteContents"), constraints);
        constraints.gridx = 1;
        panel.add((Component)this.getDeleteContentsSpinner(), constraints);
        constraints.gridy = row++;
        constraints.gridx = 0;
        panel.add((Component)this.getLabel("GroupUpdateDlg.threadCount"), constraints);
        constraints.gridx = 1;
        panel.add((Component)this.getThreadCountSpinner(), constraints);
        constraints.gridy = row++;
        constraints.gridx = 0;
        panel.add((Component)this.getJTextArea("GroupUpdateDlg.downloadThrottling"), constraints);
        constraints.gridx = 1;
        constraints.weightx = 0.25;
        panel.add((Component)this.getNeverThrottlingRadioButton(), constraints);
        constraints.gridx = 2;
        panel.add((Component)this.getUpToRadioButton(), constraints);
        constraints.gridx = 3;
        panel.add((Component)this.getDownloadThrottling(), constraints);
        constraints.gridx = 4;
        panel.add(this.getSpeedCombobox(), constraints);
        ButtonGroup group = new ButtonGroup();
        group.add(this.getNeverThrottlingRadioButton());
        group.add(this.getUpToRadioButton());
        constraints.gridy = row++;
        constraints.gridx = 0;
        panel.add((Component)this.getJTextArea("GroupUpdateDlg.clientDownloadThrottling"), constraints);
        constraints.gridx = 1;
        panel.add((Component)this.getClientNeverThrottlingRadioButton(), constraints);
        constraints.gridx = 2;
        panel.add((Component)this.getClientUpToRadioButton(), constraints);
        constraints.gridx = 3;
        panel.add((Component)this.getClientDownloadThrottling(), constraints);
        constraints.gridx = 4;
        panel.add(this.getClientSpeedCombobox(), constraints);
        ButtonGroup clientGroup = new ButtonGroup();
        clientGroup.add(this.getClientNeverThrottlingRadioButton());
        clientGroup.add(this.getClientUpToRadioButton());
        return panel;
    }

    private void setListener() {
        ActionListener radioListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GroupUpdateDlg.this.updatePanelStatus();
            }
        };
        this.getNeverByPassRadioButton().addActionListener(radioListener);
        this.getAfterRadioButton().addActionListener(radioListener);
        this.getNeverThrottlingRadioButton().addActionListener(radioListener);
        this.getUpToRadioButton().addActionListener(radioListener);
        this.getClientNeverThrottlingRadioButton().addActionListener(radioListener);
        this.getClientUpToRadioButton().addActionListener(radioListener);
        this.getSingleGUPCheckBox().addActionListener(radioListener);
        this.getMultiGUPCheckBox().addActionListener(radioListener);
        this.getExplicitGupCheckBox().addActionListener(radioListener);
        ItemListener comboxListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    if (event.getSource() == GroupUpdateDlg.this.speedCombobox) {
                        GroupUpdateDlg.this.updateThrottlingLimit();
                    } else if (event.getSource() == GroupUpdateDlg.this.clientSpeedCombobox) {
                        GroupUpdateDlg.this.updateClientThrottlingLimit();
                    } else if (event.getSource() == GroupUpdateDlg.this.unitCombobox) {
                        GroupUpdateDlg.this.updateAftertimeLimits();
                    }
                }
            }
        };
        this.getUnitCombobox().addItemListener(comboxListener);
        this.getSpeedCombobox().addItemListener(comboxListener);
        this.getClientSpeedCombobox().addItemListener(comboxListener);
    }

    private JTextArea getJTextArea(String key) {
        JTextArea jTextArea = new JTextArea(MSGRES.getString(LU, key));
        jTextArea.setEditable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setOpaque(false);
        jTextArea.setAlignmentX(0.0f);
        return jTextArea;
    }

    private JButton getConfigureRulesButton() {
        if (this.configureRulesButton == null) {
            this.configureRules = new AbstractAction(MSGRES.getString(LU, "GroupUpdateDlg.label.button")){
                private static final long serialVersionUID = -8103332335179398246L;

                @Override
                public void actionPerformed(ActionEvent exc) {
                    block3: {
                        try {
                            RuleSetRootObject thisObject = new RuleSetRootObject((ConfigObject)GroupUpdateDlg.this.gups);
                            RuleSetRootObject rulesetsObject = thisObject.getClone();
                            GUPSettingDlg dlg = new GUPSettingDlg((JFrame)Manager.getFrame(), MSGRES.getString(GroupUpdateDlg.DLG, "GUPSettingDlg.title"), rulesetsObject, true);
                            dlg.setVisible(true);
                            if (!dlg.isOk()) {
                                return;
                            }
                            RuleSetRootObject rootObject = dlg.getRuleSetsObject();
                            GroupUpdateDlg.this.gups = rootObject != null ? rootObject.getGUPRuleSets() : null;
                            GroupUpdateDlg.this.updateUndefinedLabelStatus();
                        }
                        catch (ConsoleException ex) {
                            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString(GroupUpdateDlg.DLG, "GUPSettingDlg.consoleError"), 0);
                            if (!ex.needRelogin()) break block3;
                            Manager.getFrame().showLoginPanel();
                        }
                    }
                }
            };
            this.configureRulesButton = new AlwaysEnabledButton(this.configureRules);
        }
        return this.configureRulesButton;
    }

    private JButton getConfigureSingleRuleButton() {
        if (this.configureSingleRuleButton == null) {
            this.configureRules = new AbstractAction(MSGRES.getString(LU, "GroupUpdateDlg.label.singleButton")){
                private static final long serialVersionUID = -8103332335179398246L;

                @Override
                public void actionPerformed(ActionEvent exc) {
                    AddressObject addrObj = GroupUpdateDlg.this.getAddressObjectFromSingleGroupProvider();
                    GUPRuleAddressDlg dlg = new GUPRuleAddressDlg(Manager.getFrame(), MSGRES.getString(GroupUpdateDlg.DLG, "GUPConditionDlg.title.IPAddressHostName"), true);
                    dlg.setObject(addrObj);
                    dlg.setVisible(true);
                    if (!dlg.isOk() || GroupUpdateDlg.this.sourceInfoObj == null) {
                        return;
                    }
                    if (addrObj.getType() == 4) {
                        GroupUpdateDlg.this.sourceInfoObj.setMasterClientHost(addrObj.getHostName());
                    } else if (addrObj.getType() == 0 || addrObj.getType() == 7) {
                        GroupUpdateDlg.this.sourceInfoObj.setMasterClientHost(addrObj.getIP());
                    }
                    GroupUpdateDlg.this.updateUndefinedSingleLabelStatus();
                }
            };
            this.configureSingleRuleButton = new AlwaysEnabledButton(this.configureRules);
        }
        return this.configureSingleRuleButton;
    }

    private AddressObject getAddressObjectFromSingleGroupProvider() {
        AddressObject addrObj = null;
        if (this.sourceInfoObj == null || StringUtilities.isEmpty((String)this.sourceInfoObj.getMasterClientHost())) {
            addrObj = new AddressObject(4);
        } else {
            String hostname = this.sourceInfoObj.getMasterClientHost();
            if (IPAddressUtil.isIPv4LiteralAddress((String)hostname)) {
                addrObj = new AddressObject(0);
                addrObj.setIPAddress(hostname);
            } else if (IPAddressUtil.isIPv6LiteralAddress((String)hostname)) {
                addrObj = new AddressObject(7);
                addrObj.setIPAddress(hostname);
            } else {
                addrObj = new AddressObject(4);
                addrObj.setHostName(hostname);
            }
        }
        return addrObj;
    }

    private JButton getConfigureExplicitGupsButton() {
        if (this.configureExplicitGupButton == null) {
            this.configureRules = new AbstractAction(MSGRES.getString(LU, "GroupUpdateDlg.explicitgup.label.button")){
                private static final long serialVersionUID = 6670834779122702952L;

                @Override
                public void actionPerformed(ActionEvent exc) {
                    try {
                        ExplicitGupMapping mapping = null;
                        if (GroupUpdateDlg.this.sourceInfoObj != null) {
                            mapping = GroupUpdateDlg.this.sourceInfoObj.getSchemaObject().getOptExplicitGupMapping();
                        }
                        Hashtable<ExplicitGupMappingUIObject, ExplicitGupEntry> schemaMap = null;
                        ExplicitGupMappingUIObject[] gupUIMapping = null;
                        if (mapping != null) {
                            gupUIMapping = new ExplicitGupMappingUIObject[mapping.getExplicitGupEntryCount()];
                            schemaMap = GroupUpdateDlg.this.populateMappingUIObjects(mapping, gupUIMapping);
                        }
                        GupMappingDlg dlg = new GupMappingDlg(Manager.getFrame(), gupUIMapping, true);
                        dlg.setVisible(true);
                        if (dlg.isOk()) {
                            ExplicitGupMappingUIObject[] mappedObjects = dlg.getMappingObjects();
                            if (mappedObjects == null || mappedObjects.length == 0) {
                                GroupUpdateDlg.this.explicitGupMapping = null;
                                GroupUpdateDlg.this.getExplicitGupLabel("GroupUpdateDlg.label.undefined");
                            } else {
                                GroupUpdateDlg.this.populateMappingSchmemaObjects(schemaMap, mappedObjects);
                                GroupUpdateDlg.this.getExplicitGupLabel("GroupUpdateDlg.label.defined");
                            }
                            if (GroupUpdateDlg.this.sourceInfoObj != null) {
                                GroupUpdateDlg.this.sourceInfoObj.getSchemaObject().setOptExplicitGupMapping(GroupUpdateDlg.this.explicitGupMapping);
                            }
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString(GroupUpdateDlg.DLG, "GUPSettingDlg.consoleError"), 0);
                    }
                }
            };
            this.configureExplicitGupButton = new AlwaysEnabledButton(this.configureRules);
        }
        return this.configureExplicitGupButton;
    }

    private JTextField getTFPort() {
        if (this.jTFPort == null) {
            this.jTFPort = new JTextField(6);
            this.jTFPort.setDocument(new NumberPlainDocument(65535L, true));
        }
        return this.jTFPort;
    }

    private JRadioButton getNeverByPassRadioButton() {
        if (this.neverByPassRadioButton == null) {
            this.neverByPassRadioButton = new JRadioButton();
            this.neverByPassRadioButton.setText(MSGRES.getString(LU, "GroupUpdateDlg.neverByPassRadio"));
        }
        return this.neverByPassRadioButton;
    }

    private JRadioButton getAfterRadioButton() {
        if (this.afterRadioButton == null) {
            this.afterRadioButton = new JRadioButton();
            this.afterRadioButton.setText(MSGRES.getString(LU, "GroupUpdateDlg.afterRadio"));
        }
        return this.afterRadioButton;
    }

    private JRadioButton getNeverThrottlingRadioButton() {
        if (this.neverThrottlingRadioButton == null) {
            this.neverThrottlingRadioButton = new JRadioButton();
            this.neverThrottlingRadioButton.setText(MSGRES.getString(LU, "GroupUpdateDlg.neverThrottlingRadio"));
        }
        return this.neverThrottlingRadioButton;
    }

    private JRadioButton getUpToRadioButton() {
        if (this.upToRadioButton == null) {
            this.upToRadioButton = new JRadioButton();
            this.upToRadioButton.setText(MSGRES.getString(LU, "GroupUpdateDlg.upToRadio"));
        }
        return this.upToRadioButton;
    }

    private JSpinner getAfterSpinner() {
        if (this.afterSpinner == null) {
            this.afterSpinner = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
            this.adjustSize(this.afterSpinner);
            UIUtilities.enableOnlyValidEdits(this.afterSpinner);
        }
        return this.afterSpinner;
    }

    private JRadioButton getClientNeverThrottlingRadioButton() {
        if (this.neverClientThrottlingRadioButton == null) {
            this.neverClientThrottlingRadioButton = new JRadioButton();
            this.neverClientThrottlingRadioButton.setText(MSGRES.getString(LU, "GroupUpdateDlg.neverThrottlingRadio"));
        }
        return this.neverClientThrottlingRadioButton;
    }

    private JRadioButton getClientUpToRadioButton() {
        if (this.upToClientRadioButton == null) {
            this.upToClientRadioButton = new JRadioButton();
            this.upToClientRadioButton.setText(MSGRES.getString(LU, "GroupUpdateDlg.upToRadio"));
        }
        return this.upToClientRadioButton;
    }

    private void adjustSize(JSpinner spinner) {
        if (spinner == null) {
            return;
        }
        Dimension dimension = spinner.getPreferredSize();
        spinner.setPreferredSize(new Dimension(dimension.width / 2, dimension.height));
    }

    private JSpinner getMaxDiskCacheSpinner() {
        if (this.maxDiskCacheSpinner == null) {
            this.maxDiskCacheSpinner = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
            this.adjustSize(this.maxDiskCacheSpinner);
            UIUtilities.enableOnlyValidEdits(this.maxDiskCacheSpinner);
        }
        return this.maxDiskCacheSpinner;
    }

    private JSpinner getDeleteContentsSpinner() {
        if (this.deleteContentsSpinner == null) {
            this.deleteContentsSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 30, 1));
            this.adjustSize(this.deleteContentsSpinner);
            UIUtilities.enableOnlyValidEdits(this.deleteContentsSpinner);
        }
        return this.deleteContentsSpinner;
    }

    private JSpinner getThreadCountSpinner() {
        if (this.threadCountSpinner == null) {
            this.threadCountSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 1000, 1));
            this.adjustSize(this.threadCountSpinner);
            UIUtilities.enableOnlyValidEdits(this.threadCountSpinner);
        }
        return this.threadCountSpinner;
    }

    private JSpinner getDownloadThrottling() {
        if (this.downloadThrottling == null) {
            this.downloadThrottling = new JSpinner(new SpinnerNumberModel(MIN_THROTTLING_KBPS, MIN_THROTTLING_KBPS, 10000000, 1));
            this.adjustSize(this.downloadThrottling);
            UIUtilities.enableOnlyValidEdits(this.downloadThrottling);
        }
        return this.downloadThrottling;
    }

    private JSpinner getClientDownloadThrottling() {
        if (this.clientDownloadThrottling == null) {
            this.clientDownloadThrottling = new JSpinner(new SpinnerNumberModel(MIN_THROTTLING_KBPS, MIN_THROTTLING_KBPS, 10000000, 1));
            this.adjustSize(this.clientDownloadThrottling);
            UIUtilities.enableOnlyValidEdits(this.clientDownloadThrottling);
        }
        return this.clientDownloadThrottling;
    }

    private JComboBox<String> getUnitCombobox() {
        if (this.interval == null) {
            String minutes = MSGRES.getString(LU, "GroupUpdateDlg.minutes");
            String hours = MSGRES.getString(LU, "GroupUpdateDlg.hours");
            String days = MSGRES.getString(LU, "GroupUpdateDlg.days");
            this.interval = new DefaultComboBoxModel<String>(new String[]{minutes, hours, days});
        }
        if (this.unitCombobox == null) {
            this.unitCombobox = new JComboBox<String>(this.interval);
            this.unitCombobox.setPreferredSize(this.unitCombobox.getPreferredSize());
        }
        return this.unitCombobox;
    }

    private JComboBox<String> getSpeedCombobox() {
        if (this.trafic == null) {
            this.trafic = new DefaultComboBoxModel<String>(new String[]{MSGRES.getString(LU, "GroupUpdateDlg.Speed.Kpbs"), MSGRES.getString(LU, "GroupUpdateDlg.Speed.Mbps"), MSGRES.getString(LU, "GroupUpdateDlg.Speed.Gbps")});
        }
        if (this.speedCombobox == null) {
            this.speedCombobox = new JComboBox<String>(this.trafic);
            this.speedCombobox.setPreferredSize(this.speedCombobox.getPreferredSize());
        }
        return this.speedCombobox;
    }

    private JComboBox<String> getClientSpeedCombobox() {
        if (this.clientTrafic == null) {
            this.clientTrafic = new DefaultComboBoxModel<String>(new String[]{MSGRES.getString(LU, "GroupUpdateDlg.Speed.Kpbs"), MSGRES.getString(LU, "GroupUpdateDlg.Speed.Mbps"), MSGRES.getString(LU, "GroupUpdateDlg.Speed.Gbps")});
        }
        if (this.clientSpeedCombobox == null) {
            this.clientSpeedCombobox = new JComboBox<String>(this.clientTrafic);
            this.clientSpeedCombobox.setPreferredSize(this.clientSpeedCombobox.getPreferredSize());
        }
        return this.clientSpeedCombobox;
    }

    private long getBypassTimeFromUI() {
        long bypassTime = -1L;
        if (this.afterRadioButton.isSelected()) {
            long spinnerValue = ((Number)this.afterSpinner.getValue()).longValue();
            int selectedIndex = this.unitCombobox.getSelectedIndex();
            switch (selectedIndex) {
                case 0: {
                    bypassTime = spinnerValue * 60L;
                    break;
                }
                case 1: {
                    bypassTime = spinnerValue * 60L * 60L;
                    break;
                }
                default: {
                    bypassTime = spinnerValue * 86400L;
                }
            }
        }
        return bypassTime;
    }

    private void updateAftertimeLimits() {
        int selectedIndex = this.unitCombobox.getSelectedIndex();
        int maxLimit = 0;
        switch (selectedIndex) {
            case 0: {
                maxLimit = 59;
                break;
            }
            case 1: {
                maxLimit = 23;
                break;
            }
            default: {
                maxLimit = 30;
            }
        }
        long currentValue = ((Number)this.afterSpinner.getValue()).longValue();
        if (currentValue > (long)maxLimit) {
            currentValue = 1L;
        }
        this.afterSpinner.setModel(new SpinnerNumberModel(currentValue, 1.0, (double)maxLimit, 1.0));
        UIUtilities.enableOnlyValidEdits(this.afterSpinner);
    }

    private int getThrottlingFromUI() {
        int throttling = -1;
        if (this.upToRadioButton.isSelected()) {
            int currentValue = (Integer)this.downloadThrottling.getValue();
            int selectedIndex = this.speedCombobox.getSelectedIndex();
            switch (selectedIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    currentValue *= 1000;
                    break;
                }
                case 2: {
                    currentValue = currentValue * 1000 * 1000;
                    break;
                }
            }
            throttling = currentValue;
        }
        return throttling;
    }

    private int getClientThrottlingFromUI() {
        int throttling = -1;
        if (this.upToClientRadioButton.isSelected()) {
            int currentValue = (Integer)this.clientDownloadThrottling.getValue();
            int selectedIndex = this.clientSpeedCombobox.getSelectedIndex();
            switch (selectedIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    currentValue *= 1000;
                    break;
                }
                case 2: {
                    currentValue = currentValue * 1000 * 1000;
                    break;
                }
            }
            throttling = currentValue;
        }
        return throttling;
    }

    private void updateThrottlingLimit() {
        int selectedIndex = this.speedCombobox.getSelectedIndex();
        int maxLimit = 0;
        int mininum = 1;
        int currentValue = (Integer)this.downloadThrottling.getValue();
        switch (selectedIndex) {
            case 0: {
                maxLimit = 10000000;
                mininum = MIN_THROTTLING_KBPS;
                if (currentValue >= MIN_THROTTLING_KBPS) break;
                currentValue = MIN_THROTTLING_KBPS;
                break;
            }
            case 1: {
                maxLimit = 10000;
                break;
            }
            case 2: {
                maxLimit = 10;
                break;
            }
            default: {
                maxLimit = 10000000;
            }
        }
        if (currentValue > maxLimit) {
            currentValue = maxLimit;
        }
        this.downloadThrottling.setModel(new SpinnerNumberModel(currentValue, mininum, maxLimit, 1));
        UIUtilities.enableOnlyValidEdits(this.downloadThrottling);
    }

    private void updateClientThrottlingLimit() {
        int selectedIndex = this.clientSpeedCombobox.getSelectedIndex();
        int maxLimit = 0;
        int mininum = 1;
        int currentValue = (Integer)this.clientDownloadThrottling.getValue();
        switch (selectedIndex) {
            case 0: {
                maxLimit = 10000000;
                mininum = MIN_THROTTLING_KBPS;
                if (currentValue >= MIN_THROTTLING_KBPS) break;
                currentValue = MIN_THROTTLING_KBPS;
                break;
            }
            case 1: {
                maxLimit = 10000;
                break;
            }
            case 2: {
                maxLimit = 10;
                break;
            }
            default: {
                maxLimit = 10000000;
            }
        }
        if (currentValue > maxLimit) {
            currentValue = maxLimit;
        }
        this.clientDownloadThrottling.setModel(new SpinnerNumberModel(currentValue, mininum, maxLimit, 1));
        UIUtilities.enableOnlyValidEdits(this.clientDownloadThrottling);
    }

    private void updateUndefinedLabelStatus() {
        boolean defined = false;
        if (this.gups != null && this.gups.getGupRuleSetCount() > 0) {
            defined = true;
        }
        if (defined) {
            this.getUndefinedLabel("GroupUpdateDlg.label.defined");
        } else {
            this.getUndefinedLabel("GroupUpdateDlg.label.undefined");
        }
    }

    private void updateUndefinedSingleLabelStatus() {
        boolean defined = false;
        if (this.sourceInfoObj != null && this.sourceInfoObj.getOptStaticGupSelected() && !StringUtilities.isEmpty((String)this.sourceInfoObj.getMasterClientHost())) {
            defined = true;
        }
        if (defined) {
            this.getUndefinedSingleLabel("GroupUpdateDlg.label.defined");
        } else {
            this.getUndefinedSingleLabel("GroupUpdateDlg.label.undefined");
        }
    }

    private void updatePanelStatus() {
        if (this.afterRadioButton.isSelected()) {
            this.afterSpinner.setEnabled(true);
            this.unitCombobox.setEnabled(true);
        }
        if (this.neverByPassRadioButton.isSelected()) {
            this.afterSpinner.setEnabled(false);
            this.unitCombobox.setEnabled(false);
        }
        if (this.upToRadioButton.isSelected()) {
            this.downloadThrottling.setEnabled(true);
            this.speedCombobox.setEnabled(true);
        }
        if (this.upToClientRadioButton.isSelected()) {
            this.clientDownloadThrottling.setEnabled(true);
            this.clientSpeedCombobox.setEnabled(true);
        }
        if (this.neverThrottlingRadioButton.isSelected()) {
            this.downloadThrottling.setEnabled(false);
            this.speedCombobox.setEnabled(false);
        }
        if (this.neverClientThrottlingRadioButton.isSelected()) {
            this.clientDownloadThrottling.setEnabled(false);
            this.clientSpeedCombobox.setEnabled(false);
        }
        if (this.singleGupCheckBox.isSelected()) {
            this.undefinedSingleLabel.setEnabled(true);
            this.configureSingleRuleButton.setEnabled(true);
        } else {
            this.undefinedSingleLabel.setEnabled(false);
            this.configureSingleRuleButton.setEnabled(false);
        }
        if (this.multiGupCheckBox.isSelected()) {
            this.undefinedLabel.setEnabled(true);
            this.configureRulesButton.setEnabled(true);
        } else {
            this.undefinedLabel.setEnabled(false);
            this.configureRulesButton.setEnabled(false);
        }
        if (this.explicitGupCheckBox.isSelected()) {
            this.explicitGupLabel.setEnabled(true);
            this.configureExplicitGupButton.setEnabled(true);
        } else {
            this.explicitGupLabel.setEnabled(false);
            this.configureExplicitGupButton.setEnabled(false);
        }
    }

    private Hashtable<ExplicitGupMappingUIObject, ExplicitGupEntry> populateMappingUIObjects(ExplicitGupMapping srcMapping, ExplicitGupMappingUIObject[] targetMappings) {
        int mappingCount = srcMapping.getExplicitGupEntryCount();
        Hashtable<ExplicitGupMappingUIObject, ExplicitGupEntry> schemaMap = new Hashtable<ExplicitGupMappingUIObject, ExplicitGupEntry>();
        for (int i = 0; i < mappingCount; ++i) {
            ExplicitGupEntry entry = srcMapping.getExplicitGupEntry(i);
            String mappingType = null;
            if (entry.getGupMappingType().equals(ExplicitGupEntry.GUP_HOSTNAME)) {
                mappingType = MessageResources.getInstance().getString(DLG, "GUPMappingDlg.mappingtype.hostname");
            } else if (entry.getGupMappingType().equals(ExplicitGupEntry.GUP_IPADDRESS)) {
                mappingType = MessageResources.getInstance().getString(DLG, "GUPMappingDlg.mappingtype.ipaddress");
            } else if (entry.getGupMappingType().equals(ExplicitGupEntry.GUP_SUBNET)) {
                mappingType = MessageResources.getInstance().getString(DLG, "GUPMappingDlg.mappingtype.subnet");
            }
            ExplicitGupMappingUIObject uiObj = entry.getGupMappingType().equals(ExplicitGupEntry.GUP_SUBNET) ? new ExplicitGupMappingUIObject(entry.getOptClientSubnetMaskSelected(), entry.getOptClientSubnetMask(), entry.getClientSubnet(), mappingType, entry.getGupMappingValue(), entry.getOptPort()) : new ExplicitGupMappingUIObject(entry.getOptClientSubnetMaskSelected(), entry.getOptClientSubnetMask(), entry.getClientSubnet(), mappingType, entry.getGupMappingValue(), entry.getOptPort() != null && entry.getOptPort().trim().length() > 0 ? entry.getOptPort() : entry.getDefPort());
            targetMappings[i] = uiObj;
            schemaMap.put(uiObj, entry);
        }
        return schemaMap;
    }

    private void populateMappingSchmemaObjects(Hashtable<ExplicitGupMappingUIObject, ExplicitGupEntry> schemaMap, ExplicitGupMappingUIObject[] srcMappings) {
        int i;
        if (schemaMap == null) {
            schemaMap = new Hashtable();
        }
        ExplicitGupEntry[] orderedEntry = new ExplicitGupEntry[srcMappings.length];
        for (i = 0; i < srcMappings.length; ++i) {
            boolean bl = false;
            ExplicitGupMappingUIObject uiObj = srcMappings[i];
            ExplicitGupEntry entry = (ExplicitGupEntry)schemaMap.get(uiObj);
            if (entry == null) {
                bl = true;
                entry = new ExplicitGupEntry();
            } else {
                schemaMap.remove(uiObj);
            }
            orderedEntry[i] = entry;
            String mappingType = uiObj.getGupMappingType();
            if (mappingType.equals(MessageResources.getInstance().getString(DLG, "GUPMappingDlg.mappingtype.hostname"))) {
                entry.setGupMappingType(ExplicitGupEntry.GUP_HOSTNAME);
                entry.setOptPort(uiObj.getPort());
            } else if (mappingType.equals(MessageResources.getInstance().getString(DLG, "GUPMappingDlg.mappingtype.ipaddress"))) {
                entry.setGupMappingType(ExplicitGupEntry.GUP_IPADDRESS);
                entry.setOptPort(uiObj.getPort());
            } else if (mappingType.equals(MessageResources.getInstance().getString(DLG, "GUPMappingDlg.mappingtype.subnet"))) {
                entry.setGupMappingType(ExplicitGupEntry.GUP_SUBNET);
            }
            entry.setGupMappingValue(uiObj.getGupMappingValue());
            entry.setClientSubnet(uiObj.getClientSubnet());
            entry.setOptClientSubnetMaskSelected(uiObj.getClientSubnetMaskSelected());
            entry.setOptClientSubnetMask(uiObj.getClientSubnetMask());
            if (this.explicitGupMapping == null) {
                this.explicitGupMapping = new ExplicitGupMapping();
                ConsoleLogger.log("Created new ExplicitGupMapping");
            }
            if (bl) {
                ConsoleLogger.log("Added new ExplicitGupEntry:" + entry.getClientSubnet());
                this.explicitGupMapping.addExplicitGupEntry(entry);
                continue;
            }
            ConsoleLogger.log("Updated new ExplicitGupEntry:" + entry.getClientSubnet());
        }
        if (!schemaMap.isEmpty() && this.explicitGupMapping != null) {
            for (ExplicitGupEntry explicitGupEntry : schemaMap.values()) {
                this.explicitGupMapping.removeExplicitGupEntry(explicitGupEntry);
                ConsoleLogger.log("Removed ExplicitGupEntry:" + explicitGupEntry.getClientSubnet());
            }
        }
        if (this.explicitGupMapping != null) {
            for (i = 0; i < orderedEntry.length; ++i) {
                this.explicitGupMapping.setExplicitGupEntry(i, orderedEntry[i]);
            }
        }
    }

    public JCheckBox getSingleGUPCheckBox() {
        if (this.singleGupCheckBox == null) {
            this.singleGupCheckBox = new JCheckBox();
            this.singleGupCheckBox.setText(MSGRES.getString(LU, "GroupUpdateDlg.singleGUPRadio"));
        }
        return this.singleGupCheckBox;
    }

    public JCheckBox getMultiGUPCheckBox() {
        if (this.multiGupCheckBox == null) {
            this.multiGupCheckBox = new JCheckBox();
            this.multiGupCheckBox.setText(MSGRES.getString(LU, "GroupUpdateDlg.multiGUPRadio"));
        }
        return this.multiGupCheckBox;
    }

    public JCheckBox getExplicitGupCheckBox() {
        if (this.explicitGupCheckBox == null) {
            this.explicitGupCheckBox = new JCheckBox();
            this.explicitGupCheckBox.setText(MSGRES.getString(LU, "GroupUpdateDlg.ExplictGUPMapping.label"));
        }
        return this.explicitGupCheckBox;
    }

    public LuContentSourceInfoObject getObject() {
        return this.sourceInfoObj;
    }
}

