/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.LuContentCategory;
import com.sygate.scm.console.logicobject.RevisionObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.ui.policy.lu.VersionDialog;
import com.sygate.scm.console.ui.policy.lu.logiobject.ContentVersionInfoTableRow;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;

public class EngineVersionDialog
extends VersionDialog {
    public static final String UNLOCKED_SEQ = "99999999";
    private static final long serialVersionUID = 1606164724360319277L;

    public EngineVersionDialog(LuContentCategory luCategory) {
        super(luCategory);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_lunv_add_engine_version_component";
    }

    @Override
    protected void commit() {
        int i = this.tableModel.getRowCount();
        while (--i >= 0) {
            ContentVersionInfoTableRow obj = (ContentVersionInfoTableRow)this.tableModel.getRow(i);
            if (obj.getSequenceNum().equals(UNLOCKED_SEQ)) {
                this.appliedContentObject.removeContent(obj.getClientMoniker());
                continue;
            }
            this.appliedContentObject.updateContent(obj.getClientMoniker(), obj.getSequenceNum());
        }
    }

    @Override
    protected String createTitle() {
        Object[] obj = new Object[]{LuUtility.getLocalizedString(this.luCategory.getLocalizedStrings()).getOptDisplayName()};
        String msg = MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "EngineVersionDialog.title");
        return MessageFormat.format(msg, obj);
    }

    @Override
    protected String[] createTableColumnNames() {
        return new String[]{MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "VersionDialog.table.content"), MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "EngineVersionDialog.table.engineNum")};
    }

    @Override
    protected JPanel createDescriptionPanel() {
        return new AvTemplatePane(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "EngineVersionDialog.versionPanel.title"), MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "EngineVersionDialog.versionPanel.desc"), false);
    }

    @Override
    protected List<String> getAvailableVersions(String moniker) {
        List<String> versions = LuUtility.getAllAvailableContentEngineVersions(moniker, this.luCategory);
        if (versions.size() > 0) {
            versions.add(UNLOCKED_SEQ);
            Collections.sort(versions, this.getVersionComparator());
        }
        return versions;
    }

    @Override
    protected String getDisplaySequenceNum(String sequenceNum) {
        if (sequenceNum.equals(UNLOCKED_SEQ)) {
            return MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "EngineVersionDialog.unlocked");
        }
        return RevisionObject.convertEngineNumToUIFormat(sequenceNum);
    }

    @Override
    protected boolean isCorrectVersionType() {
        return this.appliedContentObject != null && this.appliedContentObject.isUseEngineVersion();
    }

    @Override
    protected boolean canAddtoTableModel(String moniker) {
        return this.getAvailableVersions(moniker).size() > 0;
    }
}

