/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.IPAddressUtil;
import com.sygate.scm.console.ui.policy.common.HostNamePane;
import com.sygate.scm.console.ui.policy.common.IPPane;
import com.sygate.scm.console.ui.policy.common.IPv6Pane;
import com.sygate.scm.console.ui.policy.common.PortPane;
import com.sygate.scm.console.ui.policy.lu.logiobject.ExplicitGupMappingUIObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.IPField;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import org.apache.commons.validator.routines.InetAddressValidator;

public class ConfigureGupMappingDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final int PREFERRED_WIDTH = 165;
    private static final int ID_IP_TYPE_V4 = 0;
    private static final int ID_IP_TYPE_V6 = 1;
    private static final String ADDRESS_IP_V4 = "IPV4";
    private static final String ADDRESS_IP_V6 = "IPV6";
    private static final String[] IP_VERSIONS = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "IPv.four"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "IPv.six")};
    private JLabel ipVerLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "IPv.label"));
    private static final String[] addressTypes = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.mappingtype.ipaddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.mappingtype.hostname"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.mappingtype.subnet")};
    private JComboBox<String> ipVerCombo;
    private final Map<String, JPanel> typeTable = new HashMap<String, JPanel>();
    public static final int GUP_IPADDRESS = 0;
    public static final int GUP_HOSTNAME = 1;
    public static final int GUP_SUBNET = 2;
    public static final int GUP_EXPLICIT_DEFAULT_PORT = 2967;
    ExplicitGupMappingUIObject mappingObj = null;
    private final Map<String, Integer> typeIndexMap = new HashMap<String, Integer>();
    private final Map<Integer, String> indexTypeMap = new HashMap<Integer, String>();
    private JPanel clientSubnetMaskFieldCardLayoutPanel = new JPanel();
    private JPanel clientSubnetPaneCardLayoutPanel = new JPanel();
    private JPanel gupIpPaneCardLayoutPanel = new JPanel();
    private JPanel gupSubnetPaneCardLayoutPanel = new JPanel();
    private JPanel contentPanel = new JPanel(new BorderLayout(10, 10));
    private JPanel centerPanel = new JPanel();
    private JPanel comboPane = new JPanel();
    private JPanel mainPane = new JPanel();
    private JLabel addressLabel = new JLabel();
    private JComboBox<String> typeCmbBox = new JComboBox<String>(addressTypes);
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel gupIpPanel = new JPanel();
    private IPPane ipPane = new IPPane(0, 10, 0, null, 165);
    private IPv6Pane ipv6Pane = new IPv6Pane(0, 10, 0, null, 165);
    private PortPane ipPortPane;
    private JPanel gupHostNamePanel = new JPanel();
    private HostNamePane hostPane = new HostNamePane(0, 5, 0, 120, true);
    private PortPane hostNamePortPane = new PortPane(55);
    private DescriptionTextArea ipDesc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.clientsubnet.desc"), 60);
    private DescriptionTextArea gupSubnetDesc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.gupsubnet.desc"), 60);
    private IPPane clientSubnetPane = new IPPane(0, 10, 0, null, 165);
    private IPv6Pane clientSubnetIpv6Pane = new IPv6Pane(0, 10, 0, null, 165);
    private JPanel clientSubnetMaskPanel = new JPanel();
    private JCheckBox clientSubnetMaskCheckbox = new JCheckBox();
    private IPField clientSubnetMaskField = new IPField();
    private JTextField clientSubnetMaskFieldIpv6 = new JTextField();
    private JPanel gupSubnetPanel = new JPanel();
    private IPPane gupSubnetPane = new IPPane(0, 10, 0, null, 165);
    private IPv6Pane gupSubnetIpv6Pane = new IPv6Pane(0, 10, 0, null, 165);
    private InetAddressValidator ipValidator = InetAddressValidator.getInstance();
    private HashMap<String, String> existingMaps = null;

    public ConfigureGupMappingDlg(JFrame frame, String title, boolean modal, boolean isEdit, ExplicitGupMappingUIObject uiObj, HashMap<String, String> maps) {
        super(frame, title, modal);
        try {
            if (uiObj != null) {
                this.mappingObj = uiObj;
            }
            if (maps != null) {
                this.existingMaps = maps;
            }
            this.jbInit(isEdit);
            this.pack();
            this.setResizable(false);
            UiUtilities.centerComponent((Component)this);
            this.updatePanel();
            this.setListener();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public void ipVersionTypeChanged() {
        CardLayout cdClientSubnet = (CardLayout)this.clientSubnetPaneCardLayoutPanel.getLayout();
        CardLayout cdClientSubnetMaskField = (CardLayout)this.clientSubnetMaskFieldCardLayoutPanel.getLayout();
        CardLayout cdGupIpPane = (CardLayout)this.gupIpPaneCardLayoutPanel.getLayout();
        CardLayout cdSubnetPane = (CardLayout)this.gupSubnetPaneCardLayoutPanel.getLayout();
        if (this.ipVerCombo.getSelectedIndex() == 0) {
            cdClientSubnet.show(this.clientSubnetPaneCardLayoutPanel, ADDRESS_IP_V4);
            cdClientSubnetMaskField.show(this.clientSubnetMaskFieldCardLayoutPanel, ADDRESS_IP_V4);
            cdGupIpPane.show(this.gupIpPaneCardLayoutPanel, ADDRESS_IP_V4);
            cdSubnetPane.show(this.gupSubnetPaneCardLayoutPanel, ADDRESS_IP_V4);
        } else if (this.ipVerCombo.getSelectedIndex() == 1) {
            cdClientSubnet.show(this.clientSubnetPaneCardLayoutPanel, ADDRESS_IP_V6);
            cdClientSubnetMaskField.show(this.clientSubnetMaskFieldCardLayoutPanel, ADDRESS_IP_V6);
            cdGupIpPane.show(this.gupIpPaneCardLayoutPanel, ADDRESS_IP_V6);
            cdSubnetPane.show(this.gupSubnetPaneCardLayoutPanel, ADDRESS_IP_V6);
        }
        this.updateSubnetMaskPanelEnableStatus();
    }

    public void typeChanged() {
        String type = (String)this.typeCmbBox.getSelectedItem();
        CardLayout cd = (CardLayout)this.mainPane.getLayout();
        cd.show(this.mainPane, type);
        this.pack();
    }

    public void setTypeModel(int type) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(addressTypes);
        this.typeCmbBox.setModel(model);
    }

    @Override
    protected boolean isValidate() {
        if (!this.ipValidator.isValid(this.getClientSubnetInput())) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.wrongSubnetAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.error"), 0);
            if (this.ipVerCombo.getSelectedIndex() == 0) {
                this.clientSubnetPane.requestFocus();
            } else {
                this.clientSubnetIpv6Pane.requestFocus();
            }
            return false;
        }
        if (this.clientSubnetMaskCheckbox.isSelected() && !Utility.isValidSubnetMaskorCidr((String)this.getClientSubnetInput(), (String)this.getClientSubnetMaskFieldInput())) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.wrongSubnetMask"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.error"), 0);
            if (this.ipVerCombo.getSelectedIndex() == 0) {
                this.clientSubnetMaskField.requestFocus();
            } else if (this.ipVerCombo.getSelectedIndex() == 1) {
                this.clientSubnetMaskFieldIpv6.requestFocus();
            }
            return false;
        }
        int index = this.typeCmbBox.getSelectedIndex();
        switch (index) {
            case 0: {
                if (this.ipVerCombo.getSelectedIndex() == 0 && !this.ipPane.isValidValue()) {
                    JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.wrongIPAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.error"), 0);
                    this.ipPane.requestFocus();
                    return false;
                }
                if (this.ipVerCombo.getSelectedIndex() == 1 && !this.ipv6Pane.isValidValue()) {
                    JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.wrongIPAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.error"), 0);
                    this.ipv6Pane.requestFocus();
                    return false;
                }
                if (this.ipPortPane.isValidValue()) break;
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.wrongPort"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.error"), 0);
                this.ipPortPane.requestFocus();
                return false;
            }
            case 1: {
                if (!this.hostPane.isValidValue()) {
                    JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.wrongHostName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.error"), 0);
                    this.hostPane.requestFocus();
                    return false;
                }
                if (this.hostNamePortPane.isValidValue()) break;
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.wrongPort"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.error"), 0);
                this.hostNamePortPane.requestFocus();
                return false;
            }
            case 2: {
                if (this.ipVerCombo.getSelectedIndex() == 0 && !this.gupSubnetPane.isValidValue()) {
                    JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.wrongSubnetAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.error"), 0);
                    this.gupSubnetPane.requestFocus();
                    return false;
                }
                if (this.ipVerCombo.getSelectedIndex() != 1 || this.gupSubnetIpv6Pane.isValidValue()) break;
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.wrongSubnetAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.error"), 0);
                this.gupSubnetIpv6Pane.requestFocus();
                return false;
            }
        }
        return this.validateMapForExistance();
    }

    private String getClientSubnetMaskFieldInput() {
        String ipAddress = "";
        if (this.ipVerCombo.getSelectedIndex() == 0) {
            ipAddress = this.clientSubnetMaskField.getText();
        } else if (this.ipVerCombo.getSelectedIndex() == 1) {
            ipAddress = this.clientSubnetMaskFieldIpv6.getText();
        }
        return ipAddress;
    }

    private String getClientSubnetInput() {
        String ipAddress = "";
        if (this.ipVerCombo.getSelectedIndex() == 0) {
            ipAddress = this.clientSubnetPane.getText();
        } else if (this.ipVerCombo.getSelectedIndex() == 1) {
            ipAddress = this.clientSubnetIpv6Pane.getText();
        }
        return ipAddress;
    }

    private String getGupIpPaneInput() {
        String ipAddress = "";
        if (this.ipVerCombo.getSelectedIndex() == 0) {
            ipAddress = this.ipPane.getText();
        } else if (this.ipVerCombo.getSelectedIndex() == 1) {
            ipAddress = this.ipv6Pane.getText();
        }
        return ipAddress;
    }

    private String getGupSubnetPaneInput() {
        String ipAddress = "";
        if (this.ipVerCombo.getSelectedIndex() == 0) {
            ipAddress = this.gupSubnetPane.getText();
        } else if (this.ipVerCombo.getSelectedIndex() == 1) {
            ipAddress = this.gupSubnetIpv6Pane.getText();
        }
        return ipAddress;
    }

    @Override
    protected void commit() {
        if (this.mappingObj == null) {
            this.mappingObj = new ExplicitGupMappingUIObject();
        }
        this.mappingObj.setClientSubnetMaskSelected(this.clientSubnetMaskCheckbox.isSelected());
        this.mappingObj.setClientSubnetMask(this.getClientSubnetMaskFieldInput());
        this.mappingObj.setGupMappingType(this.indexTypeMap.get(this.typeCmbBox.getSelectedIndex()));
        this.mappingObj.setClientSubnet(this.getClientSubnetInput());
        int index = this.typeCmbBox.getSelectedIndex();
        switch (index) {
            case 0: {
                this.mappingObj.setGupMappingValue(this.getGupIpPaneInput());
                this.mappingObj.setPort(this.ipPortPane.getText());
                break;
            }
            case 1: {
                this.mappingObj.setGupMappingValue(this.hostPane.getText());
                this.mappingObj.setPort(this.hostNamePortPane.getText());
                break;
            }
            case 2: {
                this.mappingObj.setGupMappingValue(this.getGupSubnetPaneInput());
                this.mappingObj.setPort(null);
                break;
            }
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_explicit_gup_configuration";
    }

    private boolean validateMapForExistance() {
        int index = this.typeCmbBox.getSelectedIndex();
        String mappingType = this.indexTypeMap.get(index);
        ExplicitGupMappingUIObject uiObj = new ExplicitGupMappingUIObject();
        uiObj.setGupMappingType(mappingType);
        uiObj.setClientSubnet(this.getClientSubnetInput());
        switch (index) {
            case 0: {
                uiObj.setGupMappingValue(this.getGupIpPaneInput());
                uiObj.setPort(this.ipPortPane.getText());
                break;
            }
            case 1: {
                uiObj.setGupMappingValue(this.hostPane.getText());
                uiObj.setPort(this.hostNamePortPane.getText());
                break;
            }
            case 2: {
                uiObj.setGupMappingValue(this.getGupSubnetPaneInput());
                break;
            }
        }
        if (this.existingMaps == null) {
            return true;
        }
        if (this.existingMaps.containsKey(uiObj.getKeyFormat())) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ConfigureGupMappingDlg.error.mappingexists"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.error"), 0);
            return false;
        }
        return true;
    }

    private void setListener() {
        ActionListener checkboxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConfigureGupMappingDlg.this.updateSubnetMaskPanelEnableStatus();
            }
        };
        this.clientSubnetMaskCheckbox.addActionListener(checkboxListener);
    }

    private void jbInit(boolean isEdit) throws Exception {
        this.ipVerCombo = new JComboBox<String>(IP_VERSIONS);
        this.ipVerCombo.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ev) {
                ConfigureGupMappingDlg.this.ipVersionTypeChanged();
            }
        });
        this.ipPortPane = new PortPane(55);
        this.ipPortPane.setText(String.valueOf(2967));
        this.createIPPanel();
        this.createHostnamePanel();
        this.createGupSubnetPanel();
        this.createContentPanel();
        this.clientSubnetPane.setLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.clientsubnet.label"));
        this.clientSubnetIpv6Pane.setLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.clientsubnet.label"));
        this.clientSubnetMaskPanel.setLayout(new GridBagLayout());
        this.clientSubnetMaskPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        this.clientSubnetMaskCheckbox.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.clientsubnetmask.desc"));
        this.clientSubnetMaskFieldCardLayoutPanel.setLayout(new CardLayout());
        this.clientSubnetMaskFieldCardLayoutPanel.add((Component)this.clientSubnetMaskField, ADDRESS_IP_V4);
        this.clientSubnetMaskFieldCardLayoutPanel.add((Component)this.clientSubnetMaskFieldIpv6, ADDRESS_IP_V6);
        this.clientSubnetMaskFieldIpv6.setPreferredSize(new Dimension(165, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        this.hostPane.setPreferredFieldSize(165, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT);
        this.clientSubnetMaskPanel.add((Component)this.clientSubnetMaskCheckbox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 30), 0, 0));
        this.clientSubnetMaskPanel.add((Component)this.clientSubnetMaskFieldCardLayoutPanel, new GridBagConstraints(1, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 33, 0, 0), 0, 0));
        this.typeTable.put(addressTypes[0], this.gupIpPanel);
        this.typeTable.put(addressTypes[1], this.gupHostNamePanel);
        this.typeTable.put(addressTypes[2], this.gupSubnetPanel);
        CompoundBorder titledBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "ConfigureGupMappingDlg.border.explicitgupsettings")), BorderFactory.createEmptyBorder(5, 10, 10, 0));
        this.centerPanel.setBorder(titledBorder);
        this.centerPanel.setLayout(this.borderLayout1);
        this.comboPane.setLayout(new GridBagLayout());
        this.addressLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "AddressDlg.type"));
        this.typeCmbBox.setPreferredSize(new Dimension(135, 22));
        this.typeCmbBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent exc) {
                ConfigureGupMappingDlg.this.typeChanged();
            }
        });
        this.comboPane.add((Component)this.addressLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.comboPane.add(this.typeCmbBox, new GridBagConstraints(1, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 38, 0, 5), 0, 0));
        this.centerPanel.add((Component)this.comboPane, "Center");
        this.mainPane.setLayout(new CardLayout());
        Set<Map.Entry<String, JPanel>> entrySet = this.typeTable.entrySet();
        for (Map.Entry<String, JPanel> entry : entrySet) {
            String key = entry.getKey();
            Component value = entry.getValue();
            this.mainPane.add(value, key);
        }
        this.centerPanel.add((Component)this.mainPane, "South");
        this.typeIndexMap.put(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.mappingtype.ipaddress"), 0);
        this.typeIndexMap.put(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.mappingtype.hostname"), 1);
        this.typeIndexMap.put(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.mappingtype.subnet"), 2);
        this.indexTypeMap.put(0, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.mappingtype.ipaddress"));
        this.indexTypeMap.put(1, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.mappingtype.hostname"));
        this.indexTypeMap.put(2, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.mappingtype.subnet"));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setViewEditStatus(isEdit);
    }

    private void setViewEditStatus(boolean isEdit) {
        if (isEdit) {
            if (this.mappingObj == null || IPAddressUtil.isIPv4LiteralAddress((String)this.mappingObj.getClientSubnet())) {
                this.ipVerCombo.setSelectedIndex(0);
            } else {
                this.ipVerCombo.setSelectedIndex(1);
            }
            this.ipVerCombo.setEnabled(false);
            UIManager.put("ComboBox.disabledBackground", SystemColor.control);
            this.ipVerCombo.setBackground(SystemColor.control);
            this.clientSubnetPane.setEnabled(false);
            this.clientSubnetIpv6Pane.setEnabled(false);
        } else {
            this.ipVerCombo.setBackground(SystemColor.white);
            this.ipVerCombo.getEditor().getEditorComponent().setBackground(SystemColor.white);
            this.ipVerCombo.setSelectedIndex(0);
            this.ipVerCombo.setEnabled(true);
            this.clientSubnetPane.setEnabled(true);
            this.clientSubnetIpv6Pane.setEnabled(true);
            this.typeCmbBox.setSelectedIndex(0);
            this.clientSubnetMaskCheckbox.setSelected(false);
            this.updateSubnetMaskPanelEnableStatus();
        }
    }

    private void updateSubnetMaskPanelEnableStatus() {
        if (this.clientSubnetMaskCheckbox.isSelected()) {
            this.clientSubnetMaskField.setEnabled(true);
            this.clientSubnetMaskField.setBackground(SystemColor.white);
            this.clientSubnetMaskFieldIpv6.setEnabled(true);
            this.clientSubnetMaskFieldIpv6.setBackground(SystemColor.white);
        } else {
            this.clientSubnetMaskField.setEnabled(false);
            this.clientSubnetMaskField.setBackground(SystemColor.control);
            this.clientSubnetMaskFieldIpv6.setEnabled(false);
            this.clientSubnetMaskFieldIpv6.setBackground(SystemColor.control);
        }
    }

    private void setClientSubnetMaskField(ExplicitGupMappingUIObject mappingObj) {
        this.clientSubnetMaskCheckbox.setSelected(mappingObj.getClientSubnetMaskSelected());
        this.updateSubnetMaskPanelEnableStatus();
        if (this.ipVerCombo.getSelectedIndex() == 0) {
            this.clientSubnetMaskField.setText(mappingObj.getClientSubnetMask());
        } else if (this.ipVerCombo.getSelectedIndex() == 1) {
            this.clientSubnetMaskFieldIpv6.setText(mappingObj.getClientSubnetMask());
        }
    }

    private void setGupIpPane(ExplicitGupMappingUIObject mappingObj) {
        if (this.ipVerCombo.getSelectedIndex() == 0) {
            this.ipPane.setText(mappingObj.getGupMappingValue());
        } else if (this.ipVerCombo.getSelectedIndex() == 1) {
            this.ipv6Pane.setText(mappingObj.getGupMappingValue());
        }
    }

    private void setGupSubnetPane(ExplicitGupMappingUIObject mappingObj) {
        if (this.ipVerCombo.getSelectedIndex() == 0) {
            this.gupSubnetPane.setText(mappingObj.getGupMappingValue());
        } else if (this.ipVerCombo.getSelectedIndex() == 1) {
            this.gupSubnetIpv6Pane.setText(mappingObj.getGupMappingValue());
        }
    }

    private void setClientSubnetPane(ExplicitGupMappingUIObject mappingObj) {
        if (this.ipVerCombo.getSelectedIndex() == 0) {
            this.clientSubnetPane.setText(mappingObj.getClientSubnet());
        } else if (this.ipVerCombo.getSelectedIndex() == 1) {
            this.clientSubnetIpv6Pane.setText(mappingObj.getClientSubnet());
        }
    }

    private void updatePanel() {
        if (this.mappingObj != null) {
            this.setClientSubnetMaskField(this.mappingObj);
            String type = this.mappingObj.getGupMappingType();
            int index = this.typeIndexMap.get(type);
            this.setClientSubnetPane(this.mappingObj);
            this.typeCmbBox.setSelectedIndex(index);
            switch (index) {
                case 0: {
                    this.setGupIpPane(this.mappingObj);
                    this.ipPortPane.setText(this.mappingObj.getPort());
                    break;
                }
                case 1: {
                    this.hostPane.setText(this.mappingObj.getGupMappingValue());
                    this.hostNamePortPane.setText(this.mappingObj.getPort());
                    break;
                }
                case 2: {
                    this.setGupSubnetPane(this.mappingObj);
                    break;
                }
            }
        }
    }

    private void createIPPanel() {
        this.gupIpPanel.setLayout(new GridBagLayout());
        this.gupIpPaneCardLayoutPanel.setLayout(new CardLayout());
        this.gupIpPaneCardLayoutPanel.add((Component)this.ipPane, ADDRESS_IP_V4);
        this.gupIpPaneCardLayoutPanel.add((Component)this.ipv6Pane, ADDRESS_IP_V6);
        this.gupIpPanel.add((Component)this.gupIpPaneCardLayoutPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, -5), 0, 0));
        this.gupIpPanel.add((Component)this.ipPortPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, -5), 0, 0));
    }

    private void createHostnamePanel() {
        this.gupHostNamePanel.setLayout(new GridBagLayout());
        this.gupHostNamePanel.add((Component)this.hostPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, -5), 0, 0));
        this.gupHostNamePanel.add((Component)this.hostNamePortPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, -5), 0, 0));
    }

    private void createGupSubnetPanel() {
        this.gupSubnetPane.setLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.gupsubnet.label"));
        this.gupSubnetIpv6Pane.setLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPMappingDlg.gupsubnet.label"));
        this.gupSubnetPanel.setLayout(new GridBagLayout());
        this.gupSubnetPanel.add((Component)this.gupSubnetDesc, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 12, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.gupSubnetPaneCardLayoutPanel.setLayout(new CardLayout());
        this.gupSubnetPaneCardLayoutPanel.add((Component)this.gupSubnetPane, ADDRESS_IP_V4);
        this.gupSubnetPaneCardLayoutPanel.add((Component)this.gupSubnetIpv6Pane, ADDRESS_IP_V6);
        this.gupSubnetPanel.add((Component)this.gupSubnetPaneCardLayoutPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, -5), 0, 0));
    }

    private void createContentPanel() {
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.contentPanel.setLayout(new GridBagLayout());
        this.contentPanel.add((Component)this.ipDesc, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 12, 2, new Insets(0, 10, 0, 0), 0, 0));
        JPanel ipVersionPanel = new JPanel();
        ipVersionPanel.setLayout(new BorderLayout(5, 5));
        ipVersionPanel.add((Component)this.ipVerLabel, "West");
        ipVersionPanel.add(this.ipVerCombo, "Center");
        this.contentPanel.add((Component)ipVersionPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        JPanel innerContentPanel = new JPanel();
        CompoundBorder titledBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        innerContentPanel.setBorder(titledBorder);
        innerContentPanel.setLayout(new GridBagLayout());
        this.clientSubnetPaneCardLayoutPanel.setLayout(new CardLayout());
        this.clientSubnetPaneCardLayoutPanel.add((Component)this.clientSubnetPane, ADDRESS_IP_V4);
        this.clientSubnetPaneCardLayoutPanel.add((Component)this.clientSubnetIpv6Pane, ADDRESS_IP_V6);
        innerContentPanel.add((Component)this.clientSubnetPaneCardLayoutPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        innerContentPanel.add((Component)this.clientSubnetMaskPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        innerContentPanel.add((Component)this.centerPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.contentPanel.add((Component)innerContentPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
    }

    public ExplicitGupMappingUIObject getObject() {
        return this.mappingObj;
    }
}

