/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.configobject.schema.LuContentCategory;
import com.sygate.scm.common.configobject.schema.LuContentCategoryGroup;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.av.common.DashLine;
import com.sygate.scm.console.ui.policy.lu.LuCategoryPanel;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateContentObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuAppliedContentObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CategoryGroupPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1287395812381689746L;
    private List<LuCategoryPanel> categoryPanels = new ArrayList<LuCategoryPanel>();
    private String helpToken;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";

    public CategoryGroupPanel(LuContentCategoryGroup categoryGroup) {
        this.initialize(categoryGroup);
        this.helpToken = "sesm_policies_dialog_luc_catetory_group_" + categoryGroup.getName().toLowerCase();
    }

    public void setObject(LiveUpdateContentObject luObj) {
        for (int i = 0; i < this.categoryPanels.size(); ++i) {
            this.categoryPanels.get(i).setObject(luObj);
        }
    }

    public void setReadOnly() {
        for (int i = 0; i < this.categoryPanels.size(); ++i) {
            this.categoryPanels.get(i).setReadOnly();
        }
    }

    private boolean hasActiveCategoryPanels() {
        boolean tf = false;
        for (int i = 0; i < this.categoryPanels.size(); ++i) {
            if (!this.categoryPanels.get(i).isActive()) continue;
            tf = true;
            break;
        }
        return tf;
    }

    protected boolean isValidate() {
        if (!this.hasActiveCategoryPanels()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(LU, "LuContentPolicyDialog.noActiveCategory"), MSGRES.getString(LU, "LuContentPolicyDialog.errorDlgTitle"), -1);
            return false;
        }
        return true;
    }

    public List<LuAppliedContentObject> save() {
        ArrayList<LuAppliedContentObject> contents = new ArrayList<LuAppliedContentObject>();
        for (int i = 0; i < this.categoryPanels.size(); ++i) {
            LuAppliedContentObject obj = this.categoryPanels.get(i).save();
            if (obj == null) continue;
            contents.add(obj);
        }
        return contents;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return this.helpToken;
    }

    private void initialize(LuContentCategoryGroup categoryGroup) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.createDescriptionPanel(categoryGroup), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 10, 20), 0, 0));
        Vector luCategories = categoryGroup.getLuContentCategory();
        LicenseObject licenseObject = LicenseObject.getInstance();
        for (int i = 0; i < luCategories.size(); ++i) {
            LuContentCategory luCategory = (LuContentCategory)luCategories.get(i);
            if (Utility.getBooleanValue((Boolean)luCategory.getOptServerOnly(), (Boolean)luCategory.getDefServerOnly()) || !Utility.getBooleanValue((Boolean)luCategory.getOptNamedRevisionAllowed(), (Boolean)luCategory.getDefNamedRevisionAllowed()) || !licenseObject.isQualifiedLuContentCategory(luCategory.getName())) continue;
            LuCategoryPanel categoryPanel = new LuCategoryPanel(luCategory);
            this.categoryPanels.add(categoryPanel);
            if ("DEC_ABI".equals(categoryPanel.getType()) || "SYN_APPS".equals(categoryPanel.getType())) continue;
            panel.add((Component)categoryPanel, new GridBagConstraints(0, i + 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 10, 20), 0, 0));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "North");
    }

    private JPanel createDescriptionPanel(LuContentCategoryGroup categoryGroup) {
        DescriptionTextArea descTextArea = new DescriptionTextArea(MSGRES.getString(LU, "LuContentPolicyDialog.contentPolicyUsage"));
        descTextArea.setForeground(UIColorUtilities.SOFT_FOREGROUND);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)descTextArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new DashLine(UIColorUtilities.CONTROL_BACKGROUND), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }
}

