/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.lu;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.lu.logiobject.LuGeneralConfigObject;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AdvancePanel
extends JPanel
implements ContentSensitiveHelpPage,
ActionListener {
    private static final long serialVersionUID = 3661560321904983672L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String LU = "com.sygate.scm.console.ui.policy.lu.lu";
    private JCheckBox jChkModify = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "AdvancePanel.checkbox.Modify"));
    private JCheckBox jChkLaunch = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "AdvancePanel.checkbox.Launch"));
    private JCheckBox jChkProxy = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "AdvancePanel.checkbox.Proxy"));
    private JCheckBox jChkDownloadSecurityUpdates = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "AdvancePanel.checkbox.downloadSecurityUpdates"));
    private JCheckBox jChkUseLuForSmallerAvContentPackages = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.policy.lu.lu", "AdvancePanel.checkbox.useLuForSmallerAvContentPackages"));
    private LuGeneralConfigObject configObj;
    private boolean isReadOnly = false;

    public AdvancePanel() {
        this.initialize();
    }

    public void setObject(LuGeneralConfigObject configObj) {
        this.configObj = configObj;
        this.jChkModify.setSelected(configObj.isAllowLocalScheduleChange());
        this.jChkLaunch.setSelected(configObj.isAllowManualLiveUpdate());
        this.jChkProxy.setSelected(configObj.isAllowLocalProxySettingChange());
        this.jChkUseLuForSmallerAvContentPackages.setSelected(configObj.isUseLUForSmallerAVContentPackagesEnabled());
        this.jChkDownloadSecurityUpdates.setSelected(configObj.isAllowClientPatchDownload());
        this.setLuLaunchSettings();
    }

    public void save() {
        this.configObj.setAllowLocalScheduleChange(this.jChkModify.isSelected());
        this.configObj.setAllowManualLiveUpdate(this.jChkLaunch.isSelected());
        this.configObj.setAllowLocalProxySettingChange(this.jChkProxy.isSelected());
        this.configObj.setUseLUForSmallerAVContentPackages(this.jChkUseLuForSmallerAvContentPackages.isSelected());
        this.configObj.setAllowClientPatchDownload(this.jChkDownloadSecurityUpdates.isSelected());
    }

    public void setReadOnly() {
        this.isReadOnly = true;
        this.jChkModify.setEnabled(false);
        this.jChkLaunch.setEnabled(false);
        this.jChkProxy.setEnabled(false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_lu_advenced";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            boolean selected = ((AbstractButton)e.getSource()).isSelected();
            this.setEnabled(this.jChkLaunch, selected);
            this.setEnabled(this.jChkProxy, selected);
            this.setEnabled(this.jChkUseLuForSmallerAvContentPackages, selected);
            this.setLuLaunchSettings();
        }
    }

    private void initialize() {
        this.setLayout(new VerticalFlowLayout(0, 0));
        this.add(this.getSecuritySettingPanel());
        this.add(this.getSecurityUpdateSettingPanel());
        this.add(this.getContentSizeManagementPanel());
    }

    private JPanel getSecuritySettingPanel() {
        this.jChkLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AdvancePanel.this.setLuLaunchSettings();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 20, 0, 0));
        panel.add((Component)this.jChkLaunch, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jChkModify, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 0), 0, 0));
        panel.add((Component)this.jChkProxy, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 5, 0));
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "AdvancePanel.label.securitySetting"), MSGRES.getString(LU, "AdvancePanel.label.securitySettingDesc"), false), "North");
        wrapPanel.add((Component)panel, "West");
        return wrapPanel;
    }

    private JPanel getSecurityUpdateSettingPanel() {
        JPanel panel = new JPanel(new FlowLayout(3));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        this.jChkDownloadSecurityUpdates.addActionListener(e -> {
            if (this.jChkDownloadSecurityUpdates.isSelected()) {
                String title = MSGRES.getString(LU, "AdvancePanel.rebootReminder.title");
                String message = MSGRES.getString(LU, "AdvancePanel.rebootReminder.message");
                JOptionPane.showMessageDialog(this, message, title, 2);
            }
        });
        panel.add(this.jChkDownloadSecurityUpdates);
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(5, 20, 0, 0));
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "AdvancePanel.label.SecurityUpdateSetting"), MSGRES.getString(LU, "AdvancePanel.label.SecurityUpdateSettingDesc"), false), "North");
        wrapPanel.add((Component)panel, "Center");
        return wrapPanel;
    }

    private JPanel getContentSizeManagementPanel() {
        JPanel panel = new JPanel(new FlowLayout(3));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        panel.add(this.jChkUseLuForSmallerAvContentPackages);
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        wrapPanel.add((Component)new AvTemplatePane(MSGRES.getString(LU, "AdvancePanel.label.contentSizeManagement"), MSGRES.getString(LU, "AdvancePanel.label.contentSizeManagementDesc"), false), "North");
        wrapPanel.add((Component)panel, "Center");
        return wrapPanel;
    }

    private void setLuLaunchSettings() {
        boolean isEnabled = this.jChkLaunch.isEnabled() && this.jChkLaunch.isSelected();
        this.jChkModify.setEnabled(isEnabled);
    }

    private void setEnabled(Component component, boolean value) {
        if (!this.isReadOnly) {
            component.setEnabled(value);
        }
    }
}

