/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.logicobject;

import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.LuDownloadedContent;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.ids.handler.IdsLuHandler;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsMetadataEvent;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsMetadataObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.PepMetadataEvent;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WinIdsMetadataObject
extends IdsMetadataObject {
    private static Map<String, IdsMetadataEvent> eventMap = new LinkedHashMap<String, IdsMetadataEvent>();
    private static Vector<TableRow> pepRules = new Vector();
    private static WinIdsMetadataObject curMetadata;

    private WinIdsMetadataObject() throws ConsoleException {
        this.initializePepData();
    }

    public static void refreshNewInstance() throws ConsoleException {
        curMetadata = null;
    }

    public static IdsMetadataEvent getMetadataEvent(String eventId) throws ConsoleException {
        WinIdsMetadataObject.getCurrentObject();
        return eventMap.get(eventId);
    }

    public static List<IdsMetadataEvent> getIdsMetadataEventList() throws ConsoleException {
        WinIdsMetadataObject.getCurrentObject();
        return new ArrayList<IdsMetadataEvent>(eventMap.values());
    }

    public static Vector<TableRow> getPepMetadataEventList() throws ConsoleException {
        WinIdsMetadataObject.getCurrentObject();
        return pepRules;
    }

    public static WinIdsMetadataObject getCurrentObject() throws ConsoleException {
        if (curMetadata == null) {
            curMetadata = new WinIdsMetadataObject();
        }
        return curMetadata;
    }

    @Override
    public IdsMetadataEvent setToMap(IdsMetadataEvent event) {
        IdsMetadataEvent oldEvent = eventMap.put(event.getId(), event);
        return oldEvent;
    }

    @Override
    protected String getIDSFileName(LuDownloadedContent content) {
        this.msg("getIPSFileName", "expected moniker is {F37A1C53-EF4C-4784-986E-C5C511D518B2}");
        return "IPSMetadata3.xml";
    }

    @Override
    protected String getPEPFileName(LuDownloadedContent content) {
        this.msg("getPEPFileName", "moniker is " + content.getServerMoniker());
        return "IPSMetadata3.xml";
    }

    private void msg(String method, String msg) {
        ConsoleLogger.log("WinIdsMetadataObject>>" + method + ">" + msg);
    }

    @Override
    protected boolean isIPSContent(LuDownloadedContent content) {
        if ("{5E614C71-552C-4DD2-B466-F23A4B46880B}".equalsIgnoreCase(content.getServerMoniker())) {
            this.msg("isIPSContent", "returns false");
            return false;
        }
        this.msg("isIPSContent", "returns true");
        return true;
    }

    @Override
    public void clearMap() {
        eventMap.clear();
    }

    @Override
    protected List<IdsMetadataObject.ProductState> getState(Element eventElemt) {
        String state = "";
        ArrayList<IdsMetadataObject.ProductState> list = new ArrayList<IdsMetadataObject.ProductState>();
        ArrayList productList = XMLHelper.getChildElementByName((Element)eventElemt, (String)"ProductList");
        if (productList != null && productList.size() == 1) {
            ArrayList products = XMLHelper.getChildElementByName((Element)((Element)productList.get(0)), (String)"Product");
            for (int i = 0; i < products.size(); ++i) {
                Element product = (Element)products.get(i);
                String name = XMLHelper.getAttribute((Element)product, (String)"Name");
                if ("SEP_2021".equals(name)) {
                    state = XMLHelper.getAttribute((Element)product, (String)"State");
                    list.add(new IdsMetadataObject.ProductState(state, false));
                }
                if (!"SEP_2021_Server".equals(name) || "D".equals(state = XMLHelper.getAttribute((Element)product, (String)"State"))) continue;
                list.add(new IdsMetadataObject.ProductState(state, true));
            }
        }
        return list;
    }

    public Vector<TableRow> getPepRules(InputStream in) throws IOException, SAXException {
        this.msg("getPepRules", "enter");
        HashMap<String, String> namePathMap = new HashMap<String, String>();
        Document doc = XMLHelper.parse((InputStream)in);
        Element root = doc.getDocumentElement();
        System.out.println(doc.toString());
        ArrayList issueList = XMLHelper.getChildElementByName((Element)root, (String)"Issue");
        for (Element issue : issueList) {
            ArrayList allElemt = XMLHelper.getChildElementByName((Element)issue, (String)"Event");
            for (Element eventElement : allElemt) {
                ArrayList processesElementList;
                Element engineType;
                ArrayList engineTypeElementList = XMLHelper.getChildElementByName((Element)eventElement, (String)"EngineType");
                if (engineTypeElementList == null || engineTypeElementList.size() == 0 || engineTypeElementList.size() > 1 || !(engineType = (Element)engineTypeElementList.get(0)).getTextContent().equalsIgnoreCase("PEP") || (processesElementList = XMLHelper.getChildElementByName((Element)eventElement, (String)"Processes")) == null || processesElementList.size() <= 0) continue;
                Element processesElement = (Element)processesElementList.get(0);
                ArrayList processElementList = XMLHelper.getChildElementByName((Element)processesElement, (String)"Process");
                for (Element process : processElementList) {
                    namePathMap.put(process.getAttribute("Name"), process.getAttribute("Path"));
                }
            }
        }
        HashMap<String, String> uniqueMap = new HashMap<String, String>();
        Set entrySet = namePathMap.entrySet();
        for (Map.Entry entry : entrySet) {
            String compareValue = (String)uniqueMap.get(entry.getKey());
            if (compareValue != null && compareValue.equals(entry.getValue())) continue;
            uniqueMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        Vector<TableRow> rows = new Vector<TableRow>();
        entrySet = uniqueMap.entrySet();
        for (Map.Entry entry : entrySet) {
            PepMetadataEvent event = new PepMetadataEvent();
            event.setName((String)entry.getKey());
            event.setPath((String)entry.getValue());
            event.setEnabled(true);
            rows.add(event);
        }
        return rows;
    }

    private static void clearPepRules() {
        pepRules = new Vector();
    }

    private void initializePepData() throws ConsoleException {
        this.msg("initializePepData", "enter");
        InputStream inputStream = null;
        WinIdsMetadataObject.clearPepRules();
        InputStream idsMetadataFileInputStream = null;
        ByteArrayInputStream allDataInputStream = null;
        try {
            LuDownloadedContent sepmMetadataContent = IdsLuHandler.getLatestSepmMetadataContent();
            if (sepmMetadataContent != null) {
                this.msg("initializePepData", "received SEPM metadata content");
                ObjReference ref = sepmMetadataContent.getOptObjReference();
                if (ref == null) {
                    this.msg("initializePepData", "full is not present so throw exception object not found");
                    throw new ConsoleException(0x16010000);
                }
                PhysicalFile pFile = DataobjectManager.getInstance().getPhysicalFile(ref.getTargetId());
                ObjReference fRef = pFile.getObjReference();
                inputStream = GUIManager.getFile(fRef.getTargetId());
                allDataInputStream = this.convertBackendInputStream(inputStream);
                IOUtilities.closeInputStream((InputStream)inputStream);
                inputStream = null;
                if (allDataInputStream != null) {
                    String fileName = this.getPEPFileName(sepmMetadataContent);
                    idsMetadataFileInputStream = this.getMetadataFile(allDataInputStream, fileName);
                    if (idsMetadataFileInputStream != null) {
                        this.msg("initializePepData", "got IPMetadata3.xml");
                        pepRules = this.getPepRules(idsMetadataFileInputStream);
                        IOUtilities.closeInputStream((InputStream)idsMetadataFileInputStream);
                        idsMetadataFileInputStream = null;
                    } else {
                        this.msg("initializePepData", "IPMetadata3.xml was null");
                    }
                    IOUtilities.closeInputStream((InputStream)allDataInputStream);
                    allDataInputStream = null;
                }
            }
        }
        catch (SAXException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
        catch (IOException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
        finally {
            IOUtilities.closeInputStream(idsMetadataFileInputStream);
            IOUtilities.closeInputStream(allDataInputStream);
            IOUtilities.closeInputStream(inputStream);
        }
    }
}

