/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.Action;
import com.sygate.scm.common.configobject.schema.Executable;
import com.sygate.scm.common.configobject.schema.IdsSignature;
import com.sygate.scm.common.configobject.schema.IdsTrafficCondition;
import com.sygate.scm.common.configobject.schema.LogProcess;
import com.sygate.scm.common.configobject.schema.PacketProcess;
import com.sygate.scm.common.configobject.schema.SoApplicationContainer;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.ApplicationContainerObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.BooleanWrapper;
import com.sygate.scm.util.GUIDGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class IdsSignatureObject
implements TableRow,
CopitableObject {
    private IdsSignature idsSignature;
    private ApplicationContainerObject applicationContainerObject;

    public IdsSignatureObject(IdsSignature idsSignature) {
        this.idsSignature = idsSignature;
    }

    public IdsSignatureObject() {
        this.idsSignature = new IdsSignature();
        this.idsSignature.setId(new GUIDGenerator().getGUIDString());
        IdsTrafficCondition trafficCond = new IdsTrafficCondition();
        this.idsSignature.setIdsTrafficCondition(trafficCond);
        this.idsSignature.setOptEnable(Boolean.valueOf(true));
        Action action = new Action();
        this.idsSignature.setAction(action);
    }

    private int getIndexOf(List<SoApplicationContainer> allContainer, String containerName) {
        int index = -1;
        Iterator<SoApplicationContainer> it = allContainer.iterator();
        int i = 0;
        while (it.hasNext()) {
            SoApplicationContainer container = it.next();
            if (containerName.equalsIgnoreCase(container.getOptContainerName())) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private String getActionAsString() {
        Integer action = this.getAction();
        if (action == null) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureObject.ActionAllow");
        }
        int actionInt = action;
        if (actionInt == 0) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureObject.ActionAllow");
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureObject.ActionDrop");
    }

    public IdsSignature getIdsSignature() {
        return this.idsSignature;
    }

    public Boolean isEnabled() {
        if (this.idsSignature.getOptEnable() == null) {
            return this.idsSignature.getDefEnable();
        }
        return this.idsSignature.getOptEnable();
    }

    public void setEnabled(Boolean enabled) {
        this.idsSignature.setOptEnable(enabled);
    }

    public void setName(String name) {
        this.idsSignature.setName(name);
    }

    public String getName() {
        return this.idsSignature.getName();
    }

    public void setDesc(String desc) {
        this.idsSignature.setOptDescription(desc);
    }

    public String getDesc() {
        return this.idsSignature.getOptDescription();
    }

    public void setSeverty(Long severity) {
        this.idsSignature.setSeverity(severity);
    }

    public Long getSeverity() {
        return this.idsSignature.getSeverity();
    }

    public String getTrafficCondition() {
        IdsTrafficCondition trafficCond = this.idsSignature.getIdsTrafficCondition();
        if (trafficCond != null) {
            return trafficCond.getContent();
        }
        return null;
    }

    public void setTrafficCondition(String content) {
        IdsTrafficCondition trafficCond = this.idsSignature.getIdsTrafficCondition();
        if (trafficCond == null) {
            trafficCond = new IdsTrafficCondition();
            this.idsSignature.setIdsTrafficCondition(trafficCond);
        }
        trafficCond.setContent(content);
    }

    public ApplicationContainerObject getApplicationContainer() {
        if (this.applicationContainerObject == null) {
            SoApplicationContainer predefined_container = null;
            SoApplicationContainer user_container = null;
            for (int i = 0; i < this.idsSignature.getSoApplicationContainerCount(); ++i) {
                SoApplicationContainer c = this.idsSignature.getSoApplicationContainer(i);
                if (c.getOptContainerName().equalsIgnoreCase("PREDEFINED")) {
                    predefined_container = c;
                    continue;
                }
                user_container = c;
            }
            this.applicationContainerObject = new ApplicationContainerObject(predefined_container, user_container);
        }
        return this.applicationContainerObject;
    }

    public void setApplicationContainer() {
        SoApplicationContainer user;
        Vector allContainer = this.idsSignature.getSoApplicationContainer();
        SoApplicationContainer predefined = this.applicationContainerObject.getPredefinedContainer();
        if (predefined != null) {
            int index = this.getIndexOf(allContainer, "PREDEFINED");
            if (index != -1) {
                this.idsSignature.setSoApplicationContainer(index, predefined);
            } else {
                this.idsSignature.addSoApplicationContainer(predefined);
            }
        }
        if ((user = this.applicationContainerObject.getUserContainer()) != null) {
            int index = this.getIndexOf(allContainer, "USER_DEFINED");
            if (index != -1) {
                this.idsSignature.setSoApplicationContainer(index, user);
            } else {
                this.idsSignature.addSoApplicationContainer(user);
            }
        }
    }

    public Integer getAction() {
        PacketProcess packetProcess;
        Action action = this.idsSignature.getAction();
        if (action != null && (packetProcess = action.getOptPacketProcess()) != null) {
            return packetProcess.getPacketProcess();
        }
        return PacketProcess.DROP;
    }

    public void setAction(Integer packetProcess) {
        Action action = this.idsSignature.getAction();
        if (action == null) {
            action = new Action();
            PacketProcess pckProcess = new PacketProcess();
            pckProcess.setPacketProcess(packetProcess);
            action.setOptPacketProcess(pckProcess);
        } else {
            PacketProcess pckProcess = action.getOptPacketProcess();
            if (pckProcess == null) {
                pckProcess = new PacketProcess();
                action.setOptPacketProcess(pckProcess);
            }
            pckProcess.setPacketProcess(packetProcess);
        }
    }

    public void setTrack(Boolean track) {
        Action action = this.idsSignature.getAction();
        if (action == null) {
            action = new Action();
            LogProcess logProcess = new LogProcess();
            logProcess.setOptLogRawTraffic(track);
            action.setOptLogProcess(logProcess);
        } else {
            LogProcess logProcess = action.getOptLogProcess();
            if (logProcess == null) {
                logProcess = new LogProcess();
                action.setOptLogProcess(logProcess);
            }
            logProcess.setOptLogRawTraffic(track);
        }
    }

    public BooleanWrapper getTrack() {
        LogProcess logProcess;
        Action action = this.idsSignature.getAction();
        if (action != null && (logProcess = action.getOptLogProcess()) != null) {
            if (logProcess.getOptLogRawTraffic().booleanValue()) {
                return BooleanWrapper.TRUE_VALUE;
            }
            return BooleanWrapper.FALSE_VALUE;
        }
        return BooleanWrapper.NULL_VALUE;
    }

    public String getTrackAsString() {
        BooleanWrapper track = this.getTrack();
        if (track != null && !track.isNull() && track.booleanValue()) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureObject.LogToPacket");
        }
        return null;
    }

    public void setLogEventAs(Integer hostType) {
        this.idsSignature.setOptHostType(hostType);
    }

    public Integer getLogEventAs() {
        return this.idsSignature.getOptHostType();
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.isEnabled();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getTrafficCondition();
            }
            case 3: {
                return this.getApplicationContainer();
            }
            case 4: {
                return this.getActionAsString();
            }
            case 5: {
                return this.getTrackAsString();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
        if (index == 0) {
            this.idsSignature.setOptEnable((Boolean)value);
        }
    }

    public IdsSignatureObject getClone() throws ConsoleException {
        try {
            byte[] copyArray = this.idsSignature.getBytes();
            AbstractSchema newSignature = AbstractSchema.readXML((byte[])copyArray);
            IdsSignatureObject newObj = new IdsSignatureObject((IdsSignature)newSignature);
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        try {
            String name;
            WashIDHandler washer = new WashIDHandler();
            HashMap<String, TopLevelObject> createdObj = new HashMap<String, TopLevelObject>();
            IdsSignature newSig = (IdsSignature)washer.duplicateObject((ConfigObject)this.idsSignature, createdObj);
            Vector appContainerList = newSig.getSoApplicationContainer();
            ArrayList newList = new ArrayList(appContainerList);
            SoApplicationContainer firstContainer = null;
            for (SoApplicationContainer appContainer : newList) {
                if (firstContainer == null) {
                    firstContainer = appContainer;
                    continue;
                }
                Vector allExecutable = appContainer.getExecutable();
                for (Executable exe : allExecutable) {
                    firstContainer.addExecutable(exe);
                }
                newSig.removeSoApplicationContainer(appContainer);
            }
            if (firstContainer != null && (name = firstContainer.getOptContainerName()) != null && name.equalsIgnoreCase("PREDEFINED")) {
                firstContainer.setOptContainerName("USER_DEFINED");
            }
            IdsSignatureObject newObj = new IdsSignatureObject(newSig);
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }
}

