/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.ExceptionEvent;
import com.sygate.scm.common.configobject.schema.ExceptionList;
import com.sygate.scm.common.configobject.schema.IdsPolicy;
import com.sygate.scm.common.configobject.schema.MacExceptionList;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.IDSObject;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsEventObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsMetadataEvent;
import com.sygate.scm.console.ui.policy.ids.logicobject.MacIPSMetadataObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.WinIdsMetadataObject;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class IdsPolicyObject
extends PolicyIntObjectBase
implements TableRow {
    private IDSObject idsObj;
    private Boolean enabled = false;
    private final DateFormat sdf = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());

    public IdsPolicyObject(IdsPolicy fwIdsLibrary) {
        super((TopLevelObject)fwIdsLibrary);
    }

    public IdsPolicyObject(PolicyIntObjectBase policyObject) {
        super(policyObject);
    }

    public IdsPolicyObject(TopLevelObject policy) {
        super(policy);
    }

    public IdsPolicyObject() {
        HashMap<String, TopLevelObject> newObj = new HashMap<String, TopLevelObject>();
        try {
            this.policy = PolicyHandler.getDefaultIdsPolicy(newObj);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        if (this.policy == null) {
            this.policy = new IdsPolicy();
            IdsPolicy idsPolicy = (IdsPolicy)this.policy;
            idsPolicy.setId(new GUIDGenerator().getGUIDString());
            idsPolicy.setName(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsPolicyObject.DefaultPolicyName"));
            idsPolicy.setOptCreator(AdminObject.retrieveCurrentAdminObject().getName());
        }
    }

    public void deleteEvent(IdsEventObject eventObj) {
        ExceptionEvent event = eventObj.getEvent();
        this.removeFromList(event);
    }

    public void deleteMacEvent(IdsEventObject eventObj) {
        ExceptionEvent event = eventObj.getEvent();
        this.removeFromMacList(event);
    }

    public void addEvent(IdsEventObject eventObj) {
        ExceptionEvent event = eventObj.getEvent();
        IdsPolicy idsPolicy = this.getIdsPolicy();
        ExceptionList eList = idsPolicy.getOptExceptionList();
        if (eList == null) {
            eList = new ExceptionList();
            idsPolicy.setOptExceptionList(eList);
        }
        eList.addExceptionEvent(event);
    }

    public void addMacEvent(IdsEventObject eventObj) {
        ExceptionEvent event = eventObj.getEvent();
        IdsPolicy idsPolicy = this.getIdsPolicy();
        MacExceptionList eList = idsPolicy.getOptMacExceptionList();
        if (eList == null) {
            eList = new MacExceptionList();
            idsPolicy.setOptMacExceptionList(eList);
        }
        eList.addExceptionEvent(event);
    }

    @Override
    protected PolicyObjectBase createPolicyObject(TopLevelObject policyObj) throws ConsoleException {
        if (!(policyObj instanceof IdsPolicy)) {
            throw new ConsoleException(302645248, 32);
        }
        IdsPolicyObject newObj = new IdsPolicyObject((IdsPolicy)policyObj);
        return newObj;
    }

    private void removeFromList(ExceptionEvent event) {
        IdsPolicy idsPolicy = this.getIdsPolicy();
        ExceptionList eList = idsPolicy.getOptExceptionList();
        if (eList != null) {
            eList.removeExceptionEvent(event);
        }
    }

    private void removeFromMacList(ExceptionEvent event) {
        IdsPolicy idsPolicy = this.getIdsPolicy();
        MacExceptionList eList = idsPolicy.getOptMacExceptionList();
        if (eList != null) {
            eList.removeExceptionEvent(event);
        }
    }

    public IdsPolicy getIdsPolicy() {
        return (IdsPolicy)this.policy;
    }

    @Override
    public String getTargetName() {
        return "IdsPolicyApplied";
    }

    @Override
    public String getTargetType() {
        return "IdsPolicy";
    }

    @Override
    public String getRefTargetName() {
        return ((IdsPolicy)this.policy).getName();
    }

    @Override
    public String getLocalReferenceName() {
        return "LocalIdsPolicy";
    }

    @Override
    public String getTypeDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryObject.IPSLibraryDesc");
    }

    public void setDesc(String desc) {
        ((IdsPolicy)this.policy).setOptDescription(desc);
    }

    public void setIDS(IDSObject idsObj) {
        this.idsObj = idsObj;
        if (idsObj == null) {
            return;
        }
        this.enabled = idsObj.isExisting(this.getIdsPolicy().getId());
    }

    @Override
    public Object getValueAt(int column) {
        switch (column) {
            case 0: {
                return this.enabled;
            }
            case 1: {
                return ((IdsPolicy)this.policy).getName();
            }
            case 2: {
                return ((IdsPolicy)this.policy).getOptDescription();
            }
            case 3: {
                return "N/A";
            }
            case 4: {
                long latestT = PolicyHandler.getLatestT((ConfigObject)this.policy);
                Date updateTime = new Date(latestT);
                return this.sdf.format(updateTime);
            }
        }
        return "This should not happen";
    }

    @Override
    public Class<?> getValueTypeAt(int column) {
        switch (column) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Date.class;
            }
        }
        return String.class;
    }

    public IdsPolicyObject getClone() throws ConsoleException {
        try {
            System.out.println("Id :" + ((IdsPolicy)this.policy).getId());
            byte[] copyArray = ((IdsPolicy)this.policy).getBytes();
            AbstractSchema newLibrary = AbstractSchema.readXML((byte[])copyArray);
            IdsPolicyObject newObj = new IdsPolicyObject((IdsPolicy)newLibrary);
            newObj.setIDS(this.idsObj);
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public boolean isDirty() {
        return true;
    }

    @Override
    public int getItemType() {
        if (this.policy != null && this.policy instanceof IdsPolicy) {
            return 143;
        }
        return 65;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    @Override
    public String getCreator() {
        return this.getIdsPolicy().getOptCreator();
    }

    @Override
    public void setCreator(String creator) {
    }

    public List<IdsEventObject> getExceptionList() throws ConsoleException {
        ArrayList<IdsEventObject> all = new ArrayList<IdsEventObject>();
        IdsPolicy idsPolicy = this.getIdsPolicy();
        ExceptionList exceptionList = idsPolicy.getOptExceptionList();
        if (exceptionList != null) {
            Vector allException = exceptionList.getExceptionEvent();
            for (ExceptionEvent event : allException) {
                IdsMetadataEvent metadata = WinIdsMetadataObject.getMetadataEvent(event.getEventId());
                if (metadata != null) {
                    IdsEventObject eventObj = new IdsEventObject(event, metadata);
                    all.add(eventObj);
                    continue;
                }
                this.removeFromList(event);
            }
        }
        return all;
    }

    public List<IdsEventObject> getMacExceptionList() throws ConsoleException {
        ArrayList<IdsEventObject> all = new ArrayList<IdsEventObject>();
        IdsPolicy idsPolicy = this.getIdsPolicy();
        MacExceptionList exceptionList = idsPolicy.getOptMacExceptionList();
        if (exceptionList != null) {
            Vector allException = exceptionList.getExceptionEvent();
            for (ExceptionEvent event : allException) {
                IdsMetadataEvent metadata = MacIPSMetadataObject.getMetadataEvent(event.getEventId());
                if (metadata != null) {
                    IdsEventObject eventObj = new IdsEventObject(event, metadata);
                    all.add(eventObj);
                    continue;
                }
                this.removeFromMacList(event);
            }
        }
        return all;
    }

    public void setExceptionList(List<IdsEventObject> exceptionObjList) {
        IdsPolicy idsPolicy = this.getIdsPolicy();
        ExceptionList exceptionList = new ExceptionList();
        idsPolicy.setOptExceptionList(exceptionList);
        for (IdsEventObject eventObj : exceptionObjList) {
            exceptionList.addExceptionEvent(eventObj.getEvent());
        }
    }

    public void setMacExceptionList(List<IdsEventObject> exceptionObjList) {
        IdsPolicy idsPolicy = this.getIdsPolicy();
        MacExceptionList exceptionList = new MacExceptionList();
        idsPolicy.setOptMacExceptionList(exceptionList);
        for (IdsEventObject eventObj : exceptionObjList) {
            exceptionList.addExceptionEvent(eventObj.getEvent());
        }
    }

    @Override
    public boolean getEnabled() {
        return Utility.getBooleanValue((Boolean)((IdsPolicy)this.policy).getOptEnable(), (Boolean)((IdsPolicy)this.policy).getDefEnable());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        ((IdsPolicy)this.policy).setOptEnable(Boolean.valueOf(isEnabled));
    }

    @Override
    public String toString() {
        if (this.getEnabled()) {
            return this.getName();
        }
        Object[] args = new Object[]{this.getName(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryObject.DisabledIPS")};
        return MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryObject.IPSName"), args);
    }
}

