/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.logicobject;

import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.LuDownloadedContent;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.ids.handler.IdsLuHandler;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsMetadataEvent;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class IdsMetadataObject {
    protected static final String IDS_METADATA_XML_FILENAME = "IPSMetadata3.xml";
    protected static final String PEP_METADATA_XML_FILENAME = "IPSMetadata3.xml";
    protected static final String WIN_PRODCUT_NAME = "SEP_2021";
    protected static final String MAC_PRODCUT_NAME = "SEP_MAC_2020";
    protected static final String WIN_SERVER_PROTECT_NAME = "SEP_2021_Server";
    protected static final String STATE = "State";
    protected static final String LOWER_CASE_STATE = "state";
    protected static final String NAME = "Name";
    protected static final String PRODUCT = "Product";
    private static final String EVENT = "Event";
    private static final String ISSUE_DATA = "IssueData";
    private static final String CATEGORY = "Category";
    private static final String SEVERITY = "Severity";
    private static final String ISSUE = "Issue";
    protected static final String PRODUCT_LIST = "ProductList";
    private static final String ACTION = "Action";
    private static final String LOG = "Log";
    private static final String RESPONSE = "Response";
    private static final String ID = "ID";
    protected static final String DEPRECATED = "D";

    public IdsMetadataObject() throws ConsoleException {
        this.initializeData();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeData() throws ConsoleException {
        ByteArrayInputStream allDataInputStream;
        InputStream idsMetadataFileInputStream;
        InputStream nIn;
        block9: {
            nIn = null;
            this.clearMap();
            idsMetadataFileInputStream = null;
            allDataInputStream = null;
            try {
                LuDownloadedContent sepmMetadataContent = IdsLuHandler.getLatestSepmMetadataContent();
                if (sepmMetadataContent != null) {
                    ObjReference ref = sepmMetadataContent.getOptObjReference();
                    if (ref == null) {
                        throw new ConsoleException(0x16010000);
                    }
                    PhysicalFile file = DataobjectManager.getInstance().getPhysicalFile(ref.getTargetId());
                    ObjReference objRef = file.getObjReference();
                    nIn = GUIManager.getFile(objRef.getTargetId());
                    allDataInputStream = this.convertBackendInputStream(nIn);
                    IOUtilities.closeInputStream((InputStream)nIn);
                    nIn = null;
                    if (allDataInputStream != null) {
                        String fileName = this.getIDSFileName(sepmMetadataContent);
                        idsMetadataFileInputStream = this.getMetadataFile(allDataInputStream, fileName);
                        if (idsMetadataFileInputStream != null) {
                            this.getIdsEvensList(idsMetadataFileInputStream);
                            IOUtilities.closeInputStream((InputStream)idsMetadataFileInputStream);
                            idsMetadataFileInputStream = null;
                        }
                        IOUtilities.closeInputStream((InputStream)allDataInputStream);
                        allDataInputStream = null;
                    }
                    break block9;
                }
                ConsoleLogger.log("IdsMetadataObject >> initializeData >> Cannot load SEPM Metadata content from server! Will need run LiveUpdate.");
                MessageResourcesFile msgRes = new MessageResourcesFile("com.sygate.scm.console.ui.policy.ids.ids");
                JOptionPane.showMessageDialog(Manager.getFrame(), msgRes.getString("IdsMetadataObject.Error.NeedRunLiveUpdate"), msgRes.getString("IdsSettingsPanel.title.Error"), 0);
            }
            catch (SAXException ex) {
                try {
                    LoggerUtilities.logException((Throwable)ex);
                    throw new ConsoleException(ex);
                    catch (IOException ex2) {
                        LoggerUtilities.logException((Throwable)ex2);
                        throw new ConsoleException(ex2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtilities.closeInputStream(idsMetadataFileInputStream);
                    IOUtilities.closeInputStream(allDataInputStream);
                    IOUtilities.closeInputStream(nIn);
                    throw throwable;
                }
            }
        }
        IOUtilities.closeInputStream(idsMetadataFileInputStream);
        IOUtilities.closeInputStream(allDataInputStream);
        IOUtilities.closeInputStream((InputStream)nIn);
    }

    protected ByteArrayInputStream convertBackendInputStream(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream allDataOutStream = null;
        try {
            allDataOutStream = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            int len = -1;
            while ((len = in.read(buff)) != -1) {
                allDataOutStream.write(buff, 0, len);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(allDataOutStream.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw ex;
        }
        finally {
            IOUtilities.closeOutputStream((OutputStream)allDataOutStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getMetadataFile(InputStream in, String fileName) {
        ZipInputStream zin = new ZipInputStream(in);
        ZipEntry entry = null;
        boolean found = false;
        try {
            while ((entry = zin.getNextEntry()) != null) {
                if (!entry.getName().equalsIgnoreCase(fileName)) continue;
                found = true;
                break;
            }
            if (found) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buff = new byte[1024];
                int len = -1;
                while ((len = zin.read(buff)) > 0) {
                    out.write(buff, 0, len);
                }
                out.flush();
                out.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
                return byteArrayInputStream;
            }
        }
        catch (IOException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return null;
    }

    public void getIdsEvensList(InputStream in) throws IOException, SAXException {
        Document doc = XMLHelper.parse((InputStream)in);
        Element root = doc.getDocumentElement();
        ArrayList allElemt = XMLHelper.getChildElementByName((Element)root, (String)ISSUE);
        for (Element issueElemt : allElemt) {
            int severity = this.getSeverity(issueElemt);
            List<String> categoryList = this.getCategoryList(issueElemt);
            List<Element> eventElemtList = this.getEventList(issueElemt);
            for (Element eventElemt : eventElemtList) {
                List<ProductState> states = this.getState(eventElemt);
                for (ProductState state : states) {
                    IdsMetadataEvent event;
                    if (state.getState() == null || DEPRECATED.equals(state.getState()) || state.getState().isEmpty() || (event = this.importEventData(eventElemt, severity, categoryList, state.isServerSignatureSet())) == null) continue;
                    this.setToMap(event);
                }
            }
        }
    }

    private IdsMetadataEvent importEventData(Element eventElemt, int severity, List<String> categoryList, boolean isServerSignatureSet) {
        String eventId = this.getEventId(eventElemt);
        String eventName = XMLHelper.getAttribute((Element)eventElemt, (String)NAME);
        String action = this.getAction(eventElemt);
        String log = this.getLog(eventElemt);
        boolean silentSig = false;
        IdsMetadataEvent event = null;
        if (eventId == null || eventId.isEmpty()) {
            return event;
        }
        if (action != null && action.equalsIgnoreCase("ALLOW") && !categoryList.contains("Audit") && log != null && log.equals("0")) {
            silentSig = true;
            if (isServerSignatureSet) {
                ConsoleLogger.log("importEventData >> Detected the Allow action & non audit item for server signature set, so skip it.");
            }
        }
        if (!silentSig) {
            event = new IdsMetadataEvent(eventId, eventName, severity, categoryList, action, log, isServerSignatureSet);
        }
        return event;
    }

    protected abstract IdsMetadataEvent setToMap(IdsMetadataEvent var1);

    protected abstract String getIDSFileName(LuDownloadedContent var1);

    protected abstract String getPEPFileName(LuDownloadedContent var1);

    protected abstract boolean isIPSContent(LuDownloadedContent var1);

    protected abstract void clearMap();

    private int getSeverity(Element element) {
        ArrayList severityElemtList;
        ArrayList issueDataList;
        int severity = 0;
        String strSeverity = element.getAttribute(SEVERITY);
        if ((strSeverity == null || strSeverity.length() == 0) && (issueDataList = XMLHelper.getChildElementByName((Element)element, (String)ISSUE_DATA)) != null && issueDataList.size() == 1 && (severityElemtList = XMLHelper.getChildElementByName((Element)((Element)issueDataList.get(0)), (String)SEVERITY)) != null && severityElemtList.size() == 1) {
            for (Element elementSev : severityElemtList) {
                Node node = XMLHelper.getTextNode((Element)elementSev);
                if (node == null) continue;
                strSeverity = node.getNodeValue();
            }
        }
        try {
            severity = Integer.parseInt(strSeverity);
        }
        catch (NumberFormatException ignore) {
            ConsoleLogger.log("getSeverity >> NumberFormatException occurred, ignore it.");
        }
        return severity;
    }

    private List<String> getCategoryList(Element issueElemt) {
        ArrayList issueDataList;
        ArrayList categoryElemtList = XMLHelper.getChildElementByName((Element)issueElemt, (String)CATEGORY);
        if ((categoryElemtList == null || categoryElemtList.size() == 0) && (issueDataList = XMLHelper.getChildElementByName((Element)issueElemt, (String)ISSUE_DATA)) != null && issueDataList.size() == 1) {
            categoryElemtList = XMLHelper.getChildElementByName((Element)((Element)issueDataList.get(0)), (String)CATEGORY);
        }
        ArrayList<String> retList = new ArrayList<String>();
        for (Element element : categoryElemtList) {
            Node node = XMLHelper.getTextNode((Element)element);
            if (node == null) continue;
            retList.add(node.getNodeValue());
        }
        return retList;
    }

    private String getLog(Element eventElemt) {
        String log = null;
        ArrayList responseList = XMLHelper.getChildElementByName((Element)eventElemt, (String)RESPONSE);
        if (responseList != null && responseList.size() == 1) {
            log = XMLHelper.getAttribute((Element)((Element)responseList.get(0)), (String)LOG);
        }
        return log;
    }

    private String getAction(Element eventElemt) {
        String action = null;
        ArrayList responseList = XMLHelper.getChildElementByName((Element)eventElemt, (String)RESPONSE);
        if (responseList != null && responseList.size() == 1) {
            action = XMLHelper.getAttribute((Element)((Element)responseList.get(0)), (String)ACTION);
        }
        return action;
    }

    private List<Element> getEventList(Element issueElemt) {
        ArrayList issueDataList;
        ArrayList eventElemtList = XMLHelper.getChildElementByName((Element)issueElemt, (String)EVENT);
        if ((eventElemtList == null || eventElemtList.size() == 0) && (issueDataList = XMLHelper.getChildElementByName((Element)issueElemt, (String)ISSUE_DATA)) != null && issueDataList.size() == 1) {
            eventElemtList = XMLHelper.getChildElementByName((Element)((Element)issueDataList.get(0)), (String)EVENT);
        }
        return eventElemtList;
    }

    private String getEventId(Element eventElemt) {
        String eventId = XMLHelper.getAttribute((Element)eventElemt, (String)ID);
        return eventId;
    }

    protected abstract List<ProductState> getState(Element var1);

    protected static class ProductState {
        String state;
        boolean serverSignatureSet = false;

        public ProductState(String state, boolean isServerProduct) {
            this.state = state != null ? state : "";
            this.serverSignatureSet = isServerProduct;
        }

        public String getState() {
            return this.state;
        }

        public boolean isServerSignatureSet() {
            return this.serverSignatureSet;
        }
    }
}

