/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.logicobject;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.ids.handler.IdsCategoryHelper;
import com.sygate.scm.console.ui.policy.ids.handler.IdsSeverityHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IdsMetadataEvent
implements TableRow {
    static String ALLOW = "allow";
    static String BLOCK = "block";
    static String YES = "yes";
    static String NO = "no";
    static Integer ALLOW_I = 1;
    static Integer BLOCK_I = 2;
    private String eventId;
    private String eventName;
    private int severity;
    private List<String> categoryList;
    private Integer action;
    private Boolean log;
    private boolean showIpsServerSig;

    public IdsMetadataEvent() {
    }

    public IdsMetadataEvent(String eventId2, String eventName2, int severity2, List<String> categoryList2, String action2, String log2, boolean showIpsServerSig) {
        this.eventId = eventId2;
        this.eventName = eventName2;
        this.severity = severity2;
        this.categoryList = categoryList2;
        this.showIpsServerSig = showIpsServerSig;
        this.action = action2.toLowerCase().equals(ALLOW) ? ALLOW_I : BLOCK_I;
        this.log = log2.toLowerCase().equals(NO) || log2.equals("0") ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.eventId;
            }
            case 1: {
                return this.eventName;
            }
            case 2: {
                return this.getSeverityDesc();
            }
            case 3: {
                return this.getCategoryDesc();
            }
            case 4: {
                return this.getAction();
            }
            case 5: {
                return this.getLog();
            }
        }
        return "";
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
        }
        return String.class;
    }

    public String getSeverityDesc() {
        return IdsSeverityHandler.translateSeverity(this.severity);
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getLog() {
        if (this.log.booleanValue()) {
            return IdsMetadataEvent.getString("IdsMatadataEvent.Log");
        }
        return IdsMetadataEvent.getString("IdsMatadataEvent.Unlog");
    }

    public boolean getShowIPSServerSig() {
        return this.showIpsServerSig;
    }

    public String getAction() {
        if (this.action.equals(BLOCK_I)) {
            return IdsMetadataEvent.getString("IdsMatadataEvent.Block");
        }
        if (this.action.equals(ALLOW_I)) {
            return IdsMetadataEvent.getString("IdsMatadataEvent.Allow");
        }
        return "";
    }

    public boolean isBlocked() {
        if (this.action.equals(BLOCK_I)) {
            return true;
        }
        return !this.action.equals(ALLOW_I);
    }

    public boolean isLog() {
        return this.log != false;
    }

    public String getCategoryDesc() {
        StringBuffer sb = new StringBuffer();
        if (IdsCategoryHelper.isBrowserProtectionSignature(this.eventId)) {
            sb.append(IdsMetadataEvent.getString("IdsCategoryHandler.Browser.Protecion"));
        } else if (this.getShowIPSServerSig()) {
            sb.append(IdsMetadataEvent.getString("IdsCategoryHandler.server.signature.set"));
        } else {
            sb.append(IdsMetadataEvent.getString("IdsCategoryHandler.Intrusion.Prevention"));
        }
        for (String category : this.categoryList) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(category);
        }
        return sb.toString();
    }

    public List<String> getCategories() {
        return this.categoryList;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    private static String getString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", key);
    }

    public String getId() {
        return this.eventId;
    }

    public String getName() {
        return this.eventName;
    }

    public boolean equalTo(IdsMetadataEvent other) {
        boolean ret = true;
        if (!(ret &= this.eventId.equals(other.eventId))) {
            return ret;
        }
        if (!(ret &= this.eventName.equals(other.eventName))) {
            return ret;
        }
        if (!(ret &= this.severity == other.severity)) {
            return ret;
        }
        if (!(ret &= this.action.equals(other.action))) {
            return ret;
        }
        if (!(ret &= this.log.equals(other.log))) {
            return ret;
        }
        if (this.categoryList.size() != other.categoryList.size()) {
            return false;
        }
        ArrayList<String> tempArray = new ArrayList<String>(this.categoryList);
        ArrayList<String> anotherArray = new ArrayList<String>(other.categoryList);
        Collections.sort(tempArray);
        Collections.sort(anotherArray);
        return tempArray.equals(anotherArray);
    }
}

