/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.IdsMacro;
import com.sygate.scm.common.configobject.schema.IdsMacroArray;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.GUIDGenerator;
import java.util.HashMap;
import java.util.Vector;

public class IdsMacroObject
implements TableRow,
CopitableObject {
    private IdsMacro idsMacro;

    public IdsMacroObject() {
        this.idsMacro = new IdsMacro();
        this.idsMacro.setId(new GUIDGenerator().getGUIDString());
        this.idsMacro.setOptEnable(Boolean.valueOf(true));
    }

    public IdsMacroObject(IdsMacro macro) {
        this.idsMacro = macro;
    }

    public Boolean isEnabled() {
        Boolean enabled = this.idsMacro.getOptEnable();
        if (enabled == null) {
            enabled = this.idsMacro.getDefEnable();
        }
        return enabled;
    }

    public void setEnabled(Boolean enable) {
        this.idsMacro.setOptEnable(enable);
    }

    public String getName() {
        return this.idsMacro.getName();
    }

    public void setName(String name) {
        this.idsMacro.setName(name);
    }

    public String getDesc() {
        return this.idsMacro.getOptDescription();
    }

    public void setDesc(String desc) {
        this.idsMacro.setOptDescription(desc);
    }

    public String getContent() {
        return this.idsMacro.getOptContent();
    }

    public void setContent(String content) {
        this.idsMacro.setOptContent(content);
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        try {
            WashIDHandler washer = new WashIDHandler();
            HashMap<String, TopLevelObject> createdObj = new HashMap<String, TopLevelObject>();
            IdsMacro newMacro = (IdsMacro)washer.duplicateObject((ConfigObject)this.idsMacro, createdObj);
            IdsMacroObject newObj = new IdsMacroObject(newMacro);
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public boolean checkNewName(IdsMacroArray idsMacroArray, String name) throws ConsoleException {
        boolean legal = true;
        if (idsMacroArray != null) {
            Vector idsMacro = idsMacroArray.getIdsMacro();
            int count = idsMacro.size();
            for (int i = 0; i < count; ++i) {
                IdsMacro isMacro = (IdsMacro)idsMacro.get(i);
                if (!isMacro.getName().equals(name)) continue;
                legal = false;
                break;
            }
        }
        return legal;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.isEnabled();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getDesc();
            }
            case 3: {
                return this.getContent();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
        if (index == 0) {
            this.setEnabled((Boolean)value);
        }
    }

    public IdsMacro getIdsMacro() {
        return this.idsMacro;
    }

    public IdsMacroObject getClone() throws ConsoleException {
        try {
            byte[] copyArray = this.idsMacro.getBytes();
            AbstractSchema newMacro = AbstractSchema.readXML((byte[])copyArray);
            IdsMacroObject newObj = new IdsMacroObject((IdsMacro)newMacro);
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }
}

