/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.FwIdsLibrary;
import com.sygate.scm.common.configobject.schema.FwIdsLibraryPool;
import com.sygate.scm.common.configobject.schema.ObjInfo;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Toolkit;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;

public class IdsLibraryPoolObject
extends AppliablePolicyPool {
    private Map<String, String> refTypeMap;

    public IdsLibraryPoolObject(SemDomain domain) throws ConsoleException {
        super(domain, 65);
        this.initialize();
    }

    public void addSystemLibrary(IdsLibraryObject newIdsLibraryObject) throws ConsoleException {
        IdsLibraryObject oldSysLib = this.getSystemIdsLibraryObject();
        this.deletePolicyObject(oldSysLib, "FwSystemIdsLibrary");
        FwIdsLibrary newLibrary = newIdsLibraryObject.getFwIdsLibrary();
        this.addPolicyObject((PolicyObjectBase)new IdsLibraryObject(newLibrary), "FwSystemIdsLibrary");
        this.addLog(0, newIdsLibraryObject.getId(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryPoolObject.AddIPSSysLibToSharedPool"), newIdsLibraryObject.getVersion()));
        if (oldSysLib != null) {
            this.addLog(1, oldSysLib.getId(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryPoolObject.DelIPSSysLibFromSharedPool"), oldSysLib.getVersion()));
        }
        this.updatePolicyAndLog();
    }

    public void updateSystemLibrary(IdsLibraryObject idsLibObj) throws ConsoleException {
        this.updateObjInfoList(idsLibObj);
        ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        DataobjectManager.UpdateObjectEntry entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)idsLibObj.getFwIdsLibrary(), 0);
        updateList.add(entry);
        DataobjectManager.getInstance().updateObject("Overwrite", updateList);
        this.addLog(2, idsLibObj.getId(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryPoolObject.UpdateIPSSysLib"), idsLibObj.getVersion()));
        PolicyHandler.updateLog(this.logList);
    }

    @Override
    protected void initObjInfo(int itemType) throws ConsoleException {
        this.refTypeMap = this.getObjReferenceIdTypeMap();
        super.initObjInfo(65);
    }

    @Override
    protected ObjInfoObject createInfoObject(int itemType, ObjInfo info, String id) {
        IDSObjInfoObject ids = new IDSObjInfoObject(itemType, info, this.refTypeMap.get(id));
        ids.initType();
        return ids;
    }

    @Override
    protected Vector<ObjReference> getPolicyPoolReferences() {
        Vector<ObjReference> ret = new Vector<ObjReference>();
        if (this.policyPool != null) {
            Vector allObjs = ((FwIdsLibraryPool)this.policyPool).getObjReference();
            for (int i = 0; i < allObjs.size(); ++i) {
                ObjReference objRef = (ObjReference)allObjs.get(i);
                if (!objRef.getTargetType().equalsIgnoreCase("FwIdsLibrary")) continue;
                ret.add(objRef);
            }
        }
        return ret;
    }

    @Override
    protected void addPolicyPoolReference(ConfigObject policyPool, ObjReference objRef) {
        ((FwIdsLibraryPool)policyPool).addObjReference(objRef);
    }

    @Override
    protected void createSemPolicyPool() {
        this.policyPool = new FwIdsLibraryPool();
        this.domainObjPool.setOptFwIdsLibraryPool((FwIdsLibraryPool)this.policyPool);
    }

    private Map<String, String> getObjReferenceIdTypeMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Vector allRef = ((FwIdsLibraryPool)this.policyPool).getObjReference();
        for (int i = 0; i < allRef.size(); ++i) {
            ObjReference ref = (ObjReference)allRef.get(i);
            if (!"FwIdsLibrary".equalsIgnoreCase(ref.getTargetType())) continue;
            map.put(ref.getTargetId(), ref.getTargetType());
        }
        return map;
    }

    private FwIdsLibrary getSystemLibraryFromDB() throws ConsoleException {
        ObjReference objRef;
        if (this.policyPool != null && (objRef = ((FwIdsLibraryPool)this.policyPool).getObjReferenceByTypeAndName("FwIdsLibrary", "FwSystemIdsLibrary")) != null) {
            String id = objRef.getTargetId();
            String type = objRef.getTargetType();
            return (FwIdsLibrary)DataobjectManager.getInstance().getObjectByGUID(type, id);
        }
        return null;
    }

    public static IdsLibraryPoolObject getIdsLibraryPoolObject() throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", data.getLoginInformation().getOptDomainGUID());
        return new IdsLibraryPoolObject(domain);
    }

    public boolean isSystemLibrary(IdsLibraryObject idsLibObject) throws ConsoleException {
        FwIdsLibrary fwIdsLibrary = this.getSystemLibraryFromDB();
        return fwIdsLibrary != null && fwIdsLibrary.getId().equals(idsLibObject.getId());
    }

    public IdsLibraryObject getSystemIdsLibraryObject() throws ConsoleException {
        FwIdsLibrary fwIdsLibrary = this.getSystemLibraryFromDB();
        if (fwIdsLibrary != null) {
            return new IdsLibraryObject(fwIdsLibrary);
        }
        return null;
    }

    public static class IDSObjInfoObject
    extends ObjInfoObject {
        private final ImageIcon[] ICONS = new ImageIcon[]{new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("ips_exception.gif"))), new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("ips_legacy.gif"))), new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("ips_custom.gif"))), null};
        private static final int STREAM = 0;
        private static final int PACKET_SYSTEM = 1;
        private static final int PACKET_CUSTOM = 2;
        private static final int UNKNOWN = 3;
        private int idsType;

        public IDSObjInfoObject(int itemType, ObjInfo info, String targetType) {
            super(itemType, info, targetType);
        }

        public void initType() {
            block8: {
                this.idsType = 3;
                if (this.getTargetType() == null) {
                    return;
                }
                if (this.getTargetType().equals("FwIdsLibrary")) {
                    try {
                        FwIdsLibrary idsLib = (FwIdsLibrary)DataobjectManager.getInstance().getObjectByGUID(this.getTargetType(), this.getId());
                        Long l = idsLib.getOptObjAttributes();
                        if (l == null) {
                            l = idsLib.getDefObjAttributes();
                        }
                        if (l == 0L) {
                            this.idsType = 2;
                            break block8;
                        }
                        this.idsType = 1;
                    }
                    catch (ConsoleException ce) {
                        LoggerUtilities.logException((Throwable)ce);
                        this.idsType = 3;
                    }
                } else if (this.getTargetType().equals("IdsPolicy")) {
                    this.idsType = 0;
                }
            }
        }

        public ImageIcon getIcon() {
            return this.ICONS[this.idsType];
        }

        public int getIDSType() {
            return this.idsType;
        }

        public int getIdsPoolObjectReferenceType(boolean isQuarantine) {
            int type = this.idsType == 0 ? (!isQuarantine ? 143 : 161) : 65;
            return type;
        }

        @Override
        public Object getValueAt(int index) {
            switch (index) {
                case 0: {
                    return this.getName();
                }
                case 1: {
                    return this.getDescription();
                }
            }
            return super.getValueAt(index);
        }

        @Override
        public Class<?> getValueTypeAt(int index) {
            switch (index) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return Integer.class;
        }
    }
}

