/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.FwIdsLibrary;
import com.sygate.scm.common.configobject.schema.IdsSignatureBlock;
import com.sygate.scm.common.configobject.schema.IdsSignatureBlockArray;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.IDSObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.ids.handler.IdsHandler;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsSignatureBlockObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class IdsLibraryObject
extends PolicyObjectBase
implements TableRow {
    private IDSObject idsObj;
    private Boolean enabled = false;
    private final DateFormat sdf = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());

    public IdsLibraryObject(FwIdsLibrary fwIdsLibrary) {
        super((TopLevelObject)fwIdsLibrary);
    }

    public IdsLibraryObject() {
        HashMap<String, TopLevelObject> newObj = new HashMap<String, TopLevelObject>();
        try {
            this.policy = PolicyHandler.getDefaultFwIdsLibrary(newObj);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            this.policy = new FwIdsLibrary();
            FwIdsLibrary fwLibObj = (FwIdsLibrary)this.policy;
            fwLibObj.setId(new GUIDGenerator().getGUIDString());
            fwLibObj.setCreationTime(Long.valueOf(System.currentTimeMillis()));
            fwLibObj.setIdsSignatureBlockArray(new IdsSignatureBlockArray());
            fwLibObj.setFormatVersion("2.0");
            fwLibObj.setVersion("1");
        }
    }

    public void addIdsSignatureBlockObject(IdsSignatureBlockObject blockObject) {
        IdsSignatureBlock idsBlock = blockObject.getIdsSignatureBlock();
        ((FwIdsLibrary)this.policy).getIdsSignatureBlockArray().addIdsSignatureBlock(idsBlock);
    }

    public void deleteIdsSignatureBlockObject(IdsSignatureBlockObject blockObject) {
        IdsSignatureBlock idsBlock = blockObject.getIdsSignatureBlock();
        ((FwIdsLibrary)this.policy).getIdsSignatureBlockArray().removeIdsSignatureBlock(idsBlock);
    }

    @Override
    protected PolicyObjectBase createPolicyObject(TopLevelObject policyObj) throws ConsoleException {
        if (!(policyObj instanceof FwIdsLibrary)) {
            throw new ConsoleException(302645248, 32);
        }
        ((FwIdsLibrary)policyObj).setOptObjAttributes(Long.valueOf(0L));
        ((FwIdsLibrary)policyObj).setOptTrojanLibraryBody(null);
        IdsLibraryObject newObj = new IdsLibraryObject((FwIdsLibrary)policyObj);
        newObj.setCreationTime(System.currentTimeMillis());
        return newObj;
    }

    @Override
    public String getCreator() {
        return ((FwIdsLibrary)this.policy).getOptCreator();
    }

    @Override
    public void setCreator(String creator) {
        ((FwIdsLibrary)this.policy).setOptCreator(creator);
    }

    public String getVersion() {
        return ((FwIdsLibrary)this.policy).getVersion();
    }

    public Long getCreationTime() {
        return ((FwIdsLibrary)this.policy).getCreationTime();
    }

    public void setCreationTime(Long time) {
        ((FwIdsLibrary)this.policy).setCreationTime(time);
    }

    public FwIdsLibrary getFwIdsLibrary() {
        return (FwIdsLibrary)this.policy;
    }

    @Override
    public String getTargetName() {
        return ((FwIdsLibrary)this.policy).getName();
    }

    @Override
    public String getTargetType() {
        return this.policy.getObjectTypeName();
    }

    @Override
    public String getRefTargetName() {
        return ((FwIdsLibrary)this.policy).getName();
    }

    @Override
    public String getTypeDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryObject.IPSLibraryDesc");
    }

    public void setDesc(String desc) {
        ((FwIdsLibrary)this.policy).setOptDescription(desc);
    }

    public void setSerialNumber(String serialNumber) {
        ((FwIdsLibrary)this.policy).setVersion(serialNumber);
    }

    public String getSerialNumber() {
        return ((FwIdsLibrary)this.policy).getVersion();
    }

    public void setIDS(IDSObject idsObj) {
        this.idsObj = idsObj;
        if (idsObj == null) {
            return;
        }
        this.enabled = idsObj.isExisting(this.getFwIdsLibrary().getId());
    }

    @Override
    public Object getValueAt(int column) {
        switch (column) {
            case 0: {
                return this.enabled;
            }
            case 1: {
                return ((FwIdsLibrary)this.policy).getName();
            }
            case 2: {
                return ((FwIdsLibrary)this.policy).getOptDescription();
            }
            case 3: {
                long latestT = PolicyHandler.getLatestT((ConfigObject)this.policy);
                Date updateTime = new Date(latestT);
                return this.sdf.format(updateTime);
            }
        }
        return "This should not happen";
    }

    @Override
    public Class<?> getValueTypeAt(int column) {
        switch (column) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object value, int column) {
        if (column == 0) {
            this.enabled = (Boolean)value;
            this.idsObj.setEnable(this.enabled, this.getFwIdsLibrary());
        }
    }

    public ArrayList<IdsSignatureBlockObject> getIdsSignatureBlockObjects() {
        return IdsHandler.getIdsSignatureBlocks((FwIdsLibrary)this.policy);
    }

    public void setIdsSignatureBlockObject(int index, IdsSignatureBlockObject blockObject) {
        IdsSignatureBlock idsBlock = blockObject.getIdsSignatureBlock();
        ((FwIdsLibrary)this.policy).getIdsSignatureBlockArray().setIdsSignatureBlock(index, idsBlock);
    }

    public IdsLibraryObject getClone() throws ConsoleException {
        try {
            System.out.println("Id :" + ((FwIdsLibrary)this.policy).getId());
            byte[] copyArray = ((FwIdsLibrary)this.policy).getBytes();
            AbstractSchema newLibrary = AbstractSchema.readXML((byte[])copyArray);
            IdsLibraryObject newObj = new IdsLibraryObject((FwIdsLibrary)newLibrary);
            newObj.setIDS(this.idsObj);
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public boolean isDirty() {
        return true;
    }

    @Override
    public int getItemType() {
        return 65;
    }

    public List<String> getGroupNameList() {
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<IdsSignatureBlockObject> blockList = this.getIdsSignatureBlockObjects();
        for (IdsSignatureBlockObject bObj : blockList) {
            nameList.add(bObj.getName());
        }
        return nameList;
    }

    public boolean isSystemLibrary() {
        Long attribute;
        return this.policy != null && (attribute = ((FwIdsLibrary)this.policy).getOptObjAttributes()) != null && attribute == 1L;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

