/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.logicobject;

import com.sygate.scm.common.configobject.schema.Action;
import com.sygate.scm.common.configobject.schema.AppExceptionList;
import com.sygate.scm.common.configobject.schema.ExceptionEvent;
import com.sygate.scm.common.configobject.schema.LogProcess;
import com.sygate.scm.common.configobject.schema.PacketProcess;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsMetadataEvent;

public class IdsEventObject
extends AbstractUIObject
implements TableRow {
    private static final MessageResources MRS = MessageResources.getInstance();
    private static String[] ACTION_ITEMS = new String[]{MRS.getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.Block"), MRS.getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.Allow")};
    private ExceptionEvent scmEvent;
    private IdsMetadataEvent metadataEvent;

    public IdsEventObject(ExceptionEvent event, IdsMetadataEvent metadata) {
        this.scmEvent = event;
        this.metadataEvent = metadata;
    }

    public IdsEventObject(IdsMetadataEvent event, boolean isBlock, boolean isLog) {
        this.metadataEvent = event;
        this.scmEvent = new ExceptionEvent();
        this.scmEvent.setEventId(event.getId());
        Action action = new Action();
        this.scmEvent.setAction(action);
        PacketProcess packet = new PacketProcess();
        packet.setPacketProcess(isBlock ? PacketProcess.DROP : PacketProcess.PASS);
        action.setOptPacketProcess(packet);
        LogProcess log = new LogProcess();
        log.setOptLogEvent(isLog ? Boolean.TRUE : Boolean.FALSE);
        action.setOptLogProcess(log);
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.scmEvent.getEventId();
            }
            case 1: {
                return this.metadataEvent.getName();
            }
            case 2: {
                return this.metadataEvent.getSeverityDesc();
            }
            case 3: {
                return this.metadataEvent.getCategoryDesc();
            }
            case 4: {
                return this.getActionString();
            }
            case 5: {
                return this.getLog();
            }
        }
        return "";
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    public String getActionString() {
        if (this.getAction().booleanValue()) {
            return ACTION_ITEMS[0];
        }
        return ACTION_ITEMS[1];
    }

    public Boolean getLog() {
        Action action = this.scmEvent.getAction();
        LogProcess packet = action.getOptLogProcess();
        if (packet != null) {
            Boolean process = packet.getOptLogEvent();
            if (process == null) {
                process = packet.getDefLogEvent();
            }
            return process;
        }
        return Boolean.FALSE;
    }

    public Boolean getAction() {
        Integer process;
        Action action = this.scmEvent.getAction();
        PacketProcess packet = action.getOptPacketProcess();
        if (packet != null && PacketProcess.DROP.equals(process = packet.getPacketProcess())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public void setValueAt(Object value, int index) {
        if (index == 4) {
            this.setAction(value.toString().equals(ACTION_ITEMS[0]));
        }
        if (index == 5) {
            this.setLog((Boolean)value);
        }
    }

    public void setLog(boolean optLogEvent) {
        Action action = this.scmEvent.getAction();
        LogProcess packet = action.getOptLogProcess();
        if (packet == null) {
            packet = new LogProcess();
            action.setOptLogProcess(packet);
        }
        packet.setOptLogEvent(Boolean.valueOf(optLogEvent));
    }

    public void setAction(boolean packetProcessDrop) {
        Action action = this.scmEvent.getAction();
        PacketProcess packet = action.getOptPacketProcess();
        if (packet == null) {
            packet = new PacketProcess();
            action.setOptPacketProcess(packet);
        }
        packet.setPacketProcess(packetProcessDrop ? PacketProcess.DROP : PacketProcess.PASS);
    }

    public void setAppExceptionList(AppExceptionList exList) {
        if (exList != null) {
            this.scmEvent.setOptAppExceptionList(exList);
        }
    }

    public boolean isAppExEnabled() {
        AppExceptionList ex = this.scmEvent.getOptAppExceptionList();
        if (ex == null) {
            return false;
        }
        return ex.getOptEnable();
    }

    public AppExceptionList getAppExceptionList() {
        return this.scmEvent.getOptAppExceptionList();
    }

    public ExceptionEvent getEvent() {
        return this.scmEvent;
    }
}

