/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.logicobject;

import com.sygate.scm.common.configobject.schema.Executable;
import com.sygate.scm.common.configobject.schema.SoApplicationContainer;
import com.sygate.scm.console.ui.policy.ids.logicobject.ApplicationObject;
import java.util.Vector;

public class ApplicationContainerObject {
    private SoApplicationContainer predefined_container;
    private SoApplicationContainer user_container;
    private Vector<ApplicationObject> applicationObjects;

    public ApplicationContainerObject(SoApplicationContainer predefined_container, SoApplicationContainer user_container) {
        this.predefined_container = predefined_container;
        this.user_container = user_container;
    }

    public SoApplicationContainer getPredefinedContainer() {
        return this.predefined_container;
    }

    public SoApplicationContainer getUserContainer() {
        return this.user_container;
    }

    public void addApplication(Executable exec) {
        if (this.user_container == null) {
            this.user_container = new SoApplicationContainer();
            this.user_container.setOptContainerName("USER_DEFINED");
        }
        this.user_container.addExecutable(exec);
    }

    public void deleteApplication(Executable exec) {
        this.user_container.removeExecutable(exec);
    }

    public void setApplicaiton(int index, Executable exec) {
        this.user_container.setExecutable(index, exec);
    }

    public Vector<ApplicationObject> getApplications() {
        if (this.applicationObjects == null) {
            this.applicationObjects = new Vector();
            if (this.predefined_container != null) {
                for (Executable exec : this.predefined_container.getExecutable()) {
                    ApplicationObject appObject = new ApplicationObject(exec);
                    appObject.setIsSystemPredefined(true);
                    this.applicationObjects.add(appObject);
                }
            }
            if (this.user_container != null) {
                for (Executable exec : this.user_container.getExecutable()) {
                    this.applicationObjects.add(new ApplicationObject(exec));
                }
            }
        }
        return this.applicationObjects;
    }

    public String toString() {
        Vector<ApplicationObject> applications = this.getApplications();
        int count = applications.size();
        StringBuffer sb = new StringBuffer();
        int cnt = 0;
        for (int i = 0; i < count; ++i) {
            ApplicationObject appObject = applications.get(i);
            Executable app = appObject.getExecutable();
            if (app == null || Boolean.FALSE.equals(app.getOptEnable())) continue;
            if (cnt > 0) {
                sb.append(",");
            }
            sb.append(app.getOptFileName());
            ++cnt;
        }
        return sb.toString();
    }
}

