/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.handler;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsMetadataEvent;
import com.sygate.scm.console.ui.policy.ids.logicobject.MetadataEventFilter;
import com.sygate.scm.util.BadFormatException;
import com.sygate.scm.util.IntegerSet;
import com.sygate.scm.util.LoggerUtilities;

public class IdsSeverityHandler {
    private static IdsSeverityFilter[] severityList = new IdsSeverityFilter[]{new IdsSeverityFilter(IdsSeverityHandler.getString("IdsSeverityHandler.All"), null), new IdsSeverityFilter(IdsSeverityHandler.getString("IdsSeverityHandler.High"), "7-10"), new IdsSeverityFilter(IdsSeverityHandler.getString("IdsSeverityHandler.Medium"), "4-6"), new IdsSeverityFilter(IdsSeverityHandler.getString("IdsSeverityHandler.Low"), "1-3")};

    private static String getString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", key);
    }

    public static String translateSeverity(int severity) {
        for (int i = 1; i < severityList.length; ++i) {
            if (!severityList[i].accept(severity)) continue;
            return IdsSeverityHandler.severityList[i].severityDesc;
        }
        return IdsSeverityHandler.severityList[0].severityDesc;
    }

    public static IdsSeverityFilter[] getSeverityList() {
        return (IdsSeverityFilter[])severityList.clone();
    }

    public static class IdsSeverityFilter
    implements MetadataEventFilter {
        private String severityDesc;
        private IntegerSet severityValue;

        public IdsSeverityFilter(String sDesc, String severityRange) {
            this.severityDesc = sDesc;
            this.severityValue = null;
            if (severityRange != null) {
                try {
                    this.severityValue = new IntegerSet(severityRange);
                }
                catch (BadFormatException e) {
                    LoggerUtilities.logException((Throwable)e);
                }
            }
        }

        @Override
        public boolean accept(IdsMetadataEvent metadataEvent) {
            if (metadataEvent == null) {
                return true;
            }
            if (this.severityValue == null) {
                return true;
            }
            int severity = metadataEvent.getSeverity();
            return this.accept(severity);
        }

        public boolean accept(int severity) {
            return this.severityValue.contains(severity);
        }

        public String toString() {
            return this.severityDesc;
        }
    }
}

