/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.handler;

import com.sygate.scm.common.configobject.schema.ContentVersionInfo;
import com.sygate.scm.common.configobject.schema.GlobalObjectPool;
import com.sygate.scm.common.configobject.schema.LuAppliedContent;
import com.sygate.scm.common.configobject.schema.LuClientRegistration;
import com.sygate.scm.common.configobject.schema.LuContentCategory;
import com.sygate.scm.common.configobject.schema.LuContentCategoryGroup;
import com.sygate.scm.common.configobject.schema.LuContentPolicy;
import com.sygate.scm.common.configobject.schema.LuDownloadedContent;
import com.sygate.scm.common.configobject.schema.LuDownloadedContentArray;
import com.sygate.scm.common.configobject.schema.LuDownloadedContentPool;
import com.sygate.scm.common.configobject.schema.LuRegistration;
import com.sygate.scm.common.configobject.schema.LuSesmContentCatalog;
import com.sygate.scm.common.configobject.schema.LuSesmContentCatalogPool;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemClientGroupTree;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class IdsLuHandler {
    private Map<String, Map<String, LuDownloadedContent>> contentMap = new HashMap<String, Map<String, LuDownloadedContent>>();
    private Map<String, String> latestSequenceMap = new HashMap<String, String>();
    private String latestSequence = null;
    private Map<String, LuDownloadedContent> latestContentMap = new HashMap<String, LuDownloadedContent>();
    private static List<String> clientMonikerList = null;
    private static final Object clientMonikerListLock = new Object();
    private static volatile IdsLuHandler curHandler = null;
    private static final Object lockObj = new Object();
    private LuDownloadedContent latestCategory;
    private LuDownloadedContent latestSepmMetadataContent;

    private IdsLuHandler() throws ConsoleException {
        this.initializeData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshLatestContent() throws ConsoleException {
        Object object = lockObj;
        synchronized (object) {
            curHandler = null;
        }
    }

    private void initializeData() throws ConsoleException {
        LuDownloadedContentPool contentPool;
        List<String> clientMonikers = this.getAllMoniker();
        DataobjectManager manager = DataobjectManager.getInstance();
        SemConfigRoot configRoot = manager.getSemConfigRoot();
        GlobalObjectPool globalPool = configRoot.getOptGlobalObjectPool();
        if (globalPool != null && (contentPool = globalPool.getOptLuDownloadedContentPool()) != null) {
            ObjReference objRef = contentPool.getObjReference();
            LuDownloadedContentArray downloadArray = manager.getLuDownloadedContentArray(objRef.getTargetId());
            for (LuDownloadedContent luContent : downloadArray.getLuDownloadedContent()) {
                String clientOrServerMoniker = this.getClientOrServerMoniker(luContent);
                String sequence = luContent.getSequenceNum();
                if (clientMonikers.contains(clientOrServerMoniker)) {
                    String curSeq;
                    Map<String, LuDownloadedContent> clientMonikerMap = this.contentMap.get(clientOrServerMoniker);
                    if (clientMonikerMap == null) {
                        clientMonikerMap = new HashMap<String, LuDownloadedContent>();
                        this.contentMap.put(clientOrServerMoniker, clientMonikerMap);
                    }
                    clientMonikerMap.put(sequence, luContent);
                    if (this.latestSequence == null || IdsLuHandler.compareSequenceNumber(this.latestSequence, sequence) < 0) {
                        this.latestSequence = sequence;
                    }
                    if (IdsLuHandler.compareSequenceNumber(curSeq = this.latestSequenceMap.get(clientOrServerMoniker), sequence) < 0) {
                        this.latestSequenceMap.put(clientOrServerMoniker, sequence);
                        this.latestContentMap.put(clientOrServerMoniker, luContent);
                        String tag = luContent.getOptSequenceTag();
                        if (tag != null && tag.equalsIgnoreCase("Update")) {
                            this.latestCategory = luContent;
                        }
                    }
                }
                if (!luContent.getServerMoniker().equals("{F37A1C53-EF4C-4784-986E-C5C511D518B2}")) continue;
                this.latestSepmMetadataContent = luContent;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getAllMoniker() throws ConsoleException {
        Object object = clientMonikerListLock;
        synchronized (object) {
            if (clientMonikerList == null) {
                LuSesmContentCatalogPool categoryPool;
                clientMonikerList = new ArrayList<String>();
                DataobjectManager manager = DataobjectManager.getInstance();
                SemConfigRoot configRoot = manager.getSemConfigRoot();
                GlobalObjectPool globalPool = configRoot.getOptGlobalObjectPool();
                if (globalPool != null && (categoryPool = globalPool.getOptLuSesmContentCatalogPool()) != null) {
                    ObjReference objRef = categoryPool.getObjReference();
                    LuSesmContentCatalog categoryList = manager.getLuSesmContentCatalog(objRef.getTargetId());
                    LuContentCategoryGroup categoryGroup = null;
                    Iterator it = categoryList.getLuContentCategoryGroup().iterator();
                    while (it.hasNext() && !"SECURITY".equals((categoryGroup = (LuContentCategoryGroup)it.next()).getName())) {
                    }
                    LuContentCategory luCategory = null;
                    if (categoryGroup != null) {
                        Iterator it2 = categoryGroup.getLuContentCategory().iterator();
                        while (it2.hasNext() && !"IPS".equals((luCategory = (LuContentCategory)it2.next()).getName())) {
                        }
                    }
                    if (luCategory != null) {
                        String serverMoniker = "";
                        for (LuRegistration registration : luCategory.getLuRegistration()) {
                            LuClientRegistration clientReg = registration.getOptLuClientRegistration();
                            serverMoniker = registration.getLuServerRegistration().getMoniker();
                            if (clientReg != null) {
                                clientMonikerList.add(clientReg.getMoniker());
                                continue;
                            }
                            if (!"{5E614C71-552C-4DD2-B466-F23A4B46880B}".equalsIgnoreCase(serverMoniker)) continue;
                            clientMonikerList.add(serverMoniker);
                        }
                    }
                }
                if (clientMonikerList.size() == 0) {
                    clientMonikerList.add("{01BAFA03-6B97-4906-B1E0-D8EFAEEFC618}");
                }
            }
            return clientMonikerList;
        }
    }

    private InputStream getLatestCategory() throws ConsoleException {
        if (this.latestCategory != null) {
            LuDownloadedContent luContent = this.latestContentMap.get(this.getClientOrServerMoniker(this.latestCategory));
            ObjReference objRef = luContent.getOptObjReference();
            if (objRef == null) {
                throw new ConsoleException(0x16010000);
            }
            PhysicalFile pFile = DataobjectManager.getInstance().getPhysicalFile(objRef.getTargetId());
            ObjReference phyRef = pFile.getObjReference();
            InputStream file = GUIManager.getFile(phyRef.getTargetId());
            BufferedInputStream bis = new BufferedInputStream(file);
            ZipInputStream zipStream = new ZipInputStream(bis);
            ZipEntry entry = null;
            boolean found = false;
            try {
                while ((entry = zipStream.getNextEntry()) != null) {
                    if (!entry.getName().equalsIgnoreCase("Categories.xml")) continue;
                    found = true;
                    break;
                }
                if (found) {
                    ByteArrayInputStream in;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buff = new byte[1024];
                    int len = -1;
                    while ((len = zipStream.read(buff, 0, 1024)) > 0) {
                        out.write(buff, 0, len);
                    }
                    out.flush();
                    out.close();
                    ByteArrayInputStream byteArrayInputStream = in = new ByteArrayInputStream(out.toByteArray());
                    return byteArrayInputStream;
                }
            }
            catch (IOException e) {
                LoggerUtilities.logException((Throwable)e);
                throw new ConsoleException(e);
            }
            finally {
                IOUtilities.closeInputStream((InputStream)zipStream);
                IOUtilities.closeInputStream((InputStream)file);
                IOUtilities.closeInputStream((InputStream)bis);
            }
        }
        return null;
    }

    public static List<LuDownloadedContent> getAllLuContent() throws ConsoleException {
        return IdsLuHandler.getCurrentHandler().getLatestLuContent();
    }

    public static InputStream getCategory() throws ConsoleException {
        return IdsLuHandler.getCurrentHandler().getLatestCategory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IdsLuHandler getCurrentHandler() throws ConsoleException {
        if (curHandler == null) {
            Object object = lockObj;
            synchronized (object) {
                if (curHandler == null) {
                    curHandler = new IdsLuHandler();
                }
            }
        }
        return curHandler;
    }

    public List<LuDownloadedContent> getAllInUseLuContent() throws ConsoleException {
        DataobjectManager manager = DataobjectManager.getInstance();
        SemDomain domain = manager.getCurrentSemDomain();
        ObjReference treeRef = domain.getObjReference();
        SemClientGroupTree groupTree = manager.getSemClientGroupTree(treeRef.getTargetId());
        SemClientGroup group = groupTree.getSemClientGroup();
        HashSet<LuDownloadedContent> allContent = new HashSet<LuDownloadedContent>();
        this.getInUsedLuContent(allContent, group);
        if (allContent.size() == 0) {
            allContent.addAll(this.latestContentMap.values());
        }
        ArrayList<LuDownloadedContent> allOrderedContent = new ArrayList<LuDownloadedContent>(allContent);
        Collections.sort(allOrderedContent, this.getLuDownloadedContentComparator());
        return allOrderedContent;
    }

    public List<LuDownloadedContent> getLatestLuContent() throws ConsoleException {
        HashSet<LuDownloadedContent> allContent = new HashSet<LuDownloadedContent>();
        allContent.addAll(this.latestContentMap.values());
        ArrayList<LuDownloadedContent> allOrderedContent = new ArrayList<LuDownloadedContent>(allContent);
        Collections.sort(allOrderedContent, this.getLuDownloadedContentComparator());
        return allOrderedContent;
    }

    public static LuDownloadedContent getLatestSepmMetadataContent() throws ConsoleException {
        return IdsLuHandler.getCurrentHandler().getSepmMetadataContent();
    }

    private LuDownloadedContent getSepmMetadataContent() {
        return this.latestSepmMetadataContent;
    }

    private void getInUsedLuContent(Set<LuDownloadedContent> allLuContent, SemClientGroup group) throws ConsoleException {
        DataobjectManager manager = DataobjectManager.getInstance();
        ArrayList<LuContentPolicy> list = manager.getAllLuContentPolicies();
        for (LuContentPolicy contentPolicy : list) {
            for (LuAppliedContent content : contentPolicy.getLuAppliedContent()) {
                if (!"IPS".equals(content.getContentCategory()) && !"MAC_IPS".equals(content.getContentCategory())) continue;
                Boolean enable = content.getOptEnabled();
                if (enable == null) {
                    enable = content.getDefEnabled();
                }
                if (!enable.booleanValue()) continue;
                Integer type = content.getOptVersionSelectionType();
                if (type == null) {
                    type = content.getDefVersionSelectionType();
                }
                if (LuAppliedContent.LATEST.equals(type)) {
                    allLuContent.addAll(this.latestContentMap.values());
                    continue;
                }
                for (ContentVersionInfo verInfo : content.getContentVersionInfo()) {
                    String thisMoniker = verInfo.getMoniker();
                    if (!this.getAllMoniker().contains(thisMoniker)) continue;
                    String sequenceNum = verInfo.getSequenceNum();
                    Map<String, LuDownloadedContent> sub_ContentMap = this.contentMap.get(thisMoniker);
                    LuDownloadedContent luContent = sub_ContentMap.get(sequenceNum);
                    allLuContent.add(luContent);
                }
            }
        }
    }

    public static int compareSequenceNumber(String seqNumber1, String seqNumber2) {
        if (seqNumber1 == null) {
            if (seqNumber2 == null) {
                return 0;
            }
            return -1;
        }
        if (seqNumber2 == null) {
            return 1;
        }
        long number1 = 0L;
        long number2 = 0L;
        try {
            number1 = Long.parseLong(seqNumber1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            number2 = Long.parseLong(seqNumber2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return number1 < number2 ? -1 : (number1 == number2 ? 0 : 1);
    }

    private String getClientOrServerMoniker(LuDownloadedContent luContent) {
        String serverMoniker = luContent.getServerMoniker();
        if ("{5E614C71-552C-4DD2-B466-F23A4B46880B}".equalsIgnoreCase(luContent.getServerMoniker())) {
            return serverMoniker;
        }
        return luContent.getOptClientMoniker();
    }

    private Comparator<LuDownloadedContent> getLuDownloadedContentComparator() {
        Comparator<LuDownloadedContent> comnpare = new Comparator<LuDownloadedContent>(){

            @Override
            public int compare(LuDownloadedContent content1, LuDownloadedContent content2) {
                return IdsLuHandler.compareSequenceNumber(content1.getSequenceNum(), content2.getSequenceNum());
            }
        };
        return comnpare;
    }
}

