/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.handler;

import com.sygate.scm.common.configobject.schema.FwIdsLibrary;
import com.sygate.scm.common.configobject.schema.FwIdsLibraryPool;
import com.sygate.scm.common.configobject.schema.IdsSignatureBlock;
import com.sygate.scm.common.configobject.schema.IdsSignatureBlockArray;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.ObjectPool;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsSignatureBlockObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import java.util.ArrayList;
import java.util.Vector;

public class IdsHandler {
    public static final String PREDEFINED = "PREDEFINED";
    public static final String USER_DEFINED = "USER_DEFINED";

    public static ArrayList<IdsLibraryObject> getFwIdsLibraries() throws ConsoleException {
        ArrayList<IdsLibraryObject> idsLibraries = new ArrayList<IdsLibraryObject>();
        SemDomain currentDomain = DataobjectManager.getInstance().getCurrentSemDomain();
        ObjectPool objectPool = currentDomain.getObjectPool();
        FwIdsLibraryPool idsPool = objectPool.getOptFwIdsLibraryPool();
        if (idsPool != null) {
            Vector objReferences = idsPool.getObjReference();
            int count = objReferences.size();
            for (int i = 0; i < count; ++i) {
                ObjReference objRef = (ObjReference)objReferences.get(i);
                String id = objRef.getTargetId();
                String type = objRef.getTargetType();
                FwIdsLibrary idsLibrary = (FwIdsLibrary)DataobjectManager.getInstance().getObjectByGUID(type, id);
                IdsLibraryObject idsLibraryObject = new IdsLibraryObject(idsLibrary);
                idsLibraries.add(idsLibraryObject);
            }
        }
        return idsLibraries;
    }

    public static ArrayList<IdsSignatureBlockObject> getIdsSignatureBlocks(FwIdsLibrary fwIdsLibrary) {
        ArrayList<IdsSignatureBlockObject> idsSignatureBlocks = new ArrayList<IdsSignatureBlockObject>();
        IdsSignatureBlockArray blockArray = fwIdsLibrary.getIdsSignatureBlockArray();
        if (blockArray != null) {
            Vector sigBlocks = blockArray.getIdsSignatureBlock();
            int count = sigBlocks.size();
            for (int i = 0; i < count; ++i) {
                IdsSignatureBlock block = (IdsSignatureBlock)sigBlocks.get(i);
                IdsSignatureBlockObject sigBlockObject = new IdsSignatureBlockObject(block);
                idsSignatureBlocks.add(sigBlockObject);
            }
        }
        return idsSignatureBlocks;
    }
}

