/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.handler;

import com.sygate.scm.common.configobject.schema.ExceptionEvent;
import com.sygate.scm.common.configobject.schema.LogProcess;
import com.sygate.scm.common.configobject.schema.PacketProcess;
import com.sygate.scm.console.util.ConsoleLogger;

public class IdsCategoryHelper {
    private static final int CANARY_MIN = 50000;
    private static final int CANARY_MAX = 54999;
    private static final int WEB_ATTACK_MIN_1 = 55000;
    private static final int WEB_ATTACK_MAX_1 = 55001;
    private static final int UADLP_MIN = 59000;
    private static final int UADLP_MAX = 59999;
    public static final int GEM_MIN = 61000;
    public static final int GEM_MAX = 61999;
    private static final int NOP_MIN = 62000;
    private static final int NOP_MAX = 64999;
    private static final int ROP_MIN = 65000;
    private static final int ROP_MAX = 67999;
    private static final int WEB_ATTACK_MIN_2 = 70000;
    private static final int WEB_ATTACK_MAX_2 = 79999;
    private static final int[][] IPS_BROWSER_PROTECTION_IDS = new int[][]{{50000, 54999}, {55000, 55001}, {59000, 59999}, {62000, 64999}, {65000, 67999}, {70000, 79999}};

    public static boolean isBrowserProtectionSignature(String eventId) {
        boolean isBPSig = false;
        try {
            Integer eventIdInt = Integer.valueOf(eventId);
            isBPSig = IdsCategoryHelper.isBrowserProtectionSignature(eventIdInt);
        }
        catch (NumberFormatException e) {
            ConsoleLogger.log("Invalid string received for IPS Exception event id. " + eventId);
            ConsoleLogger.log(e);
        }
        return isBPSig;
    }

    public static boolean isBrowserProtectionSigInvalidAction(ExceptionEvent event) {
        boolean isActionLogInvalid = false;
        if (IdsCategoryHelper.isBrowserProtectionSignature(event.getEventId())) {
            LogProcess lp;
            PacketProcess pp;
            if (event.getAction() != null && event.getAction().getOptPacketProcess() != null && !PacketProcess.PASS.equals((pp = event.getAction().getOptPacketProcess()).getPacketProcess())) {
                isActionLogInvalid = true;
            }
            if (!isActionLogInvalid && event.getAction() != null && event.getAction().getOptLogProcess() != null && !Boolean.FALSE.equals((lp = event.getAction().getOptLogProcess()).getOptLogEvent() != null ? lp.getOptLogEvent() : lp.getDefLogEvent())) {
                isActionLogInvalid = true;
            }
        }
        return isActionLogInvalid;
    }

    public static boolean isBrowserProtectionSignature(int eventId) {
        for (int min = 0; min < IPS_BROWSER_PROTECTION_IDS.length; ++min) {
            if (eventId < Integer.valueOf(IPS_BROWSER_PROTECTION_IDS[min][0]) || eventId > Integer.valueOf(IPS_BROWSER_PROTECTION_IDS[min][1])) continue;
            return true;
        }
        return false;
    }

    public static boolean isIntrusionPreventionSignature(int eventId) {
        return !IdsCategoryHelper.isBrowserProtectionSignature(eventId);
    }
}

