/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.handler;

import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.ids.handler.IdsCategoryHelper;
import com.sygate.scm.console.ui.policy.ids.handler.IdsLuHandler;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsMetadataEvent;
import com.sygate.scm.console.ui.policy.ids.logicobject.MetadataEventFilter;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class IdsCategoryHandler {
    private static IdsCategoryHandler curHandler = null;
    private static String ALL = IdsCategoryHandler.getString("IdsCategoryHandler.AllCategory");
    private List<IdsCategoryFilter> categoryList = new ArrayList<IdsCategoryFilter>();
    static final IdsCategoryFilter[] defaultFilters = new IdsCategoryFilter[]{new IdsCategoryFilter(null, ALL)};

    public static final List<IdsCategoryFilter> getDefaultList() {
        return Arrays.asList(defaultFilters);
    }

    private IdsCategoryHandler() throws ConsoleException {
        this.initializeData();
    }

    public static void refreshCategory() {
        curHandler = null;
    }

    public static List<IdsCategoryFilter> getCategoryList() throws ConsoleException {
        return IdsCategoryHandler.getCurrentHandler().categoryList;
    }

    private static IdsCategoryHandler getCurrentHandler() throws ConsoleException {
        if (curHandler == null) {
            curHandler = IdsCategoryHandler.getNewInstance();
        }
        return curHandler;
    }

    private void initializeData() throws ConsoleException {
        this.categoryList.clear();
        this.categoryList.add(new IdsCategoryFilter(null, ALL));
        this.categoryList.add(new IdsCategoryFilter(null, IdsCategoryHandler.getString("IdsCategoryHandler.Browser.Protecion")));
        this.categoryList.add(new IdsCategoryFilter(null, IdsCategoryHandler.getString("IdsCategoryHandler.Intrusion.Prevention")));
        this.categoryList.add(new IdsCategoryFilter(null, IdsCategoryHandler.getString("IdsCategoryHandler.server.signature.set")));
        InputStream in = IdsLuHandler.getCategory();
        if (in != null) {
            try {
                this.createCategoryList(in);
            }
            catch (IOException e1) {
                LoggerUtilities.logException((Throwable)e1);
                throw new ConsoleException(e1);
            }
            catch (SAXException e1) {
                LoggerUtilities.logException((Throwable)e1);
                throw new ConsoleException(e1);
            }
        }
    }

    private void createCategoryList(InputStream in) throws IOException, SAXException {
        Document doc = XMLHelper.parse((InputStream)in);
        Element root = doc.getDocumentElement();
        ArrayList allCategory = XMLHelper.getChildElementByName((Element)root, (String)"Category");
        this.createFilter(allCategory, null);
    }

    private void createFilter(List<Element> allCategory, IdsCategoryFilter parent) {
        for (Element e : allCategory) {
            IdsCategoryFilter filter = this.createCategoryFilter(e, parent);
            this.categoryList.add(filter);
            ArrayList children = XMLHelper.getChildElementByName((Element)e, (String)"Category");
            this.createFilter(children, filter);
        }
    }

    private IdsCategoryFilter createCategoryFilter(Element e, IdsCategoryFilter parent) {
        String name = XMLHelper.getAttribute((Element)e, (String)"name");
        return new IdsCategoryFilter(parent, name);
    }

    public static IdsCategoryHandler getNewInstance() throws ConsoleException {
        curHandler = new IdsCategoryHandler();
        return curHandler;
    }

    private static String getString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", key);
    }

    public static class IdsCategoryFilter
    implements MetadataEventFilter {
        private String name;
        private int level;

        public IdsCategoryFilter(IdsCategoryFilter parent, String thisName) {
            this.name = thisName;
            this.level = parent != null ? parent.level + 1 : 0;
        }

        public int getLevel() {
            return this.level;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public boolean accept(IdsMetadataEvent metadataEvent) {
            if (this.name.equals(ALL)) {
                return true;
            }
            List<String> categories = metadataEvent.getCategories();
            Integer eventId = Integer.valueOf(metadataEvent.getId());
            for (String category : categories) {
                if (!(category.equals(this.name) || this.name.equals(IdsCategoryHandler.getString("IdsCategoryHandler.Browser.Protecion")) && IdsCategoryHelper.isBrowserProtectionSignature(eventId) || this.name.equals(IdsCategoryHandler.getString("IdsCategoryHandler.server.signature.set")) && metadataEvent.getShowIPSServerSig()) && (!this.name.equals(IdsCategoryHandler.getString("IdsCategoryHandler.Intrusion.Prevention")) || IdsCategoryHelper.isBrowserProtectionSignature(eventId) || metadataEvent.getShowIPSServerSig())) continue;
                return true;
            }
            return false;
        }
    }
}

