/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.ids.dialog.ExceptionListDialog;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsMetadataEvent;
import com.sygate.scm.console.ui.policy.ids.logicobject.MetadataEventFilter;
import com.sygate.scm.console.ui.policy.ids.logicobject.WinIdsMetadataObject;
import com.sygate.scm.console.ui.util.HTMLEditorPane;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class WinExceptionListDialog
extends ExceptionListDialog {
    private static final long serialVersionUID = 1L;

    public WinExceptionListDialog(JFrame owner, String title, List<IdsMetadataEvent> data) throws HeadlessException {
        super(owner, title, data);
    }

    @Override
    protected boolean isBrowserIPSExceptionSelected(int[] indexList) {
        boolean browswerProtectionExceptionSeclected = false;
        for (int i = 0; i < indexList.length; ++i) {
            IdsMetadataEvent event = (IdsMetadataEvent)this.getExceptionModel().getRow(indexList[i]);
            if (!this.isBrowserProtectionIDS(event)) continue;
            browswerProtectionExceptionSeclected = true;
            break;
        }
        return browswerProtectionExceptionSeclected;
    }

    @Override
    protected void getFilterComponents() {
        JLabel categoryLbl = new JLabel(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.ShowCategory"));
        this.filterPanel.add((Component)categoryLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.filterPanel.add(this.getCategoryList(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 0, 15), 0, 0));
        JLabel showSeverityLbl = new JLabel(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.ShowSeverity"));
        this.filterPanel.add((Component)showSeverityLbl, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.filterPanel.add(this.getSeverityList(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 2, 0, 15), 0, 0));
    }

    @Override
    protected void fiterTable() {
        MetadataEventFilter filter1 = (MetadataEventFilter)this.getCategoryList().getSelectedItem();
        MetadataEventFilter filter2 = (MetadataEventFilter)this.getSeverityList().getSelectedItem();
        if (this.curFilter1 == filter1 && this.curFilter2 == filter2) {
            return;
        }
        this.getExceptionModel().removeAll();
        this.getNumberLbl().setText(String.valueOf(0));
        try {
            Vector<TableRow> resultData = new Vector<TableRow>();
            List<IdsMetadataEvent> metadataEventList = this.stripGEMSignatures(WinIdsMetadataObject.getIdsMetadataEventList());
            for (IdsMetadataEvent event : metadataEventList) {
                if (!filter1.accept(event) || !filter2.accept(event)) continue;
                resultData.add(event);
            }
            this.getExceptionModel().setDataVector(resultData);
            this.getExceptionModel().sortTable(-1);
            this.getNumberLbl().setText(String.valueOf(resultData.size()));
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.No_Metadata_File"));
        }
        this.curFilter1 = filter1;
        this.curFilter2 = filter2;
    }

    @Override
    protected JPanel getLinkPanel() {
        JPanel linkPanel = null;
        linkPanel = new JPanel();
        linkPanel.setLayout(new BoxLayout(linkPanel, 1));
        HTMLEditorPane linkPane = new HTMLEditorPane();
        String desc = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.linkText");
        linkPane.setText(ids_url1 + desc + "</a></body></html>");
        linkPanel.add(linkPane);
        return linkPanel;
    }
}

