/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.ids.dialog.EventActionDialog;
import com.sygate.scm.console.ui.policy.ids.dialog.EventNoActionDialog;
import com.sygate.scm.console.ui.policy.ids.dialog.ExceptionListDialog;
import com.sygate.scm.console.ui.policy.ids.dialog.ExceptionPanel;
import com.sygate.scm.console.ui.policy.ids.dialog.MacExceptionListDialog;
import com.sygate.scm.console.ui.policy.ids.handler.IdsCategoryHandler;
import com.sygate.scm.console.ui.policy.ids.handler.IdsLuHandler;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsEventObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsMetadataEvent;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsPolicyObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.MacIPSMetadataObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Frame;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class MacIpsExceptionPanel
extends ExceptionPanel {
    private static final long serialVersionUID = 1L;
    protected IdsPolicyObject idsPolicyObject;
    private SortableTableModel exceptionModel;
    private JComboBox<String> actionCombo;

    public void setObject(IdsPolicyObject idsPolicyObj) throws ConsoleException {
        this.idsPolicyObject = idsPolicyObj;
        MacIPSMetadataObject.refreshNewInstance();
        IdsLuHandler.refreshLatestContent();
        IdsCategoryHandler.refreshCategory();
        this.getExceptionModel().setDataVector(new Vector<TableRow>(this.idsPolicyObject.getMacExceptionList()));
    }

    @Override
    protected void addException() {
        List<IdsMetadataEvent> data;
        try {
            data = this.getIdsMetadataEventList();
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            UIUtilities.showWarningDialog(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.No_Metadata_File"));
            return;
        }
        if (data.size() == 0) {
            UIUtilities.showWarningDialog(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.ExceptionListEmpty"));
            return;
        }
        ExceptionListDialog dlg = this.getExceptionListDialog(data);
        dlg.setVisible(true);
        int row = -1;
        if (dlg.isOk()) {
            List<IdsEventObject> allIdsObj = dlg.getEventList();
            for (IdsEventObject eventObj : allIdsObj) {
                this.removeExistingObj(eventObj.getEvent().getEventId());
                this.getExceptionModel().addRow(eventObj);
                this.addEvent(eventObj);
                if (row != -1) continue;
                row = this.getExceptionModel().getRowIndex(eventObj);
            }
            if (row != -1) {
                this.getExceptionTable().setRowSelectionInterval(row, this.getExceptionModel().getRowCount() - 1);
            }
        }
    }

    @Override
    protected void deleteException() {
        int answer;
        int[] index = this.getExceptionTable().getSelectedRows();
        if (index.length > 0 && (answer = JOptionPane.showConfirmDialog(Manager.getFrame(), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.DoYouWantDeleteIt"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.DeleteEvent"), 0)) == 0) {
            int cnt = 0;
            for (int i = 0; i < index.length; ++i) {
                IdsEventObject eventObj = (IdsEventObject)this.getExceptionModel().getRow(index[i] - cnt);
                this.idsPolicyObject.deleteMacEvent(eventObj);
                this.getExceptionModel().removeRow(index[i] - cnt);
                ++cnt;
            }
        }
    }

    @Override
    protected void editException() {
        int[] index = this.getExceptionTable().getSelectedRows();
        if (index.length > 0) {
            boolean isLog;
            boolean isBlock;
            IdsEventObject eventObj = (IdsEventObject)this.getExceptionModel().getRow(index[0]);
            boolean browserProtectionExceptionSeclected = false;
            DialogBase dlg = null;
            boolean isOk = false;
            if (browserProtectionExceptionSeclected) {
                dlg = new EventNoActionDialog((Frame)Manager.getFrame(), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.EventDlgTitle"));
                dlg.setVisible(true);
                isOk = !((EventNoActionDialog)dlg).isCancelled();
            } else {
                dlg = new EventActionDialog((Frame)Manager.getFrame(), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.EventDlgTitle"));
                isBlock = eventObj.getAction();
                isLog = eventObj.getLog();
                ((EventActionDialog)dlg).setObject(isBlock, isLog);
                dlg.setVisible(true);
                boolean bl = isOk = !((EventActionDialog)dlg).isCancelled();
            }
            if (!browserProtectionExceptionSeclected && isOk) {
                isBlock = ((EventActionDialog)dlg).isBlock();
                isLog = ((EventActionDialog)dlg).isLog();
                for (int i = 0; i < index.length; ++i) {
                    IdsEventObject event = (IdsEventObject)this.getExceptionModel().getRow(index[i]);
                    event.setLog(isLog);
                    event.setAction(isBlock);
                    this.getExceptionModel().fireTableRowsUpdated(index[i], index[i]);
                }
            }
        }
    }

    @Override
    protected SortableTableModel getExceptionModel() {
        if (this.exceptionModel == null) {
            this.exceptionModel = new SortableTableModel(){
                private static final long serialVersionUID = -4151459433427962374L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return column == 4 || column == 5;
                }

                @Override
                public void setValueAt(Object value, int row, int column) {
                    if (column == 4) {
                        super.setValueAt(MacIpsExceptionPanel.this.actionCombo.getSelectedItem(), row, column);
                    } else {
                        super.setValueAt(value, row, column);
                    }
                }
            };
            this.exceptionModel.setColumnNames(TABLE_COLUMN_NAME);
        }
        return this.exceptionModel;
    }

    protected ExceptionListDialog getExceptionListDialog(List<IdsMetadataEvent> data) {
        MacExceptionListDialog dlg = new MacExceptionListDialog((JFrame)Manager.getFrame(), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.ExceptionListDialogTitle"), data);
        return dlg;
    }

    public void addEvent(IdsEventObject eventObj) {
        this.idsPolicyObject.addMacEvent(eventObj);
    }

    protected IdsPolicyObject getPolicyObject() {
        return this.idsPolicyObject;
    }

    protected List<IdsMetadataEvent> getIdsMetadataEventList() throws ConsoleException {
        return MacIPSMetadataObject.getIdsMetadataEventList();
    }

    @Override
    protected JComboBox<String> getActionCombo() {
        if (this.actionCombo == null) {
            this.actionCombo = new JComboBox<String>(ACTION_ITEMS);
        }
        return this.actionCombo;
    }

    private IdsEventObject removeExistingObj(String eventId) {
        List<TableRow> allRows = this.getExceptionModel().getAllRows();
        IdsEventObject eventObj = null;
        Iterator<TableRow> it = allRows.iterator();
        int index = 0;
        while (it.hasNext() && !(eventObj = (IdsEventObject)it.next()).getEvent().getEventId().equals(eventId)) {
            ++index;
        }
        if (index < this.getExceptionModel().getRowCount()) {
            this.getExceptionModel().removeRow(index);
            this.idsPolicyObject.deleteMacEvent(eventObj);
        }
        return eventObj;
    }
}

