/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.ids.dialog.ExceptionListDialog;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsMetadataEvent;
import com.sygate.scm.console.ui.policy.ids.logicobject.MacIPSMetadataObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.MetadataEventFilter;
import com.sygate.scm.console.ui.util.HTMLEditorPane;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class MacExceptionListDialog
extends ExceptionListDialog {
    private static final long serialVersionUID = 1L;

    public MacExceptionListDialog(JFrame owner, String title, List<IdsMetadataEvent> data) throws HeadlessException {
        super(owner, title, data);
    }

    @Override
    protected boolean isBrowserIPSExceptionSelected(int[] indexList) {
        return false;
    }

    @Override
    protected boolean isBrowserProtectionIDS(IdsMetadataEvent event) {
        return false;
    }

    @Override
    protected void getFilterComponents() {
        Color background = UIManager.getColor("TableHeader.background");
        JLabel showSeverityLbl = new JLabel(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.ShowSeverity"));
        this.filterPanel.add((Component)showSeverityLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.filterPanel.add(this.getSeverityList(), new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 15), 0, 0));
        JPanel innerFilterPanel = new JPanel();
        innerFilterPanel.setLayout(new BorderLayout());
        innerFilterPanel.setBackground(background);
        this.filterPanel.setBackground(background);
        innerFilterPanel.add((Component)this.filterPanel, "West");
        this.filterPanel = innerFilterPanel;
    }

    @Override
    protected void fiterTable() {
        MetadataEventFilter filter2 = (MetadataEventFilter)this.getSeverityList().getSelectedItem();
        if (this.curFilter2 == filter2) {
            return;
        }
        this.getExceptionModel().removeAll();
        this.getNumberLbl().setText(String.valueOf(0));
        try {
            Vector<TableRow> resultData = new Vector<TableRow>();
            for (IdsMetadataEvent event : MacIPSMetadataObject.getIdsMetadataEventList()) {
                if (!filter2.accept(event)) continue;
                resultData.add(event);
            }
            this.getExceptionModel().setDataVector(resultData);
            this.getExceptionModel().sortTable(-1);
            this.getNumberLbl().setText(String.valueOf(resultData.size()));
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.No_Metadata_File"));
        }
        this.curFilter2 = filter2;
    }

    @Override
    protected JPanel getLinkPanel() {
        JPanel linkPanel = null;
        linkPanel = new JPanel();
        linkPanel.setLayout(new BoxLayout(linkPanel, 1));
        HTMLEditorPane linkPane = new HTMLEditorPane();
        String desc = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "MacExceptionListDialog.linkText");
        linkPane.setText(ids_url1 + desc + "</a></body></html>");
        linkPanel.add(linkPane);
        return linkPanel;
    }
}

