/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.schema.FwIdsLibrary;
import com.sygate.scm.common.configobject.schema.IdsMacro;
import com.sygate.scm.common.configobject.schema.IdsMacroArray;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.ids.IdsPopupMenu;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsVariableDialog;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsMacroObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IdsVariablePanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -7394442131998381934L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private String[] COLUMN_NAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariablePanel.column.Enabled"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariablePanel.column.Name"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariablePanel.column.Desc"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariablePanel.column.COntent")};
    private JTable variablesTable;
    private SortableTableModel tableModel;
    private IdsPopupMenu popupMenu;
    private JButton addButton;
    private JButton deleteButton;
    private JButton editButton;
    private Action addAction;
    private Action deleteAction;
    private Action editAction;
    private Action copyAction;
    private Action pasteAction;
    private JPanel centerPanel;
    private JPanel buttonPanel;
    private IdsLibraryObject idsLibraryObject;
    private IdsMacroObject idsMacroObject;
    private IdsMacroArray idsMacroArray;
    private Vector<IdsMacroObject> variables;
    private boolean isSystemLibrary;
    private boolean isReadOnly;
    private DescriptionTextArea desc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariablePanel.DescAvailableVars"));

    public IdsVariablePanel(IdsLibraryObject idsLibraryObject, boolean isSystemLibrary) {
        this.idsLibraryObject = idsLibraryObject;
        this.isSystemLibrary = isSystemLibrary;
        this.init();
        this.setValues();
    }

    public void recoverButtonsEnableStatus(boolean isEnabled) {
        isEnabled = this.isReadOnly ? false : isEnabled;
        int selectedRow = this.getVariablesTable().getSelectedRow();
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        this.getEditAction().setEnabled(!AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context) && selectedRow != -1);
        this.getCopyAction().setEnabled(selectedRow != -1);
        boolean hasCopy = PolicyHandler.hasCopiedObject(IdsMacroObject.class);
        this.getPasteAction().setEnabled(isEnabled && hasCopy);
        this.synchronizeButtons();
    }

    protected void actionStatusChanged() {
        if (this.getVariablesTable().isEnabled()) {
            int row = this.getVariablesTable().getSelectedRow();
            boolean noSelection = row == -1;
            this.getDeleteAction().setEnabled(!this.isSystemLibrary && !noSelection);
            this.getEditAction().setEnabled(!this.isSystemLibrary && !noSelection);
            this.getAddAction().setEnabled(!this.isSystemLibrary);
            this.setControls();
        }
    }

    protected void itemPaste(ActionEvent parm1) {
        try {
            if (PolicyHandler.hasCopiedObject(IdsMacroObject.class)) {
                IdsMacroObject newObj = (IdsMacroObject)PolicyHandler.getPastedObject();
                String name = MessageFormat.format(this.getRes("ItemPasteCopyOf"), newObj.getName());
                int i = 2;
                while (!this.idsMacroObject.checkNewName(this.getIdsMacroArray(), name)) {
                    name = MessageFormat.format(this.getRes("ItemPasteMultipleCopyOf"), Integer.toString(i), newObj.getName());
                    ++i;
                }
                newObj.setName(name);
                this.idsMacroArray.addIdsMacro(newObj.getIdsMacro());
                this.getTableModel().addRow(newObj);
                this.recoverButtonsEnableStatus(newObj.isEnabled());
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariablePanel.title.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getCenterPanel(), "Center");
    }

    private void setValues() {
        this.getTableModel().setDataVector((Vector)Cast.cast(this.getVariables()));
        this.actionStatusChanged();
    }

    private Vector<IdsMacroObject> getVariables() {
        if (this.variables == null) {
            this.variables = new Vector();
            if (this.getIdsMacroArray() != null) {
                Vector idsMacros = this.getIdsMacroArray().getIdsMacro();
                int count = idsMacros.size();
                for (int i = 0; i < count; ++i) {
                    IdsMacro macro = (IdsMacro)idsMacros.get(i);
                    IdsMacroObject macroObj = new IdsMacroObject(macro);
                    this.variables.add(macroObj);
                }
            }
        }
        return this.variables;
    }

    private IdsMacroArray getIdsMacroArray() {
        FwIdsLibrary idsLibrary = this.idsLibraryObject.getFwIdsLibrary();
        this.idsMacroArray = idsLibrary.getOptIdsMacroArray();
        if (this.idsMacroArray == null) {
            this.idsMacroArray = new IdsMacroArray();
            idsLibrary.setOptIdsMacroArray(this.idsMacroArray);
        }
        return this.idsMacroArray;
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BorderLayout());
            JScrollPane scroll = new JScrollPane();
            this.centerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            UiUtilities.setupScrollPane((JScrollPane)scroll, (JTable)this.getVariablesTable());
            scroll.getViewport().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getModifiers() == 4) {
                        IdsVariablePanel.this.getVariablesTable().clearSelection();
                        IdsVariablePanel.this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.centerPanel.add((Component)this.desc, "North");
            this.centerPanel.add((Component)scroll, "Center");
            this.centerPanel.add((Component)this.getButtonPanel(), "South");
        }
        return this.centerPanel;
    }

    private JTable getVariablesTable() {
        if (this.variablesTable == null) {
            this.variablesTable = new StripesTable();
            this.variablesTable.setSelectionMode(0);
            this.variablesTable.setAutoResizeMode(4);
            this.variablesTable.setModel(this.getTableModel());
            this.variablesTable.getColumnModel().getColumn(0).setPreferredWidth(60);
            this.variablesTable.getColumnModel().getColumn(1).setPreferredWidth(150);
            this.variablesTable.getColumnModel().getColumn(2).setPreferredWidth(280);
            this.variablesTable.getColumnModel().getColumn(3).setPreferredWidth(195);
            this.variablesTable.addMouseListener(this.getTableMouseListener());
            this.variablesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    IdsVariablePanel.this.actionStatusChanged();
                    IdsVariablePanel.this.setControls();
                }
            });
        }
        return this.variablesTable;
    }

    private SortableTableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new SortableTableModel(){
                private static final long serialVersionUID = 5235831010176117833L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return column == 0;
                }
            };
            this.tableModel.setColumnNames(this.COLUMN_NAMES);
        }
        return this.tableModel;
    }

    private MouseListener getTableMouseListener() {
        MouseAdapter tableMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point p = e.getPoint();
                int row = IdsVariablePanel.this.getVariablesTable().rowAtPoint(p);
                if (row >= 0) {
                    IdsVariablePanel.this.getVariablesTable().getSelectionModel().setSelectionInterval(row, row);
                }
                if (e.getModifiers() == 4 && IdsVariablePanel.this.getVariablesTable().isEnabled()) {
                    IdsVariablePanel.this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                } else if (e.getClickCount() == 2 && IdsVariablePanel.this.getEditAction().isEnabled()) {
                    IdsVariablePanel.this.editButton.doClick();
                }
            }
        };
        return tableMouseListener;
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            Action[] actions = new Action[]{this.getAddAction(), this.getEditAction(), this.getDeleteAction(), this.getCopyAction(), this.getPasteAction()};
            this.popupMenu = new IdsPopupMenu(actions);
        }
        return this.popupMenu;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            JButton[] buttons = new JButton[]{this.getAddButton(), this.getEditButton(), this.getDeleteButton()};
            this.buttonPanel = new ButtonPane(buttons, 1);
        }
        return this.buttonPanel;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton(this.getAddAction());
        }
        return this.addButton;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton(this.getDeleteAction());
        }
        return this.deleteButton;
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton(this.getEditAction());
        }
        return this.editButton;
    }

    private Action getAddAction() {
        if (this.addAction == null) {
            this.addAction = new AbstractAction(UIText.get(5)){
                private static final long serialVersionUID = 7776322672281722307L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdsMacroObject macroObject = new IdsMacroObject();
                    IdsVariableDialog dialog = new IdsVariableDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariablePanel.title.AddVar"), macroObject, IdsVariablePanel.this.getAllMacroName(null));
                    if (!dialog.isCancelled()) {
                        IdsMacro idsMacro = macroObject.getIdsMacro();
                        IdsVariablePanel.this.getIdsMacroArray().addIdsMacro(idsMacro);
                        IdsVariablePanel.this.getTableModel().addRow(macroObject);
                    }
                }
            };
        }
        return this.addAction;
    }

    private List<String> getAllMacroName(String existedName) {
        ArrayList<String> allNames = new ArrayList<String>();
        IdsMacroArray macroArray = this.getIdsMacroArray();
        Vector allMacro = macroArray.getIdsMacro();
        for (IdsMacro macro : allMacro) {
            String macroName = macro.getName();
            if (macroName.equals(existedName)) continue;
            allNames.add(macro.getName());
        }
        return allNames;
    }

    private Action getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new AbstractAction(UIText.get(769)){
                private static final long serialVersionUID = 2527908727599211087L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = IdsVariablePanel.this.getVariablesTable().getSelectedRow();
                    if (index == -1) {
                        JOptionPane.showMessageDialog(IdsVariablePanel.this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariablePanel.error.SelectVarForDelete"));
                        return;
                    }
                    String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariablePanel.ConfirmDeleteVar");
                    int confirmOption = JOptionPane.showConfirmDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariablePanel.title.Warning"), 2, 2);
                    if (confirmOption == 0) {
                        IdsMacroObject idsMacroObject = (IdsMacroObject)IdsVariablePanel.this.getTableModel().getRow(index);
                        IdsMacro idsMacro = idsMacroObject.getIdsMacro();
                        IdsVariablePanel.this.getIdsMacroArray().removeIdsMacro(idsMacro);
                        IdsVariablePanel.this.getTableModel().removeRow(index);
                    }
                }
            };
        }
        return this.deleteAction;
    }

    private Action getCopyAction() {
        if (this.copyAction == null) {
            this.copyAction = new AbstractAction(UIText.get(520)){
                private static final long serialVersionUID = 5021698084582015787L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdsVariablePanel.this.itemCopy(e);
                }
            };
        }
        return this.copyAction;
    }

    private Action getPasteAction() {
        if (this.pasteAction == null) {
            this.pasteAction = new AbstractAction(UIText.get(3840)){
                private static final long serialVersionUID = -4498975624089470417L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdsVariablePanel.this.itemPaste(e);
                }
            };
        }
        return this.pasteAction;
    }

    private void itemCopy(ActionEvent parm1) {
        int index = this.getVariablesTable().getSelectedRow();
        if (index == -1) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariablePanel.error.SelectVarForEdit"));
            return;
        }
        this.idsMacroObject = (IdsMacroObject)this.getTableModel().getRow(index);
        PolicyHandler.copyObject(this.idsMacroObject);
        if (!this.isSystemLibrary && !this.pasteAction.isEnabled()) {
            this.pasteAction.setEnabled(true);
        }
    }

    private void synchronizeButtons() {
        this.getAddButton().setEnabled(this.getAddAction().isEnabled());
        this.getDeleteButton().setEnabled(this.getDeleteAction().isEnabled());
        this.getEditButton().setEnabled(this.getEditAction().isEnabled());
    }

    private void setControls() {
        this.recoverButtonsEnableStatus(this.idsMacroObject != null && this.idsMacroObject.isEnabled() != false);
    }

    private String getRes(String key) {
        String component = "IdsVariablePanel.";
        return MSGRES.getString("com.sygate.scm.console.ui.policy.ids.ids", component + key);
    }

    private Action getEditAction() {
        if (this.editAction == null) {
            this.editAction = new AbstractAction(UIText.get(1024)){
                private static final long serialVersionUID = 3045276212916621090L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = IdsVariablePanel.this.getVariablesTable().getSelectedRow();
                    if (index == -1) {
                        JOptionPane.showMessageDialog(IdsVariablePanel.this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariablePanel.error.SelectVarForEdit"));
                        return;
                    }
                    IdsMacroObject idsMacroObject = (IdsMacroObject)IdsVariablePanel.this.getTableModel().getRow(index);
                    try {
                        IdsMacroObject idsMacroObjectCopy = idsMacroObject.getClone();
                        IdsVariableDialog dialog = new IdsVariableDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariablePanel.title.EditVar"), idsMacroObjectCopy, IdsVariablePanel.this.getAllMacroName(idsMacroObjectCopy.getName()));
                        if (!dialog.isCancelled()) {
                            IdsVariablePanel.this.getIdsMacroArray().setIdsMacro(index, idsMacroObjectCopy.getIdsMacro());
                            IdsVariablePanel.this.getTableModel().setRow(index, idsMacroObjectCopy);
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariablePanel.title.ConsoleError"), 0);
                        Manager.getFrame().showLoginPanel();
                    }
                }
            };
        }
        return this.editAction;
    }

    public void setReadOnly() {
        this.isReadOnly = true;
        this.getVariablesTable().setEnabled(false);
        this.getAddAction().setEnabled(false);
        this.getEditAction().setEnabled(false);
        this.getDeleteAction().setEnabled(false);
        this.getCopyAction().setEnabled(false);
        this.getPasteAction().setEnabled(false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_ids_custom_variable";
    }
}

