/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsMacroObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class IdsVariableDialog
extends DialogBase {
    private static final long serialVersionUID = -2738905508826406592L;
    public static final String NAME_NOT_ALLOWED = "\\*?<>|\": ";
    public static final String CONTENT_NOT_ALLOWED = "\\*?<>|\" `~!@#$%^&_-+=';{}[]";
    private JTextField nameTextField;
    private JTextArea descArea;
    private JTextArea contentArea;
    private IdsMacroObject idsMacroObject;
    private List<String> allNames;

    public IdsVariableDialog(String title, IdsMacroObject idsMacroObject, List<String> allNames) {
        super(Manager.getFrame(), title, true);
        this.idsMacroObject = idsMacroObject;
        this.allNames = allNames;
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(new Dimension(400, 210));
        JPanel newPanel = new JPanel(new GridBagLayout());
        JLabel nameLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariableDialog.label.Name"));
        newPanel.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        newPanel.add((Component)this.getNameTextField(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        JLabel descLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariableDialog.label.Desc"));
        newPanel.add((Component)descLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        JScrollPane scroll = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scroll, (JTextArea)this.getDescTextArea());
        newPanel.add((Component)scroll, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariableDialog.title.Content")));
        JScrollPane contentScroll = new JScrollPane(this.getContentTextArea());
        contentPanel.add((Component)contentScroll, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 17, 1, new Insets(1, 1, 0, 1), 0, 0));
        newPanel.add((Component)contentPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 250, 50));
        this.getContentPane().add((Component)newPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setValues();
        this.pack();
        this.setResizable(false);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    private void setValues() {
        this.getNameTextField().setText(this.idsMacroObject.getName());
        this.getDescTextArea().setText(this.idsMacroObject.getDesc());
        this.getContentTextArea().setText(this.idsMacroObject.getContent());
    }

    private JTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new JTextField("", 40);
            RestrictedPlainDocument doc = new RestrictedPlainDocument(255);
            doc.setValidator(NAME_NOT_ALLOWED, false);
            this.nameTextField.setDocument(doc);
            this.nameTextField.setBounds(85, 10, 250, 20);
        }
        return this.nameTextField;
    }

    private JTextArea getDescTextArea() {
        if (this.descArea == null) {
            RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
            this.descArea = new JTextArea();
            this.descArea.setWrapStyleWord(true);
            this.descArea.setLineWrap(true);
            this.descArea.setRows(2);
            this.descArea.setDocument(doc);
        }
        return this.descArea;
    }

    private JTextArea getContentTextArea() {
        if (this.contentArea == null) {
            RestrictedPlainDocument doc = new RestrictedPlainDocument(255);
            doc.setValidator(CONTENT_NOT_ALLOWED, false);
            this.contentArea = new JTextArea();
            this.contentArea.setWrapStyleWord(true);
            this.contentArea.setLineWrap(true);
            this.contentArea.setRows(3);
            this.contentArea.setDocument(doc);
        }
        return this.contentArea;
    }

    @Override
    protected boolean isValidate() {
        String name = this.getNameTextField().getText().trim();
        String content = this.contentArea.getText();
        boolean nameBad = false;
        if (this.isEmpty(name)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariableDialog.error.NameRequired"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariableDialog.title.InvalidName"), 0);
            nameBad = true;
        } else if (!name.matches("[a-zA-Z_]\\w*")) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariableDialog.error.NameUnmatchNamedRule"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariableDialog.title.InvalidName"), 0);
            nameBad = true;
        } else if (this.allNames != null && this.allNames.contains(name)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariableDialog.error.NameExists"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariableDialog.title.InvalidName"), 0);
            nameBad = true;
        }
        if (nameBad) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdsVariableDialog.this.getNameTextField().requestFocus();
                }
            });
            return false;
        }
        if (this.isEmpty(content)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariableDialog.error.ContentRequired"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsVariableDialog.title.InvalidContent"), 0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdsVariableDialog.this.contentArea.requestFocus();
                }
            });
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        this.updateValues();
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public boolean isCancelled() {
        return !this.isOk;
    }

    private void updateValues() {
        this.idsMacroObject.setName(this.getNameTextField().getText().trim());
        this.idsMacroObject.setDesc(this.getDescTextArea().getText());
        this.idsMacroObject.setContent(this.getContentTextArea().getText().trim());
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_ids_custom_variable_add";
    }
}

