/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.common.configobject.schema.IdsSignature;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.ids.IdsPopupMenu;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsSignatureDialog;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsSignatureBlockObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsSignatureObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IdsSignaturePanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = -5403351990205765921L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private String[] COLUMN_NAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignaturePanel.column.Enabled"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignaturePanel.column.Name"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignaturePanel.column.TrafficCond"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignaturePanel.column.Application"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignaturePanel.column.Action"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignaturePanel.column.Track")};
    private JTable signaturesTable;
    private SortableTableModel tableModel;
    private IdsSignatureBlockObject blockObject;
    private Vector<IdsSignatureObject> idsSignatureObjects;
    private IdsPopupMenu popupMenu;
    private JButton addButton;
    private JButton deleteButton;
    private JButton editButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private Action addAction;
    private Action deleteAction;
    private Action editAction;
    private Action moveUpAction;
    private Action moveDownAction;
    private Action copyAction;
    private Action pasteAction;
    private JPanel centerPanel;
    private JPanel buttonPanel;
    private boolean isSystemLibrary = false;
    private boolean licensed = true;
    private boolean isReadOnly;

    public IdsSignaturePanel(boolean isSystemLibrary) {
        this.init();
        this.isSystemLibrary = isSystemLibrary;
        this.disableAllActions();
    }

    public void recoverButtonsEnableStatus(boolean isEnabled) {
        boolean bl = isEnabled = this.isReadOnly ? false : isEnabled;
        if (this.isSystemLibrary) {
            this.getAddAction().setEnabled(false);
            this.getDeleteAction().setEnabled(false);
        } else {
            this.getAddAction().setEnabled(this.licensed && isEnabled);
            this.getDeleteAction().setEnabled(this.blockObject != null && isEnabled && this.getSignaturesTable().getSelectedRow() != -1);
        }
        int rowCnt = this.getTableModel().getRowCount();
        int selectedRow = this.getSignaturesTable().getSelectedRow();
        this.getEditAction().setEnabled(this.blockObject != null && isEnabled && selectedRow != -1);
        this.getMoveUpAction().setEnabled(!this.isSystemLibrary && this.blockObject != null && isEnabled && rowCnt > 1 && selectedRow > 0);
        this.getMoveDownAction().setEnabled(!this.isSystemLibrary && this.blockObject != null && isEnabled && selectedRow > -1 && selectedRow < rowCnt - 1);
        this.getCopyAction().setEnabled(this.blockObject != null && isEnabled && selectedRow != -1);
        boolean hasCopy = PolicyHandler.hasCopiedObject(IdsSignatureObject.class);
        this.pasteAction.setEnabled(!this.isSystemLibrary && this.blockObject != null && isEnabled && hasCopy);
        this.synchronizeButtons();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    protected void itemPaste(ActionEvent parm1) {
        try {
            if (PolicyHandler.hasCopiedObject(IdsSignatureObject.class)) {
                IdsSignatureObject newObj = (IdsSignatureObject)PolicyHandler.getPastedObject();
                String name = MessageFormat.format(this.getRes("ItemPasteCopyOf"), newObj.getName());
                int i = 2;
                while (!this.blockObject.checkNewName(newObj, name)) {
                    name = MessageFormat.format(this.getRes("ItemPasteMultipleCopyOf"), Integer.toString(i), newObj.getName());
                    ++i;
                }
                newObj.setName(name);
                this.blockObject.addIdsSignatureObject(newObj);
                this.getTableModel().addRow(newObj);
                this.recoverButtonsEnableStatus(newObj.isEnabled());
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignaturePanel.title.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void disableAllActions() {
        this.getAddAction().setEnabled(false);
        this.getDeleteAction().setEnabled(false);
        this.getEditAction().setEnabled(false);
        this.getMoveUpAction().setEnabled(false);
        this.getMoveDownAction().setEnabled(false);
        this.getCopyAction().setEnabled(false);
        this.getPasteAction().setEnabled(false);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getCenterPanel(), "Center");
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new GridBagLayout());
            JScrollPane scroll = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)scroll, (JTable)this.getSignaturesTable());
            scroll.getViewport().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getModifiers() == 4) {
                        IdsSignaturePanel.this.getSignaturesTable().clearSelection();
                        IdsSignaturePanel.this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.centerPanel.add((Component)scroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.centerPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 5));
        }
        return this.centerPanel;
    }

    private JTable getSignaturesTable() {
        if (this.signaturesTable == null) {
            this.signaturesTable = new StripesTable();
            this.signaturesTable.setSelectionMode(0);
            this.signaturesTable.setAutoResizeMode(4);
            this.signaturesTable.setModel(this.getTableModel());
            this.signaturesTable.getColumnModel().getColumn(0).setPreferredWidth(60);
            this.signaturesTable.getColumnModel().getColumn(1).setPreferredWidth(95);
            this.signaturesTable.getColumnModel().getColumn(2).setPreferredWidth(92);
            this.signaturesTable.getColumnModel().getColumn(3).setPreferredWidth(90);
            this.signaturesTable.getColumnModel().getColumn(4).setPreferredWidth(60);
            this.signaturesTable.getColumnModel().getColumn(5).setPreferredWidth(70);
            this.signaturesTable.addMouseListener(this.getTableMouseListener());
            this.signaturesTable.getSelectionModel().addListSelectionListener(this.getListSelectionListener());
        }
        return this.signaturesTable;
    }

    private SortableTableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new SortableTableModel(){
                private static final long serialVersionUID = -2503923770555256804L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return column == 0;
                }
            };
            this.tableModel.setColumnNames(this.COLUMN_NAMES);
        }
        return this.tableModel;
    }

    private MouseListener getTableMouseListener() {
        MouseAdapter tableMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point p = e.getPoint();
                int row = IdsSignaturePanel.this.getSignaturesTable().rowAtPoint(p);
                if (row >= 0) {
                    IdsSignaturePanel.this.getSignaturesTable().getSelectionModel().setSelectionInterval(row, row);
                }
                if (IdsSignaturePanel.this.getSignaturesTable().isEnabled()) {
                    if (e.getModifiers() == 4) {
                        JPopupMenu popMenu = IdsSignaturePanel.this.getPopupMenu();
                        popMenu.show(e.getComponent(), e.getX(), e.getY());
                    } else if (e.getClickCount() == 2 && IdsSignaturePanel.this.getEditAction().isEnabled()) {
                        IdsSignaturePanel.this.editSignature();
                    }
                }
            }
        };
        return tableMouseListener;
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            Action[] actions = new Action[]{this.getAddAction(), this.getEditAction(), this.getDeleteAction(), this.getCopyAction(), this.getPasteAction(), this.getMoveUpAction(), this.getMoveDownAction()};
            this.popupMenu = new IdsPopupMenu(actions);
        }
        return this.popupMenu;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.getEditButton().setEnabled(false);
            this.getDeleteButton().setEnabled(false);
            this.getMoveUpButton().setEnabled(false);
            this.getMoveDownButton().setEnabled(false);
            UIUtilities.layoutButtonPanel(this.buttonPanel, new JButton[]{this.getAddButton(), this.getEditButton(), this.getDeleteButton(), this.getMoveUpButton(), this.getMoveDownButton()}, 0, 4, true);
        }
        return this.buttonPanel;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton(this.getAddAction());
            this.addButton.setEnabled(false);
        }
        return this.addButton;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton(this.getDeleteAction());
        }
        return this.deleteButton;
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton(this.getEditAction());
            this.editButton.setEnabled(false);
        }
        return this.editButton;
    }

    private JButton getMoveUpButton() {
        if (this.moveUpButton == null) {
            this.moveUpButton = new JButton(this.getMoveUpAction());
            this.moveUpButton.setEnabled(false);
        }
        return this.moveUpButton;
    }

    private JButton getMoveDownButton() {
        if (this.moveDownButton == null) {
            this.moveDownButton = new JButton(this.getMoveDownAction());
            this.moveDownButton.setEnabled(false);
        }
        return this.moveDownButton;
    }

    private Action getAddAction() {
        if (this.addAction == null) {
            this.addAction = new AbstractAction(UIText.get(5)){
                private static final long serialVersionUID = 8828841105571144345L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdsSignatureObject signObject = new IdsSignatureObject();
                    List<String> allName = IdsSignaturePanel.this.getAllName(null);
                    String newName = PolicyHandler.adjustName(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignaturePanel.Signature"), allName, 255);
                    signObject.setName(newName);
                    IdsSignatureDialog dialog = new IdsSignatureDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignaturePanel.title.AddSignature"), signObject, IdsSignaturePanel.this.isSystemLibrary, allName);
                    if (!dialog.isCancelled()) {
                        IdsSignaturePanel.this.blockObject.addIdsSignatureObject(signObject);
                        IdsSignaturePanel.this.getTableModel().addRow(signObject);
                        IdsSignaturePanel.this.recoverButtonsEnableStatus(signObject.isEnabled());
                    }
                }
            };
        }
        return this.addAction;
    }

    private Action getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new AbstractAction(UIText.get(769)){
                private static final long serialVersionUID = -395192739001133648L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = IdsSignaturePanel.this.getSignaturesTable().getSelectedRow();
                    if (index == -1) {
                        JOptionPane.showMessageDialog(IdsSignaturePanel.this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignaturePanel.error.SelectSigForDelete"));
                        return;
                    }
                    String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignaturePanel.ConfirmSigDelete");
                    int confirmOption = JOptionPane.showConfirmDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignaturePanel.title.Warning"), 0, 2);
                    if (confirmOption == 0) {
                        IdsSignatureObject idsSignObject = (IdsSignatureObject)IdsSignaturePanel.this.getTableModel().getRow(index);
                        IdsSignaturePanel.this.blockObject.deleteIdsSignatureObject(idsSignObject);
                        IdsSignaturePanel.this.getTableModel().removeRow(index);
                    }
                }
            };
        }
        return this.deleteAction;
    }

    private Action getEditAction() {
        if (this.editAction == null) {
            this.editAction = new AbstractAction(UIText.get(1024)){
                private static final long serialVersionUID = -8525043814715102225L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdsSignaturePanel.this.editSignature();
                }
            };
        }
        return this.editAction;
    }

    private void editSignature() {
        int index = this.getSignaturesTable().getSelectedRow();
        if (index == -1) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignaturePanel.error.SelectSigForEdit"));
            return;
        }
        IdsSignatureObject idsSignatureObject = (IdsSignatureObject)this.getTableModel().getRow(index);
        try {
            IdsSignatureObject idsSignatureObjectCopy = idsSignatureObject.getClone();
            IdsSignatureDialog dialog = new IdsSignatureDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignaturePanel.title.EditSig"), idsSignatureObjectCopy, this.isSystemLibrary, this.getAllName(idsSignatureObjectCopy.getName()));
            if (!dialog.isCancelled()) {
                this.getTableModel().setRow(index, idsSignatureObjectCopy);
                this.blockObject.setIdsSignatureObject(index, idsSignatureObjectCopy);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignaturePanel.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private List<String> getAllName(String curName) {
        ArrayList<String> allNames = new ArrayList<String>();
        if (this.blockObject != null) {
            Vector<IdsSignature> allSigs = this.blockObject.getIdsSignatures();
            for (IdsSignature sig : allSigs) {
                if (sig.getName().equals(curName)) continue;
                allNames.add(sig.getName());
            }
        }
        return allNames;
    }

    private Action getMoveUpAction() {
        if (this.moveUpAction == null) {
            this.moveUpAction = new AbstractAction(UIText.get(3075)){
                private static final long serialVersionUID = 3199970676050430669L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selectedRow = IdsSignaturePanel.this.getSignaturesTable().getSelectedRow();
                    if (selectedRow > 0) {
                        IdsSignaturePanel.this.getTableModel().moveRow(selectedRow, selectedRow, selectedRow - 1);
                        IdsSignaturePanel.this.getSignaturesTable().getSelectionModel().setSelectionInterval(selectedRow - 1, selectedRow - 1);
                        IdsSignaturePanel.this.blockObject.resetIdsSignatureObject(selectedRow, selectedRow - 1);
                    }
                }
            };
        }
        return this.moveUpAction;
    }

    private Action getMoveDownAction() {
        if (this.moveDownAction == null) {
            this.moveDownAction = new AbstractAction(UIText.get(3074)){
                private static final long serialVersionUID = 8438729026589071466L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rowCount;
                    int selectedRow = IdsSignaturePanel.this.getSignaturesTable().getSelectedRow();
                    if (selectedRow < (rowCount = IdsSignaturePanel.this.getTableModel().getRowCount()) - 1 && rowCount > 1) {
                        IdsSignaturePanel.this.getTableModel().moveRow(selectedRow, selectedRow, selectedRow + 1);
                        IdsSignaturePanel.this.getSignaturesTable().getSelectionModel().setSelectionInterval(selectedRow + 1, selectedRow + 1);
                        IdsSignaturePanel.this.blockObject.resetIdsSignatureObject(selectedRow, selectedRow + 1);
                    }
                }
            };
        }
        return this.moveDownAction;
    }

    private Action getCopyAction() {
        if (this.copyAction == null) {
            this.copyAction = new AbstractAction(UIText.get(520)){
                private static final long serialVersionUID = -8752142226759172636L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdsSignaturePanel.this.itemCopy(e);
                }
            };
        }
        return this.copyAction;
    }

    private Action getPasteAction() {
        if (this.pasteAction == null) {
            this.pasteAction = new AbstractAction(UIText.get(3840)){
                private static final long serialVersionUID = -2315482721171001588L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdsSignaturePanel.this.itemPaste(e);
                }
            };
        }
        return this.pasteAction;
    }

    private void itemCopy(ActionEvent parm1) {
        int index = this.getSignaturesTable().getSelectedRow();
        if (index == -1) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignaturePanel.error.SelectSigForEdit"));
            return;
        }
        IdsSignatureObject idsSignatureObject = (IdsSignatureObject)this.getTableModel().getRow(index);
        PolicyHandler.copyObject(idsSignatureObject);
        if (!this.isSystemLibrary && !this.pasteAction.isEnabled()) {
            this.pasteAction.setEnabled(true);
        }
    }

    private void setControls() {
        this.recoverButtonsEnableStatus(this.blockObject != null && this.blockObject.isEnabled());
        if (this.blockObject == null) {
            this.getTableModel().setDataVector(new Vector<TableRow>());
            this.getTableModel().fireTableDataChanged();
        }
    }

    private String getRes(String key) {
        String component = "IdsSignaturePanel.";
        return MSGRES.getString("com.sygate.scm.console.ui.policy.ids.ids", component + key);
    }

    private void synchronizeButtons() {
        this.getAddButton().setEnabled(this.getAddAction().isEnabled());
        this.getDeleteButton().setEnabled(this.getDeleteAction().isEnabled());
        this.getEditButton().setEnabled(this.getEditAction().isEnabled());
        this.getMoveUpButton().setEnabled(this.getMoveUpAction().isEnabled());
        this.getMoveDownButton().setEnabled(this.getMoveDownAction().isEnabled());
    }

    private void updatePanel() {
        if (this.blockObject != null) {
            Vector<IdsSignature> idsSignatures = this.blockObject.getIdsSignatures();
            this.idsSignatureObjects = new Vector();
            int count = idsSignatures.size();
            for (int i = 0; i < count; ++i) {
                IdsSignature idsSignature = idsSignatures.get(i);
                IdsSignatureObject sigObject = new IdsSignatureObject(idsSignature);
                this.idsSignatureObjects.add(sigObject);
            }
            this.getTableModel().setDataVector((Vector)Cast.cast(this.idsSignatureObjects));
            this.getTableModel().fireTableDataChanged();
        }
        this.setControls();
    }

    private ListSelectionListener getListSelectionListener() {
        ListSelectionListener tableSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    IdsSignaturePanel.this.setControls();
                }
            }
        };
        return tableSelectionListener;
    }

    public void setReadOnly() {
        this.isReadOnly = true;
        this.getSignaturesTable().setEnabled(false);
        this.disableAllActions();
    }

    public void setObject(IdsSignatureBlockObject bObj) {
        this.blockObject = bObj;
        LicenseObject licenseObj = LicenseObject.getInstance();
        this.licensed = licenseObj.isIntrusionPreventionEnabled();
        this.getAddAction().setEnabled(this.licensed);
        this.updatePanel();
    }
}

