/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.common.configobject.schema.FwIdsLibrary;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.ids.IdsPopupMenu;
import com.sygate.scm.console.ui.policy.ids.dialog.AddSignatureGroupDialog;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsSignatureBlockPanel;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsSignaturePanel;
import com.sygate.scm.console.ui.policy.ids.handler.IdsHandler;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsSignatureBlockObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IdsSignatureListPanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1192609730216853736L;
    private JList<IdsSignatureBlockObject> signatureBlockList;
    private JButton addButton;
    private JButton deleteButton;
    private JPanel buttonPanel;
    private DefaultListModel<IdsSignatureBlockObject> model;
    private Action addAction;
    private Action deleteAction;
    private IdsPopupMenu popupMenu;
    private boolean isSystemLibrary;
    private IdsLibraryObject idsLibraryObject;
    private IdsSignatureBlockObject curBlockObj;
    private IdsSignatureBlockPanel blockPanel;
    private IdsSignaturePanel signaturePanel;
    private boolean isDeleting = false;
    private boolean isReadOnly;

    public IdsSignatureListPanel(IdsLibraryObject idsLibraryObject, boolean isSystemLibrary) {
        this.idsLibraryObject = idsLibraryObject;
        this.isSystemLibrary = isSystemLibrary;
        this.init();
    }

    public void setReadOnly() {
        this.isReadOnly = true;
        this.getAddAction().setEnabled(false);
        this.getDeleteAction().setEnabled(false);
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureListPanel.label.SigGroups"), 2);
        this.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        JScrollPane scroll = new JScrollPane(this.getSignatureBlockList());
        scroll.setAutoscrolls(true);
        this.add((Component)scroll, new GridBagConstraints(0, 1, 1, 4, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    protected JList<IdsSignatureBlockObject> getSignatureBlockList() {
        if (this.signatureBlockList == null) {
            this.signatureBlockList = new JList();
            this.signatureBlockList.setSelectionMode(0);
            this.signatureBlockList.setModel(this.getListModel());
            this.signatureBlockList.addMouseListener(this.getListMouseListener());
            this.signatureBlockList.setCellRenderer(new CustomListCellRenderer());
        }
        return this.signatureBlockList;
    }

    private DefaultListModel<IdsSignatureBlockObject> getListModel() {
        if (this.model == null) {
            this.model = new DefaultListModel();
            FwIdsLibrary idsLibrary = this.idsLibraryObject.getFwIdsLibrary();
            ArrayList<IdsSignatureBlockObject> sigBlocks = IdsHandler.getIdsSignatureBlocks(idsLibrary);
            int count = sigBlocks.size();
            for (int i = 0; i < count; ++i) {
                this.model.addElement(sigBlocks.get(i));
            }
        }
        return this.model;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            JButton[] buttons = new JButton[]{this.getAddButton(), this.getDeleteButton()};
            this.getDeleteButton().setEnabled(false);
            this.buttonPanel = new JPanel();
            UIUtilities.layoutButtonPanel(this.buttonPanel, buttons, 0, 4, true);
        }
        return this.buttonPanel;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton(this.getAddAction());
        }
        return this.addButton;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton(this.getDeleteAction());
        }
        return this.deleteButton;
    }

    private Action getAddAction() {
        if (this.addAction == null) {
            this.addAction = new AbstractAction(UIText.get(5)){
                private static final long serialVersionUID = 4590261481883074022L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean validName;
                    if (IdsSignatureListPanel.this.blockPanel != null && !(validName = IdsSignatureListPanel.this.blockPanel.updateName())) {
                        return;
                    }
                    AddSignatureGroupDialog dialog = new AddSignatureGroupDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureListPanel.title.IntPrevSigGrp"), IdsSignatureListPanel.this.getSignatureGroupNames());
                    if (dialog.isOked()) {
                        IdsSignatureBlockObject newObj = dialog.getIdsSignatureBlock();
                        IdsSignatureListPanel.this.idsLibraryObject.addIdsSignatureBlockObject(newObj);
                        IdsSignatureListPanel.this.getListModel().addElement(newObj);
                        IdsSignatureListPanel.this.getSignatureBlockList().setSelectedValue(newObj, true);
                    }
                }
            };
        }
        this.addAction.setEnabled(!this.isSystemLibrary);
        return this.addAction;
    }

    private Action getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new AbstractAction(UIText.get(769)){
                private static final long serialVersionUID = -3095159695993604597L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdsSignatureListPanel.this.isDeleting = true;
                    int index = IdsSignatureListPanel.this.getSignatureBlockList().getSelectedIndex();
                    if (index < 0) {
                        JOptionPane.showMessageDialog(IdsSignatureListPanel.this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureListPanel.error.SelectSigGrpForDel"));
                        return;
                    }
                    String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureListPanel.ConfirmDelSigGrp");
                    int confirmOption = JOptionPane.showConfirmDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureListPanel.title.Warning"), 0, 2);
                    if (confirmOption == 0) {
                        IdsSignatureBlockObject idsSignBlockObject = IdsSignatureListPanel.this.getListModel().get(index);
                        IdsSignatureListPanel.this.idsLibraryObject.deleteIdsSignatureBlockObject(idsSignBlockObject);
                        IdsSignatureListPanel.this.getListModel().remove(index);
                        if (index >= IdsSignatureListPanel.this.getListModel().getSize()) {
                            index = IdsSignatureListPanel.this.getListModel().getSize() - 1;
                        }
                        IdsSignatureListPanel.this.getSignatureBlockList().setSelectedIndex(index);
                    }
                }
            };
        }
        this.deleteAction.setEnabled(!this.isSystemLibrary);
        return this.deleteAction;
    }

    private MouseListener getListMouseListener() {
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getModifiers() == 4 && !IdsSignatureListPanel.this.isReadOnly) {
                    IdsSignatureListPanel.this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        return listMouseListener;
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            Action[] actions = new Action[]{this.getAddAction(), this.getDeleteAction()};
            this.popupMenu = new IdsPopupMenu(actions);
        }
        return this.popupMenu;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.getSignatureBlockList().addListSelectionListener(listener);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            boolean okToGo;
            this.getDeleteButton().setEnabled(!this.isSystemLibrary && !this.isReadOnly);
            if (!this.isDeleting && this.curBlockObj != null && !(okToGo = this.blockPanel.updateName())) {
                int i;
                ListSelectionListener[] allListener = this.signatureBlockList.getListSelectionListeners();
                for (i = 0; i < allListener.length; ++i) {
                    this.signatureBlockList.removeListSelectionListener(allListener[i]);
                }
                this.signatureBlockList.setSelectedValue(this.curBlockObj, true);
                for (i = 0; i < allListener.length; ++i) {
                    this.signatureBlockList.addListSelectionListener(allListener[i]);
                }
                return;
            }
            this.curBlockObj = this.signatureBlockList.getSelectedValue();
            this.blockPanel.setObject(this.curBlockObj);
            this.signaturePanel.setObject(this.curBlockObj);
            this.isDeleting = false;
        }
    }

    private List<String> getSignatureGroupNames() {
        return this.idsLibraryObject.getGroupNameList();
    }

    public void setBlockPanel(IdsSignatureBlockPanel panel) {
        this.blockPanel = panel;
    }

    public void setRightPanels(IdsSignatureBlockPanel panel, IdsSignaturePanel panel2) {
        this.blockPanel = panel;
        this.signaturePanel = panel2;
    }

    public void selectDefaultRow() {
        int size = this.getListModel().getSize();
        if (size > 0) {
            this.getSignatureBlockList().setSelectedIndex(0);
        }
    }

    static class CustomListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -8673240126711635869L;
        private static ImageIcon osRuleIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("osrule.png")));

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setIcon(osRuleIcon);
            return this;
        }
    }
}

