/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.common.configobject.schema.IdsSignature;
import com.sygate.scm.common.configobject.schema.PacketProcess;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsApplicationsPanel;
import com.sygate.scm.console.ui.policy.ids.logicobject.ApplicationContainerObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsSignatureObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.util.BooleanWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class IdsSignatureDialog
extends DialogBase {
    private static final long serialVersionUID = 2833884900325516177L;
    private static final String[] SEVERITIES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.severity.Critical.0"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.severity.Critical.1"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.severity.Critical.2"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.severity.Critical.3"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.severity.Major.4"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.severity.Major.5"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.severity.Major.6"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.severity.Major.7"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.severity.Minor.8"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.severity.Minor.9"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.severity.Minor.10"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.severity.Minor.11"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.severity.Info.12"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.severity.Info.13"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.severity.Info.14"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.severity.Info.15")};
    private static final String[] LOG_EVENTS = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.Incoming"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.Outgoing"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.combo.Both")};
    private static final Integer[] LOG_VALUE = new Integer[]{IdsSignature.PASSIVE, IdsSignature.ACTIVE, IdsSignature.UNKNOWN};
    private JTextField nameTextField;
    private JTextArea descArea;
    private JComboBox<String> severityCombo;
    private JComboBox<String> logEventCombo;
    private JTextArea contentArea;
    private JRadioButton allowButton;
    private JRadioButton dropButton;
    private JCheckBox writeLogCheck;
    private JPanel mainPanel;
    private JPanel contentPanel;
    private JPanel actionPanel;
    private JPanel applicationsPanel;
    private IdsSignatureObject idsSignatureObject;
    private ApplicationContainerObject appContainerObject;
    private Integer action;
    private BooleanWrapper track;
    private Long severity;
    private Integer logEventAs;
    private boolean isSystemLibrary;
    private List<String> allNames;

    public IdsSignatureDialog(String title, IdsSignatureObject idsSignatureObject, boolean isSystemLibrary, List<String> allNames) {
        super(Manager.getFrame(), title, true);
        this.idsSignatureObject = idsSignatureObject;
        this.isSystemLibrary = isSystemLibrary;
        this.allNames = allNames;
        this.appContainerObject = idsSignatureObject.getApplicationContainer();
        this.init();
    }

    @Override
    protected boolean isValidate() {
        String name = this.getNameTextField().getText().trim();
        String content = this.contentArea.getText();
        boolean badName = false;
        if (name == null || name.trim().length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.error.NameRequired"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.title.InvalidName"), 0);
            badName = true;
        } else if (this.allNames != null && this.allNames.contains(name)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.error.NameExists"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.title.InvalidName"), 0);
            badName = true;
        }
        if (badName) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdsSignatureDialog.this.getNameTextField().requestFocus();
                }
            });
            return false;
        }
        if (content == null || content.trim().length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.error.ContentRequired"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.title.InvalidContent"), 0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdsSignatureDialog.this.contentArea.requestFocus();
                }
            });
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        this.updateValues();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_ids_custom_signature_add";
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.getMainPanel(), "Center");
        if (this.isSystemLibrary) {
            this.getNameTextField().setEditable(false);
            this.getDescTextArea().setEditable(false);
            this.contentArea.setEditable(false);
        }
        this.setValues();
        this.pack();
        this.getNameTextField().selectAll();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    private void setValues() {
        this.getNameTextField().setText(this.idsSignatureObject.getName());
        this.getDescTextArea().setText(this.idsSignatureObject.getDesc());
        this.contentArea.setText(this.idsSignatureObject.getTrafficCondition());
        this.severity = this.idsSignatureObject.getSeverity();
        if (this.severity != null) {
            int severityInt = this.severity.intValue();
            this.getSeverityCombo().setSelectedIndex(severityInt);
        }
        this.logEventAs = this.idsSignatureObject.getLogEventAs();
        if (this.logEventAs == null) {
            this.getLogeventCombo().setSelectedIndex(2);
        } else {
            int logEvent = 2;
            for (int i = 0; i < LOG_VALUE.length; ++i) {
                if (!LOG_VALUE[i].equals(this.logEventAs)) continue;
                logEvent = i;
                break;
            }
            this.getLogeventCombo().setSelectedIndex(logEvent);
        }
        this.track = this.idsSignatureObject.getTrack();
        if (this.track != null && !this.track.isNull()) {
            this.writeLogCheck.setSelected(this.track.booleanValue());
        } else {
            this.writeLogCheck.setSelected(true);
        }
        this.action = this.idsSignatureObject.getAction();
        if (this.action >= 0) {
            if (PacketProcess.DROP.equals(this.action)) {
                this.dropButton.setSelected(true);
            } else {
                this.allowButton.setSelected(true);
            }
        } else {
            this.dropButton.setSelected(true);
        }
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            JLabel nameLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.label.Name"));
            JLabel descLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.label.Desc"));
            JLabel sevLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.label.Severity"));
            JLabel logLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.label.Direction"));
            this.mainPanel.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.mainPanel.add((Component)this.getNameTextField(), new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.mainPanel.add((Component)descLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            JScrollPane scroll = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)scroll, (JTextArea)this.getDescTextArea());
            this.mainPanel.add((Component)scroll, new GridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.mainPanel.add((Component)sevLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.mainPanel.add(this.getSeverityCombo(), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.mainPanel.add((Component)logLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.mainPanel.add(this.getLogeventCombo(), new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.mainPanel.add((Component)this.getContentPanel(), new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 100));
            this.mainPanel.add((Component)this.getApplicationsPanel(), new GridBagConstraints(0, 4, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.mainPanel.add((Component)this.getActionPanel(), new GridBagConstraints(0, 5, 4, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.mainPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 6, 4, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        }
        return this.mainPanel;
    }

    private JTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new JTextField();
            RestrictedPlainDocument doc = new RestrictedPlainDocument(255);
            if (!this.isSystemLibrary) {
                doc.setValidator("/\\*?<>|\":", false);
            }
            this.nameTextField.setDocument(doc);
            this.nameTextField.setBounds(85, 10, 250, 20);
        }
        return this.nameTextField;
    }

    private JTextArea getDescTextArea() {
        if (this.descArea == null) {
            RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
            this.descArea = new JTextArea();
            this.descArea.setWrapStyleWord(true);
            this.descArea.setLineWrap(true);
            this.descArea.setRows(2);
            this.descArea.setDocument(doc);
        }
        return this.descArea;
    }

    private JComboBox<String> getSeverityCombo() {
        if (this.severityCombo == null) {
            this.severityCombo = new JComboBox();
            this.severityCombo.setModel(new DefaultComboBoxModel<String>(SEVERITIES));
        }
        return this.severityCombo;
    }

    private JComboBox<String> getLogeventCombo() {
        if (this.logEventCombo == null) {
            this.logEventCombo = new JComboBox();
            this.logEventCombo.setModel(new DefaultComboBoxModel<String>(LOG_EVENTS));
        }
        return this.logEventCombo;
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new BorderLayout());
            this.contentPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.title.Content")));
            this.contentArea = new JTextArea();
            RestrictedPlainDocument doc = new RestrictedPlainDocument(7234);
            this.contentArea.setDocument(doc);
            this.contentArea.setWrapStyleWord(true);
            this.contentArea.setLineWrap(true);
            JScrollPane scroll = new JScrollPane(this.contentArea);
            this.contentPanel.add((Component)scroll, "Center");
        }
        return this.contentPanel;
    }

    private JPanel getActionPanel() {
        if (this.actionPanel == null) {
            this.actionPanel = new JPanel();
            this.actionPanel.setLayout(new GridBagLayout());
            this.actionPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.title.Action")));
            this.allowButton = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.radio.Allow"));
            this.dropButton = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.radio.Drop"));
            ButtonGroup group = new ButtonGroup();
            group.add(this.dropButton);
            group.add(this.allowButton);
            this.writeLogCheck = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.checkbox.WriteToPacketLog"));
            this.actionPanel.add((Component)this.allowButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.actionPanel.add((Component)this.writeLogCheck, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            this.actionPanel.add((Component)this.dropButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        return this.actionPanel;
    }

    private JPanel getApplicationsPanel() {
        if (this.applicationsPanel == null) {
            this.applicationsPanel = new IdsApplicationsPanel(this.appContainerObject);
            this.applicationsPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureDialog.title.Applications")));
            this.applicationsPanel.setPreferredSize(new Dimension(400, 150));
        }
        return this.applicationsPanel;
    }

    private void updateValues() {
        this.idsSignatureObject.setName(this.getNameTextField().getText().trim());
        this.idsSignatureObject.setDesc(this.getDescTextArea().getText());
        if (this.allowButton.isSelected()) {
            this.idsSignatureObject.setAction(PacketProcess.PASS);
        } else {
            this.idsSignatureObject.setAction(PacketProcess.DROP);
        }
        int severityIndex = this.getSeverityCombo().getSelectedIndex();
        this.idsSignatureObject.setSeverty(Long.valueOf(severityIndex));
        this.idsSignatureObject.setTrafficCondition(this.contentArea.getText());
        this.idsSignatureObject.setTrack(this.writeLogCheck.isSelected());
        this.idsSignatureObject.setApplicationContainer();
        this.idsSignatureObject.setLogEventAs(LOG_VALUE[this.logEventCombo.getSelectedIndex()]);
    }

    public boolean isCancelled() {
        return !this.isOk;
    }
}

