/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsSignatureListPanel;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsSignaturePanel;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsSignatureBlockObject;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IdsSignatureBlockPanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 3142011884266986930L;
    private JTextField nameTextField;
    private JTextArea descArea;
    private JCheckBox enableCheck;
    private IdsSignatureBlockObject blockObject;
    private boolean isSystemLibrary;
    private boolean isReadOnly;
    private IdsSignaturePanel sigPanel;
    private IdsSignatureListPanel listPanel;

    public IdsSignatureBlockPanel(boolean isSystemLibrary, IdsSignaturePanel sigPanel, IdsSignatureListPanel listPanel) {
        this.isSystemLibrary = isSystemLibrary;
        this.sigPanel = sigPanel;
        this.listPanel = listPanel;
        this.init();
    }

    public boolean updateName() {
        if (this.blockObject == null) {
            return true;
        }
        if (this.isValidName()) {
            this.blockObject.setName(this.getNameTextField().getText().trim());
            return true;
        }
        return false;
    }

    private void init() {
        JLabel nameLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureBlockPanel.label.GroupName"));
        JLabel descLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureBlockPanel.label.Desc"));
        this.setLayout(new GridBagLayout());
        this.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.getNameTextField(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)descLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        JScrollPane scroll = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scroll, (JTextArea)this.getDescTextArea());
        this.add((Component)scroll, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.getEnableCheck(), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, -5, 0, 0), 0, 0));
    }

    private JTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new JTextField();
            this.nameTextField.setEditable(false);
            RestrictedPlainDocument doc = new RestrictedPlainDocument(255);
            doc.setValidator("/\\*?<>|\":", false);
            this.nameTextField.setDocument(doc);
            this.nameTextField.setEditable(this.isSystemLibrary);
        }
        return this.nameTextField;
    }

    private JTextArea getDescTextArea() {
        if (this.descArea == null) {
            RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
            this.descArea = new JTextArea();
            this.descArea.setEditable(false);
            this.descArea.setWrapStyleWord(true);
            this.descArea.setLineWrap(true);
            this.descArea.setRows(3);
            this.descArea.setDocument(doc);
            this.descArea.getDocument().addDocumentListener(this.getDescDocumentListener());
            this.descArea.setEditable(this.isSystemLibrary);
        }
        return this.descArea;
    }

    private JCheckBox getEnableCheck() {
        if (this.enableCheck == null) {
            this.enableCheck = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureBlockPanel.checkbox.EnableGrp"));
            this.enableCheck.setEnabled(false);
            this.enableCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (IdsSignatureBlockPanel.this.blockObject != null) {
                        IdsSignatureBlockPanel.this.blockObject.setEnabled(IdsSignatureBlockPanel.this.enableCheck.isSelected());
                    }
                    IdsSignatureBlockPanel.this.setControls();
                }
            });
        }
        return this.enableCheck;
    }

    private DocumentListener getDescDocumentListener() {
        DocumentListener descDocListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                IdsSignatureBlockPanel.this.updateDesc();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IdsSignatureBlockPanel.this.updateDesc();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                IdsSignatureBlockPanel.this.updateDesc();
            }
        };
        return descDocListener;
    }

    private void updateDesc() {
        if (this.blockObject != null) {
            this.blockObject.setDescription(this.getDescTextArea().getText());
        }
    }

    private boolean isValidName() {
        String name = this.getNameTextField().getText().trim();
        boolean isValid = true;
        if (name == null || name.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureBlockPanel.error.BlankName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureBlockPanel.title.InvalidName"), 0);
            isValid = false;
        } else {
            DefaultListModel model = (DefaultListModel)this.listPanel.getSignatureBlockList().getModel();
            Enumeration it = model.elements();
            while (it.hasMoreElements()) {
                IdsSignatureBlockObject bObj = (IdsSignatureBlockObject)it.nextElement();
                if (bObj == this.blockObject || !bObj.getName().equals(name)) continue;
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureBlockPanel.error.NameExisted"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsSignatureBlockPanel.title.InvalidName"), 0);
                isValid = false;
                break;
            }
        }
        if (!isValid) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdsSignatureBlockPanel.this.getNameTextField().requestFocus();
                }
            });
        }
        return isValid;
    }

    private void setControls() {
        if (this.blockObject == null) {
            this.getNameTextField().setText("");
            this.getDescTextArea().setText("");
        }
        this.getDescTextArea().setEditable(!this.isSystemLibrary && this.blockObject != null && this.blockObject.isEnabled() && !this.isReadOnly);
        this.getEnableCheck().setEnabled(this.blockObject != null && !this.isReadOnly);
        this.getNameTextField().setEditable(!this.isSystemLibrary && this.blockObject != null && this.blockObject.isEnabled() && !this.isReadOnly);
        UIUtilities.setContainerStatus(this.sigPanel, this.blockObject != null && this.blockObject.isEnabled() && this.getEnableCheck().isEnabled());
        this.sigPanel.recoverButtonsEnableStatus(this.blockObject == null ? false : this.blockObject.isEnabled());
    }

    private void updatePanel() {
        if (this.blockObject != null) {
            this.getNameTextField().setText(this.blockObject.getName());
            this.getDescTextArea().setText(this.blockObject.getDescription());
            this.getEnableCheck().setSelected(this.blockObject.isEnabled());
        }
        this.setControls();
    }

    public void setReadOnly() {
        this.isReadOnly = true;
        this.getNameTextField().setEnabled(false);
        this.getDescTextArea().setEnabled(false);
        this.getEnableCheck().setEnabled(false);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    public void setObject(IdsSignatureBlockObject bObj) {
        this.blockObject = bObj;
        this.updatePanel();
    }
}

