/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.BrowserProtection;
import com.sygate.scm.common.configobject.schema.FwHostContainer;
import com.sygate.scm.common.configobject.schema.FwIDS;
import com.sygate.scm.common.configobject.schema.FwUnregulatedHosts;
import com.sygate.scm.common.configobject.schema.IdsPolicy;
import com.sygate.scm.common.configobject.schema.Reputation;
import com.sygate.scm.common.configobject.schema.ServerPerformanceTuning;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.av.common.AvConstants;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.firewall.dialog.HostGroupDialog;
import com.sygate.scm.console.ui.util.LockCheckBox;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class IdsSettingsPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 2292255264874006292L;
    private static final String IDS_DESC = IdsSettingsPanel.getString("IdsSettingsPanel.IDSDescription");
    private final LockCheckBox lockEnableIDSChk = new LockCheckBox(Boolean.FALSE);
    private final JCheckBox jCbxIDS = new JCheckBox(IdsSettingsPanel.getString("IdsSettingsPanel.checkbox.EnableIDS"));
    private final LockCheckBox lockEnableReputationChk = new LockCheckBox(Boolean.FALSE);
    private final JCheckBox jCbxReputation = new JCheckBox(IdsSettingsPanel.getString("IdsSettingsPanel.checkbox.EnableURLReputation"));
    private final LockCheckBox lockEnableBPChk = new LockCheckBox(Boolean.FALSE);
    private final JCheckBox jCbxBPT = new JCheckBox(IdsSettingsPanel.getString("IdsSettingsPanel.checkbox.EnableBrowserProtection"));
    private final JCheckBox jCbxIDSBrowserLogOnly = new JCheckBox(IdsSettingsPanel.getString("IdsSettingsPanel.checkbox.EnablLogOnlyMode"));
    private final JCheckBox jCbxIDSBrowser3rdPartyManage = new JCheckBox(IdsSettingsPanel.getString("IdsSettingsPanel.checkbox.Enable3rdPartyManage"));
    private final JCheckBox jCbxExclusiveHosts = new JCheckBox(IdsSettingsPanel.getString("IdsSettingsPanel.checkbox.EnableExcludedHosts"));
    private final JButton jBExclusiveHosts = new JButton(IdsSettingsPanel.getString("IdsSettingsPanel.button.ExcludedHosts"));
    private final JCheckBox jCbxOutOfBand = new JCheckBox(IdsSettingsPanel.getString("IdsSettingsPanel.checkbox.outOfBandScanning"));
    private final JCheckBox jCbxServerSignature = new JCheckBox(IdsSettingsPanel.getString("IdsSettingsPanel.checkbox.serverSignatureSet"));
    private FwIDS fwIDS;
    private Reputation reputation;
    private BrowserProtection browserProtection;
    private FwUnregulatedHosts fwUnregulatedHosts;
    private IdsPolicy idsPolicy;

    public IdsSettingsPanel() {
        this.initialize();
    }

    public void updateIdsPolicys() {
        if (this.fwIDS == null) {
            this.fwIDS = new FwIDS();
            this.fwIDS.setOptLockFwIDSOptions(Boolean.FALSE);
            this.fwIDS.setOptEnable(Boolean.TRUE);
            this.idsPolicy.setOptFwIDS(this.fwIDS);
        }
        if (this.lockEnableIDSChk.isSelected()) {
            this.fwIDS.setOptLockFwIDSOptions(Boolean.TRUE);
        } else {
            this.fwIDS.setOptLockFwIDSOptions(Boolean.FALSE);
        }
        if (this.jCbxIDS.isSelected()) {
            this.fwIDS.setOptEnable(Boolean.TRUE);
        } else {
            this.fwIDS.setOptEnable(Boolean.FALSE);
        }
        if (this.reputation == null) {
            this.reputation = new Reputation();
            this.idsPolicy.setOptReputation(this.reputation);
        }
        this.reputation.setOptEnable(Boolean.valueOf(this.jCbxReputation.isSelected()));
        this.reputation.setOptLockReputationOption(Boolean.valueOf(this.lockEnableReputationChk.isSelected()));
        if (this.browserProtection == null) {
            this.browserProtection = new BrowserProtection();
            this.browserProtection.setOptLockBrowserProtectionOption(this.browserProtection.getDefLockBrowserProtectionOption());
            this.browserProtection.setOptEnable(this.browserProtection.getDefEnable());
            this.idsPolicy.setOptBrowserProtection(this.browserProtection);
        }
        if (this.lockEnableBPChk.isSelected()) {
            this.browserProtection.setOptLockBrowserProtectionOption(Boolean.TRUE);
        } else {
            this.browserProtection.setOptLockBrowserProtectionOption(Boolean.FALSE);
        }
        if (this.jCbxBPT.isSelected()) {
            this.browserProtection.setOptEnable(Boolean.TRUE);
        } else {
            this.browserProtection.setOptEnable(Boolean.FALSE);
        }
        this.browserProtection.setOptLogOnly(Boolean.valueOf(this.jCbxIDSBrowserLogOnly.isSelected()));
        this.browserProtection.setOptEnableThirdPartyManagement(Boolean.valueOf(this.jCbxIDSBrowser3rdPartyManage.isSelected()));
        if (this.fwUnregulatedHosts == null) {
            this.fwUnregulatedHosts = new FwUnregulatedHosts();
            this.fwUnregulatedHosts.setOptEnable(Boolean.TRUE);
            this.idsPolicy.setOptFwUnregulatedHosts(this.fwUnregulatedHosts);
        }
        this.fwUnregulatedHosts.setOptEnable(Boolean.valueOf(this.jCbxExclusiveHosts.isSelected()));
        ServerPerformanceTuning serverPerformanceTuning = this.idsPolicy.getOptServerPerformanceTuning();
        if (serverPerformanceTuning == null) {
            serverPerformanceTuning = new ServerPerformanceTuning();
        }
        serverPerformanceTuning.setOptEnableOutOfBandScanning(Boolean.valueOf(this.jCbxOutOfBand.isSelected()));
        serverPerformanceTuning.setOptEnableServerOptimizedSignatures(Boolean.valueOf(this.jCbxServerSignature.isSelected()));
        this.idsPolicy.setOptServerPerformanceTuning(serverPerformanceTuning);
    }

    protected void setReputationEnabled() {
        boolean enable = this.jCbxIDS.isSelected() || this.jCbxBPT.isSelected();
        this.lockEnableReputationChk.setEnabled(enable);
        this.jCbxReputation.setEnabled(enable);
    }

    protected void setIPSLogOnlyEnabled() {
        this.jCbxIDSBrowserLogOnly.setEnabled(this.jCbxBPT.isSelected());
    }

    protected void setIPS3rdPartyManageEnabled() {
        this.jCbxIDSBrowser3rdPartyManage.setEnabled(this.jCbxBPT.isSelected());
    }

    protected void setOutOfBandEnabled() {
        this.jCbxOutOfBand.setEnabled(this.jCbxIDS.isSelected());
    }

    protected void setServerSignatureEnabled() {
        this.jCbxServerSignature.setEnabled(this.jCbxIDS.isSelected() || this.jCbxBPT.isSelected());
    }

    protected void showWarning() {
        if (!this.jCbxBPT.isSelected() && UIUtilities.showWarningYesNoOptionDialog(IdsSettingsPanel.getString("IdsSettingsPanel.warning.browserProtectionDisabled")) == 1) {
            this.jCbxBPT.setSelected(true);
        }
    }

    protected void setExclusiveHostCbxEnabled() {
        this.jCbxExclusiveHosts.setEnabled(this.jCbxIDS.isSelected());
        this.setExclusiveHostBtnEnabled();
    }

    protected void setExclusiveHostBtnEnabled() {
        this.jBExclusiveHosts.setEnabled(this.jCbxExclusiveHosts.isEnabled() && this.jCbxExclusiveHosts.isSelected());
    }

    protected void showExclusiveHosts() {
        try {
            FwUnregulatedHosts newHosts;
            FwHostContainer hostContainer;
            if (this.fwUnregulatedHosts == null) {
                this.fwUnregulatedHosts = new FwUnregulatedHosts();
                this.fwUnregulatedHosts.setOptEnable(Boolean.TRUE);
                this.idsPolicy.setOptFwUnregulatedHosts(this.fwUnregulatedHosts);
            }
            if ((hostContainer = (newHosts = (FwUnregulatedHosts)PolicyHandler.getCopyOfObj((ConfigObject)this.fwUnregulatedHosts)).getOptFwHostContainer()) == null) {
                hostContainer = new FwHostContainer();
                newHosts.setOptFwHostContainer(hostContainer);
            }
            HostGroupDialog hDialog = new HostGroupDialog((JFrame)Manager.getFrame(), IdsSettingsPanel.getString("IdsSettingsPanel.title.ExcludedHosts"), true, newHosts);
            hDialog.setVisible(true);
            if (hDialog.isOk()) {
                this.fwUnregulatedHosts = hDialog.getUnregulatedHosts();
                this.idsPolicy.setOptFwUnregulatedHosts(this.fwUnregulatedHosts);
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), IdsSettingsPanel.getString("IdsSettingsPanel.title.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    public void setObject(IdsPolicy idsPolicy) {
        this.idsPolicy = idsPolicy;
        this.fwIDS = idsPolicy.getOptFwIDS();
        this.setupReputationObject(idsPolicy);
        this.setIdsObject();
        this.setBrowserProtectionObject(idsPolicy);
        ServerPerformanceTuning serverPerformanceTuning = idsPolicy.getOptServerPerformanceTuning();
        if (serverPerformanceTuning != null) {
            this.jCbxOutOfBand.setSelected(Optional.ofNullable(serverPerformanceTuning.getOptEnableOutOfBandScanning()).orElse(serverPerformanceTuning.getDefEnableOutOfBandScanning()));
            this.jCbxServerSignature.setSelected(Optional.ofNullable(serverPerformanceTuning.getOptEnableServerOptimizedSignatures()).orElse(serverPerformanceTuning.getDefEnableServerOptimizedSignatures()));
        }
        this.fwUnregulatedHosts = idsPolicy.getOptFwUnregulatedHosts();
        this.jCbxExclusiveHosts.setSelected(this.fwUnregulatedHosts != null && !Boolean.FALSE.equals(this.fwUnregulatedHosts.getOptEnable()));
        this.setExclusiveHostCbxEnabled();
        this.setIPSLogOnlyEnabled();
        this.setIPS3rdPartyManageEnabled();
        this.setReputationEnabled();
        this.setOutOfBandEnabled();
        this.setServerSignatureEnabled();
    }

    private void setBrowserProtectionObject(IdsPolicy idsPolicy) {
        this.browserProtection = idsPolicy.getOptBrowserProtection();
        if (this.browserProtection == null) {
            this.browserProtection = new BrowserProtection();
            idsPolicy.setOptBrowserProtection(this.browserProtection);
        }
        this.jCbxBPT.setSelected(Optional.ofNullable(this.browserProtection.getOptEnable()).orElse(this.browserProtection.getDefEnable()));
        this.lockEnableBPChk.setSelected(Optional.ofNullable(this.browserProtection.getOptLockBrowserProtectionOption()).orElse(this.browserProtection.getDefLockBrowserProtectionOption()));
        this.jCbxIDSBrowserLogOnly.setSelected(Optional.ofNullable(this.browserProtection.getOptLogOnly()).orElse(this.browserProtection.getDefLogOnly()));
        this.jCbxIDSBrowser3rdPartyManage.setSelected(Optional.ofNullable(this.browserProtection.getOptEnableThirdPartyManagement()).orElse(this.browserProtection.getDefEnableThirdPartyManagement()));
    }

    private void setIdsObject() {
        boolean lockIds = false;
        boolean enableIds = false;
        if (this.fwIDS != null) {
            lockIds = Optional.ofNullable(this.fwIDS.getOptLockFwIDSOptions()).orElse(this.fwIDS.getDefLockFwIDSOptions());
            enableIds = Optional.ofNullable(this.fwIDS.getOptEnable()).orElse(this.fwIDS.getDefEnable());
        }
        this.lockEnableIDSChk.setSelected(lockIds);
        this.jCbxIDS.setSelected(enableIds);
        LicenseObject licenseObj = LicenseObject.getInstance();
        if (!enableIds && !licenseObj.isIntrusionPreventionEnabled()) {
            this.lockEnableIDSChk.setVisible(false);
            this.jCbxIDS.setVisible(false);
        } else {
            this.lockEnableIDSChk.setVisible(true);
            this.jCbxIDS.setVisible(true);
        }
    }

    private void setupReputationObject(IdsPolicy idsPolicy) {
        this.reputation = idsPolicy.getOptReputation();
        if (this.reputation == null) {
            this.reputation = new Reputation();
            idsPolicy.setOptReputation(this.reputation);
        }
        this.jCbxReputation.setSelected(this.reputation.getOptEnable() != null && this.reputation.getOptEnable() != false);
        this.lockEnableReputationChk.setSelected(Optional.ofNullable(this.reputation.getOptLockReputationOption()).orElse(this.reputation.getDefLockReputationOption()));
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 5));
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new AvTemplatePane(IdsSettingsPanel.getString("IdsSettingsPanel.title.intrusionProtection"), IDS_DESC, false), new GridBagConstraints(0, gridy, 5, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.lockEnableIDSChk.setSelectedIcon(AvConstants.lockIcon);
        panel.add((Component)this.lockEnableIDSChk, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)this.jCbxIDS, new GridBagConstraints(1, gridy, 5, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.jCbxIDS.addActionListener(e -> this.setExclusiveHostCbxEnabled());
        this.jCbxIDS.addActionListener(e -> this.setReputationEnabled());
        this.jCbxIDS.addActionListener(e -> this.setOutOfBandEnabled());
        this.jCbxIDS.addActionListener(e -> this.setServerSignatureEnabled());
        panel.add((Component)this.jCbxExclusiveHosts, new GridBagConstraints(1, ++gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        panel.add((Component)this.jBExclusiveHosts, new GridBagConstraints(2, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jCbxExclusiveHosts.addActionListener(e -> this.setExclusiveHostBtnEnabled());
        this.jBExclusiveHosts.addActionListener(e -> this.showExclusiveHosts());
        this.lockEnableBPChk.setSelectedIcon(AvConstants.lockIcon);
        panel.add((Component)this.lockEnableBPChk, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)this.jCbxBPT, new GridBagConstraints(1, gridy, 5, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.jCbxBPT.addActionListener(e -> this.setReputationEnabled());
        this.jCbxBPT.addActionListener(e -> this.setIPSLogOnlyEnabled());
        this.jCbxBPT.addActionListener(e -> this.setIPS3rdPartyManageEnabled());
        this.jCbxBPT.addActionListener(e -> this.setServerSignatureEnabled());
        this.jCbxBPT.addActionListener(e -> this.showWarning());
        panel.add((Component)this.jCbxIDSBrowserLogOnly, new GridBagConstraints(1, ++gridy, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        panel.add((Component)this.jCbxIDSBrowser3rdPartyManage, new GridBagConstraints(1, ++gridy, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        this.lockEnableReputationChk.setSelectedIcon(AvConstants.lockIcon);
        panel.add((Component)this.lockEnableReputationChk, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)this.jCbxReputation, new GridBagConstraints(1, gridy, 5, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        if (!ScmProperties.isStarPulseFeatureEnabled()) {
            this.lockEnableReputationChk.setVisible(false);
            this.jCbxReputation.setVisible(false);
        }
        ++gridy;
        panel.add((Component)new AvTemplatePane(IdsSettingsPanel.getString("IdsSettingsPanel.title.serverPerformance"), IdsSettingsPanel.getString("IdsSettingsPanel.serverPerformanceDesc"), false), new GridBagConstraints(0, ++gridy, 5, 1, 1.0, 0.0, 17, 2, new Insets(50, 0, 0, 0), 0, 0));
        if (ScmProperties.isIpsOobFeatureEnabled()) {
            panel.add((Component)this.jCbxOutOfBand, new GridBagConstraints(1, ++gridy, 5, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
            JTextArea lbl = new JTextArea(IdsSettingsPanel.getString("IdsSettingsPanel.label.oobcompatibilitymsg"));
            lbl.setEditable(false);
            panel.add((Component)lbl, new GridBagConstraints(1, ++gridy, 5, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        }
        panel.add((Component)this.jCbxServerSignature, new GridBagConstraints(1, ++gridy, 5, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        return panel;
    }

    private static String getString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", key);
    }

    public void setReadOnly() {
        this.lockEnableIDSChk.setEnabled(false);
        this.jCbxIDS.setEnabled(false);
        this.lockEnableBPChk.setEnabled(false);
        this.jCbxBPT.setEnabled(false);
        this.jCbxIDSBrowserLogOnly.setEnabled(false);
        this.jCbxIDSBrowser3rdPartyManage.setEnabled(false);
        this.jCbxExclusiveHosts.setEnabled(false);
        this.jCbxServerSignature.setEnabled(false);
        this.jCbxOutOfBand.setEnabled(false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_ids_settings";
    }
}

