/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.ExceptionEvent;
import com.sygate.scm.common.configobject.schema.ExceptionList;
import com.sygate.scm.common.configobject.schema.IdsPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.PolicyHelper;
import com.sygate.scm.console.ui.policy.PolicyTabPanel;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsExceptionPanel;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsPolicyTabPanel;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsSettingsPanel;
import com.sygate.scm.console.ui.policy.ids.dialog.MacIpsExceptionPanel;
import com.sygate.scm.console.ui.policy.ids.handler.IdsCategoryHelper;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsPolicyObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class IdsPolicyDialog
extends BasePolicyDialog {
    private static final long serialVersionUID = 4424032030719725955L;
    private IdsExceptionPanel exceptionPanel;
    private IdsSettingsPanel settingsPanel;
    private MacIpsExceptionPanel macExceptionPanel;
    private Map<String, TopLevelObject> newObjList = new HashMap<String, TopLevelObject>();
    IdsPolicyObject idsPolicyObject;

    public IdsPolicyDialog(String name, GroupPolicyObject gpObj, Boolean ... isLocal) {
        super(143, name, gpObj, IdsPolicyDialog.getString("IdsPolicyDialog.title"), true, isLocal);
    }

    public IdsPolicyDialog(String name, GroupPolicyObject gpObj) {
        super(143, name, gpObj, IdsPolicyDialog.getString("IdsPolicyDialog.title"), true, new Boolean[0]);
    }

    public IdsPolicyDialog(AbstractUIObject pool) {
        this(pool, false);
    }

    public IdsPolicyDialog(AbstractUIObject pool, boolean isCheckPolicyEnforcement) {
        super(143, pool, IdsPolicyDialog.getString("IdsPolicyDialog.title"), isCheckPolicyEnforcement, true);
    }

    @Override
    protected boolean isValidate() {
        boolean isResult = this.isValidName(this.idsPolicyObject.getSchemaObj(), IdsPolicyDialog.getString("IdsPolicyDialog.nameIsARequirementFiled"), IdsPolicyDialog.getString("IdsPolicyDialog.theNameHasBeenUsed"), IdsPolicyDialog.getString("IdsPolicyDialog.invalidName"));
        if (!isResult) {
            return isResult;
        }
        ArrayList<String> invalidEvents = new ArrayList<String>();
        IdsPolicy idsPolicy = (IdsPolicy)this.idsPolicyObject.getSchemaObj();
        invalidEvents.addAll(this.getInvalidBrowserProtectionExceptions(idsPolicy));
        if (invalidEvents.size() > 0) {
            isResult = false;
            Collections.sort(invalidEvents);
            String eventIds = StringUtilities.getCSV(invalidEvents, (int)10);
            String msg = MessageFormat.format(IdsPolicyDialog.getString("IdsPolicyDialog.InvalidBPExceptions"), eventIds);
            int dlgResult = UIUtilities.confirmYesNoOptionDialog(msg, IdsPolicyDialog.getString("IdsPolicyDialog.Error"));
            if (dlgResult == 0) {
                this.deleteExceptionsFromPolicy(idsPolicy, invalidEvents);
                isResult = true;
            }
        }
        return isResult;
    }

    private Set<String> getInvalidBrowserProtectionExceptions(IdsPolicy idsPolicy) {
        HashSet<String> invalidEvents = new HashSet<String>();
        if (idsPolicy != null && idsPolicy.getOptExceptionList() != null) {
            ExceptionList exceptionList = idsPolicy.getOptExceptionList();
            Vector allExceptions = exceptionList.getExceptionEvent();
            for (ExceptionEvent event : allExceptions) {
                if (!IdsCategoryHelper.isBrowserProtectionSigInvalidAction(event)) continue;
                invalidEvents.add(event.getEventId());
            }
        }
        return invalidEvents;
    }

    private void deleteExceptionsFromPolicy(IdsPolicy idsPolicy, List<String> eventsToDelete) {
        if (eventsToDelete == null || eventsToDelete.size() == 0) {
            return;
        }
        if (idsPolicy != null && idsPolicy.getOptExceptionList() != null) {
            ExceptionList exceptionList = idsPolicy.getOptExceptionList();
            Vector allExceptions = exceptionList.getExceptionEvent();
            for (ExceptionEvent event : allExceptions) {
                if (!eventsToDelete.contains(event.getEventId())) continue;
                exceptionList.removeExceptionEvent(event);
            }
        }
    }

    @Override
    protected void commit() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.idsPolicyObject.setName(this.getOverviewPanel().getPolicyName());
        this.idsPolicyObject.setDesc(this.getOverviewPanel().getPolicyDesc());
        this.idsPolicyObject.setEnabled(this.getOverviewPanel().isPolicyEnabled());
        this.settingsPanel.updateIdsPolicys();
        this.setCursor(Cursor.getDefaultCursor());
        if (LicenseObject.getInstance().isSBProduct()) {
            PolicyHelper.refreshSerialNumber();
        }
    }

    @Override
    protected PolicyTabPanel createTabPanel() {
        IdsPolicyTabPanel panel = new IdsPolicyTabPanel(this, "<html>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsPolicyDialog.IdsPolicy") + "</html>", "ids_policy_32.png");
        return panel;
    }

    @Override
    protected Container[] readOnlyContainers() {
        return new Container[]{this.getOverviewPanel(), this.getExceptionPanel(), this.getSettingsPanel(), this.getMacExceptionPanel()};
    }

    @Override
    public PolicyInt createNewPolicy(AppliablePolicyPool pool) {
        String newName;
        this.setNewPolicy(true);
        IdsPolicy policy = this.createIdsPolicy();
        this.idsPolicyObject = new IdsPolicyObject(policy);
        if (this.idsPolicyObject.getName() != null && (newName = PolicyHandler.adjustName(this.idsPolicyObject.getName(), pool.getAllName(), 255)) != null) {
            this.idsPolicyObject.setName(newName);
        }
        this.idsPolicyObject.addNewObj((TopLevelObject)policy);
        this.idsPolicyObject.addNewObj(this.newObjList);
        this.newObjList.clear();
        this.setValue();
        return this.idsPolicyObject;
    }

    @Override
    public PolicyInt createNewPolicy(TopLevelObject schema) {
        IdsPolicy policy = (IdsPolicy)schema;
        this.idsPolicyObject = new IdsPolicyObject(policy);
        this.setValue();
        return this.idsPolicyObject;
    }

    private IdsPolicy createIdsPolicy() {
        IdsPolicy idsPolicy = null;
        try {
            idsPolicy = (IdsPolicy)PolicyHandler.getDefaultIdsPolicy(this.newObjList);
            if (idsPolicy == null) {
                idsPolicy = new IdsPolicy();
                String GUIDString = new GUIDGenerator().getGUIDString();
                idsPolicy.setId(GUIDString);
                MetadataAttributes mAttr = new MetadataAttributes();
                idsPolicy.setMetadataAttributes(mAttr);
                idsPolicy.setOptCreator(AdminObject.retrieveCurrentAdminObject().getName());
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), IdsPolicyDialog.getString("IdsPolicyDialog.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return idsPolicy;
    }

    @Override
    protected void addPolicyEditorPanels(JPanel mainPanel) {
        super.addPolicyEditorPanels(mainPanel);
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getSettingsPanel()), IdsPolicyDialog.getString("IdsPolicyDialog.Settings"));
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getExceptionPanel()), "Windows Exceptions");
        mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getMacExceptionPanel()), "Mac Exceptions");
    }

    public void setObject(IdsPolicyObject idsPolicyObj) {
        this.idsPolicyObject = idsPolicyObj;
        this.setValue();
    }

    private void setValue() {
        block2: {
            try {
                this.getOverviewPanel().setObject(this.idsPolicyObject);
                this.getExceptionPanel().setObject(this.idsPolicyObject);
                this.getSettingsPanel().setObject(this.idsPolicyObject.getIdsPolicy());
                this.getOverviewPanel().setPolicyEnabled(this.idsPolicyObject.getEnabled());
                this.getMacExceptionPanel().setObject(this.idsPolicyObject);
            }
            catch (ConsoleException e) {
                LoggerUtilities.logException((Throwable)e);
                JOptionPane.showMessageDialog(Manager.getFrame(), IdsPolicyDialog.getString("IdsPolicyDialog.Cannot_Load_Data"));
                if (!e.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private IdsExceptionPanel getExceptionPanel() {
        if (this.exceptionPanel == null) {
            this.exceptionPanel = new IdsExceptionPanel();
        }
        return this.exceptionPanel;
    }

    private MacIpsExceptionPanel getMacExceptionPanel() {
        if (this.macExceptionPanel == null) {
            this.macExceptionPanel = new MacIpsExceptionPanel();
        }
        return this.macExceptionPanel;
    }

    private IdsSettingsPanel getSettingsPanel() {
        if (this.settingsPanel == null) {
            this.settingsPanel = new IdsSettingsPanel();
        }
        return this.settingsPanel;
    }

    private static String getString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", key);
    }
}

