/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsSignatureBlockPanel;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsSignatureListPanel;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsSignaturePanel;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsVariablePanel;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryPoolObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class IdsEditor
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private IdsLibraryObject idsLibraryObject;
    private IdsSignatureListPanel listPanel;
    private IdsSignatureBlockPanel sigBlockPanel;
    private IdsSignaturePanel signaturesPanel;
    private IdsVariablePanel variablePanel;
    private JTabbedPane tabbedPane;
    private JPanel topPanel;
    private JPanel centerPanel;
    private JPanel sigMainPanel;
    private JSplitPane splitPane = new JSplitPane();
    private JTextField nameTextField;
    private JTextArea descArea;
    private JTextField serialNumberTextField;
    private boolean isCancelled = true;
    private boolean isSystemLibrary = false;
    private String oldName;

    public IdsEditor(IdsLibraryObject idsLibraryObject, String oldName) {
        this(idsLibraryObject, oldName, false);
    }

    public IdsEditor(IdsLibraryObject idsLibraryObject, String oldName, boolean isCheckPolicyEnforcement) {
        super(Manager.getFrame(), "", true);
        this.setTitle(this.createTitle(isCheckPolicyEnforcement));
        this.idsLibraryObject = idsLibraryObject;
        this.oldName = oldName;
        this.init(isCheckPolicyEnforcement);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    private void init(boolean isCheckPolicyEnforcement) {
        this.setPreferredSize(new Dimension(725, 580));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getTopPanel(), "North");
        this.getContentPane().add((Component)this.getCenterPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setValues();
        this.pack();
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (isCheckPolicyEnforcement && AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            this.setReadOnly();
        }
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new BorderLayout());
            JPanel p = new JPanel(new GridBagLayout());
            JLabel nameLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsEditor.label.Name"));
            JLabel serialLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsEditor.label.Version"));
            JLabel descLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsEditor.label.Desc"));
            p.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            p.add((Component)this.getNameTextField(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
            p.add((Component)serialLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
            p.add((Component)this.getSerialNumberTextField(), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 200, 0));
            p.add((Component)descLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
            JScrollPane scrollPane = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTextArea)this.getDescTextArea());
            p.add((Component)scrollPane, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 1, new Insets(5, 0, 10, 5), 0, 0));
            if (!this.isSystemLibrary) {
                serialLabel.setVisible(false);
                this.getSerialNumberTextField().setVisible(false);
            }
            this.topPanel.add((Component)p, "Center");
        }
        return this.topPanel;
    }

    private void setValues() {
        this.getNameTextField().setText(this.idsLibraryObject.getName());
        this.getDescTextArea().setText(this.idsLibraryObject.getDescription());
        this.getSerialNumberTextField().setText(this.idsLibraryObject.getSerialNumber());
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BorderLayout());
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.add((Component)this.getSigMainPanel(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsEditor.title.Signature"));
            this.tabbedPane.add((Component)this.getVariablePanel(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsEditor.title.Variable"));
            this.centerPanel.add((Component)this.tabbedPane, "Center");
        }
        return this.centerPanel;
    }

    private JPanel getSigMainPanel() {
        if (this.sigMainPanel == null) {
            this.sigMainPanel = new JPanel();
            this.sigMainPanel.setLayout(new BorderLayout());
            this.sigMainPanel.add((Component)this.splitPane, "Center");
            this.splitPane.setLeftComponent(this.getListPanel());
            JPanel rightPanel = new JPanel();
            rightPanel.setLayout(new BorderLayout());
            rightPanel.add((Component)this.getSigBlockPanel(), "North");
            rightPanel.add((Component)this.getSignaturesPanel(), "Center");
            this.splitPane.setRightComponent(rightPanel);
        }
        return this.sigMainPanel;
    }

    private IdsSignatureListPanel getListPanel() {
        if (this.listPanel == null) {
            this.listPanel = new IdsSignatureListPanel(this.idsLibraryObject, this.isSystemLibrary);
            this.listPanel.addListSelectionListener(this.listPanel);
            this.listPanel.setRightPanels(this.getSigBlockPanel(), this.getSignaturesPanel());
            this.listPanel.selectDefaultRow();
            this.listPanel.setPreferredSize(new Dimension(200, 500));
            this.listPanel.setBlockPanel(this.getSigBlockPanel());
        }
        return this.listPanel;
    }

    private IdsSignatureBlockPanel getSigBlockPanel() {
        if (this.sigBlockPanel == null) {
            this.sigBlockPanel = new IdsSignatureBlockPanel(this.isSystemLibrary, this.getSignaturesPanel(), this.getListPanel());
            this.sigBlockPanel.setPreferredSize(new Dimension(400, 135));
            this.sigBlockPanel.setBorder(BorderFactory.createTitledBorder(""));
        }
        return this.sigBlockPanel;
    }

    private IdsSignaturePanel getSignaturesPanel() {
        if (this.signaturesPanel == null) {
            this.signaturesPanel = new IdsSignaturePanel(this.isSystemLibrary);
            this.signaturesPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsEditor.title.Signatures")));
        }
        return this.signaturesPanel;
    }

    private IdsVariablePanel getVariablePanel() {
        if (this.variablePanel == null) {
            this.variablePanel = new IdsVariablePanel(this.idsLibraryObject, this.isSystemLibrary);
            this.variablePanel.setPreferredSize(new Dimension(200, 500));
        }
        return this.variablePanel;
    }

    private JTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new JTextField();
            RestrictedPlainDocument doc = new RestrictedPlainDocument(260);
            doc.setValidator("/\\*?<>|\":", false);
            this.nameTextField.setDocument(doc);
            this.nameTextField.setEditable(!this.isSystemLibrary);
        }
        return this.nameTextField;
    }

    private JTextArea getDescTextArea() {
        if (this.descArea == null) {
            RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
            this.descArea = new JTextArea();
            this.descArea.setRows(2);
            this.descArea.setLineWrap(true);
            this.descArea.setWrapStyleWord(true);
            this.descArea.setDocument(doc);
            this.descArea.setEditable(!this.isSystemLibrary);
        }
        return this.descArea;
    }

    private JTextField getSerialNumberTextField() {
        if (this.serialNumberTextField == null) {
            this.serialNumberTextField = new JTextField();
            this.serialNumberTextField.setEditable(false);
        }
        return this.serialNumberTextField;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        if (this.tabbedPane.getSelectedComponent() == this.sigMainPanel) {
            return "sesm_policies_dialog_ids_custom_signature";
        }
        return ((ContentSensitiveHelpPage)((Object)this.tabbedPane.getSelectedComponent())).getContentSensitiveHelpToken();
    }

    @Override
    protected boolean isValidate() {
        boolean validName;
        if (this.getSigBlockPanel() != null && !(validName = this.getSigBlockPanel().updateName())) {
            return false;
        }
        if (this.getNameTextField().getText() == null || this.getNameTextField().getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsEditor.error.EmptyName"));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdsEditor.this.getNameTextField().requestFocus();
                }
            });
            return false;
        }
        return this.updateValues();
    }

    private boolean updateValues() {
        if (!this.validateName(this.getNameTextField().getText().trim())) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsEditor.error.LibNameExists"), this.getNameTextField().getText()));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdsEditor.this.getNameTextField().requestFocus();
                }
            });
            return false;
        }
        this.idsLibraryObject.setName(this.getNameTextField().getText());
        this.idsLibraryObject.setDesc(this.getDescTextArea().getText());
        return true;
    }

    private boolean validateName(String name) {
        try {
            IdsLibraryPoolObject idsPool = IdsLibraryPoolObject.getIdsLibraryPoolObject();
            List<String> names = idsPool.getAllName();
            if (this.oldName != null) {
                names.remove(this.oldName);
            }
            for (int i = 0; i < names.size(); ++i) {
                if (!name.equals(names.get(i))) continue;
                return false;
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsEditor.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return true;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    private void setReadOnly() {
        this.getNameTextField().setEnabled(false);
        this.getDescTextArea().setEnabled(false);
        this.getSerialNumberTextField().setEnabled(false);
        this.getListPanel().setReadOnly();
        this.getSigBlockPanel().setReadOnly();
        this.getSignaturesPanel().setReadOnly();
        this.getVariablePanel().setReadOnly();
        this.jBOk.setEnabled(false);
        this.addReadOnlyPane(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsEditor.readOnlyTopBar"));
    }

    private void addReadOnlyPane(String desc) {
        DescriptionTextArea descArea = new DescriptionTextArea(true);
        descArea.setText(desc);
        descArea.setBorder(BorderFactory.createEmptyBorder(3, 4, 5, 4));
        this.topPanel.add((Component)descArea, "North");
    }

    private String createTitle(boolean isCheckPolicyEnforcement) {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (isCheckPolicyEnforcement && AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsEditor.readOnlyTitle");
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsEditor.title");
    }
}

