/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.ids.IdsPopupMenu;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsApplicationDialog;
import com.sygate.scm.console.ui.policy.ids.logicobject.ApplicationContainerObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.ApplicationObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IdsApplicationsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String[] COLUMN_NAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationsPanel.label.Enabled"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationsPanel.label.Name"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationsPanel.label.Desc")};
    private JTable applicationsTable;
    private SortableTableModel tableModel;
    private IdsPopupMenu popupMenu;
    private JButton addButton;
    private JButton deleteButton;
    private JButton editButton;
    private Action addAction;
    private Action deleteAction;
    private Action editAction;
    private JPanel centerPanel;
    private JPanel buttonPanel;
    private ApplicationContainerObject appContainerObject;
    private int systemLibraryAppCnt = 0;

    public IdsApplicationsPanel(ApplicationContainerObject appContainerObject) {
        this.appContainerObject = appContainerObject;
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getCenterPanel(), "Center");
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BorderLayout());
            JScrollPane scroll = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)scroll, (JTable)this.getApplicationsTable());
            scroll.getViewport().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getModifiers() == 4) {
                        IdsApplicationsPanel.this.getApplicationsTable().clearSelection();
                        IdsApplicationsPanel.this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.centerPanel.add((Component)scroll, "Center");
            this.centerPanel.add((Component)this.getButtonPanel(), "South");
        }
        return this.centerPanel;
    }

    private JTable getApplicationsTable() {
        if (this.applicationsTable == null) {
            this.applicationsTable = new StripesTable();
            this.applicationsTable.setSelectionMode(0);
            this.applicationsTable.setModel(this.getTableModel());
            this.applicationsTable.addMouseListener(this.getTableMouseListener());
            this.applicationsTable.getSelectionModel().addListSelectionListener(this.getListSelectionListener());
        }
        if (this.applicationsTable.getRowCount() < 1) {
            ApplicationObject appObject = new ApplicationObject();
            appObject.setEnabled(true);
            appObject.setName("*");
            this.appContainerObject.addApplication(appObject.getExecutable());
            this.getTableModel().addRow(appObject);
        }
        return this.applicationsTable;
    }

    private SortableTableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new SortableTableModel(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return column == 0;
                }
            };
            this.tableModel.setColumnNames(this.COLUMN_NAMES);
            this.tableModel.setDataVector((Vector)Cast.cast(this.getApplications()));
        }
        return this.tableModel;
    }

    private MouseListener getTableMouseListener() {
        MouseAdapter tableMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ApplicationObject appObj;
                Point p = e.getPoint();
                int row = IdsApplicationsPanel.this.getApplicationsTable().rowAtPoint(p);
                if (e.getModifiers() == 4) {
                    if (row >= 0) {
                        IdsApplicationsPanel.this.getApplicationsTable().getSelectionModel().setSelectionInterval(row, row);
                    }
                    IdsApplicationsPanel.this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                } else if (e.getClickCount() == 2 && !(appObj = (ApplicationObject)IdsApplicationsPanel.this.getTableModel().getRow(row)).isSystemPredefined()) {
                    IdsApplicationsPanel.this.editApplication();
                }
            }
        };
        return tableMouseListener;
    }

    private Vector<ApplicationObject> getApplications() {
        Vector<ApplicationObject> apps = this.appContainerObject.getApplications();
        for (int i = 0; i < apps.size(); ++i) {
            ApplicationObject app = apps.get(i);
            if (!app.isSystemPredefined()) continue;
            ++this.systemLibraryAppCnt;
        }
        return this.appContainerObject.getApplications();
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            Action[] actions = new Action[]{this.getAddAction(), this.getEditAction(), this.getDeleteAction()};
            this.popupMenu = new IdsPopupMenu(actions);
        }
        return this.popupMenu;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            JButton[] buttons = new JButton[]{this.getAddButton(), this.getEditButton(), this.getDeleteButton()};
            this.buttonPanel = new ButtonPane(buttons, 1);
            this.getDeleteAction().setEnabled(false);
            this.getEditAction().setEnabled(false);
        }
        return this.buttonPanel;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton(this.getAddAction());
        }
        return this.addButton;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton(this.getDeleteAction());
        }
        return this.deleteButton;
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton(this.getEditAction());
        }
        return this.editButton;
    }

    private Action getAddAction() {
        if (this.addAction == null) {
            this.addAction = new AbstractAction(UIText.get(5)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationObject appObject = new ApplicationObject();
                    IdsApplicationDialog dialog = new IdsApplicationDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationsPanel.title.AddAppl"), appObject, IdsApplicationsPanel.this.getAllAppNames(null));
                    if (!dialog.isCancelled()) {
                        IdsApplicationsPanel.this.appContainerObject.addApplication(appObject.getExecutable());
                        IdsApplicationsPanel.this.getTableModel().addRow(appObject);
                    }
                }
            };
        }
        return this.addAction;
    }

    private Action getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new AbstractAction(UIText.get(769)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = IdsApplicationsPanel.this.getApplicationsTable().getSelectedRow();
                    if (index == -1) {
                        JOptionPane.showMessageDialog(IdsApplicationsPanel.this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationsPanel.error.SelectApplToEdit"));
                        return;
                    }
                    String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationsPanel.ConfirmApplDelete");
                    int confirmOption = JOptionPane.showConfirmDialog(IdsApplicationsPanel.this, message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationsPanel.title.Warning"), 2, 2);
                    if (confirmOption == 0) {
                        ApplicationObject appObject = (ApplicationObject)IdsApplicationsPanel.this.getTableModel().getRow(index);
                        IdsApplicationsPanel.this.appContainerObject.deleteApplication(appObject.getExecutable());
                        IdsApplicationsPanel.this.getTableModel().removeRow(index);
                        IdsApplicationsPanel.this.getEditAction().setEnabled(false);
                        IdsApplicationsPanel.this.getDeleteAction().setEnabled(false);
                    }
                }
            };
        }
        return this.deleteAction;
    }

    private Action getEditAction() {
        if (this.editAction == null) {
            this.editAction = new AbstractAction(UIText.get(1024)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdsApplicationsPanel.this.editApplication();
                }
            };
        }
        return this.editAction;
    }

    private void editApplication() {
        int index = this.getApplicationsTable().getSelectedRow();
        if (index == -1) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationsPanel.error.SelectApplToEdit"));
            return;
        }
        ApplicationObject appObject = (ApplicationObject)this.getTableModel().getRow(index);
        try {
            ApplicationObject appObjectCopy = appObject.getClone();
            IdsApplicationDialog dialog = new IdsApplicationDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationsPanel.title.EditAppl"), appObjectCopy, this.getAllAppNames(appObjectCopy.getName()));
            if (!dialog.isCancelled()) {
                this.getTableModel().setRow(index, appObjectCopy);
                int rowNum = index - this.systemLibraryAppCnt;
                this.appContainerObject.setApplicaiton(rowNum, appObjectCopy.getExecutable());
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            System.out.println("Failed to copy protocol object for edit" + ex.getMessage());
        }
    }

    private List<String> getAllAppNames(String curApp) {
        ArrayList<String> nameList = new ArrayList<String>();
        Vector<ApplicationObject> apps = this.getApplications();
        for (ApplicationObject appObj : apps) {
            String name = appObj.getName();
            if (name.equals(curApp)) continue;
            nameList.add(name);
        }
        return nameList;
    }

    private ListSelectionListener getListSelectionListener() {
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    IdsApplicationsPanel.this.getEditAction().setEnabled(false);
                    IdsApplicationsPanel.this.getDeleteAction().setEnabled(false);
                    return;
                }
                int row = lsm.getMinSelectionIndex();
                if (row >= 0) {
                    ApplicationObject appObj = (ApplicationObject)IdsApplicationsPanel.this.getTableModel().getRow(row);
                    IdsApplicationsPanel.this.getEditAction().setEnabled(!appObj.isSystemPredefined());
                    IdsApplicationsPanel.this.getDeleteAction().setEnabled(!appObj.isSystemPredefined());
                    IdsApplicationsPanel.this.getApplicationsTable().getSelectionModel().setSelectionInterval(row, row);
                }
            }
        };
        return listSelectionListener;
    }
}

