/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.ids.logicobject.ApplicationObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class IdsApplicationDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private JTextField nameTextField;
    private JTextArea descArea;
    private ApplicationObject appObject;
    private List<String> allNames;

    public IdsApplicationDialog(String title, ApplicationObject appObject, List<String> allAppNames) {
        super(Manager.getFrame(), title, true);
        this.appObject = appObject;
        this.allNames = allAppNames;
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(new Dimension(400, 150));
        JPanel newPanel = new JPanel(new GridBagLayout());
        JLabel nameLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationDialog.label.FileName"));
        newPanel.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        newPanel.add((Component)this.getNameTextField(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        JLabel descLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationDialog.label.Desc"));
        newPanel.add((Component)descLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        JScrollPane scroll = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scroll, (JTextArea)this.getDescTextArea());
        newPanel.add((Component)scroll, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 200, 0));
        this.getContentPane().add((Component)newPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setValues();
        this.pack();
        this.setResizable(false);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    private void setValues() {
        this.getNameTextField().setText(this.appObject.getName());
        this.getDescTextArea().setText(this.appObject.getDesc());
    }

    private JTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new JTextField();
            RestrictedPlainDocument doc = new RestrictedPlainDocument(255);
            doc.setValidator("/\\?<>|\":", false);
            this.nameTextField.setDocument(doc);
            this.nameTextField.setBounds(85, 10, 250, 20);
        }
        return this.nameTextField;
    }

    private JTextArea getDescTextArea() {
        if (this.descArea == null) {
            RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
            this.descArea = new JTextArea();
            this.descArea.setWrapStyleWord(true);
            this.descArea.setLineWrap(true);
            this.descArea.setRows(3);
            this.descArea.setDocument(doc);
        }
        return this.descArea;
    }

    @Override
    protected boolean isValidate() {
        String name = this.getNameTextField().getText().trim();
        boolean badName = false;
        if (name == null || name.trim().length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationDialog.error.NameRequired"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationDialog.title.InvalidName"), 0);
            badName = true;
        } else if (name.indexOf("*") != -1 && !name.equals("*")) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationDialog.error.UsageStar"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationDialog.title.InvalidName"), 0);
            badName = true;
        } else if (this.allNames != null && this.allNames.contains(name)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationDialog.error.NameExists"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsApplicationDialog.title.InvalidName"), 0);
            badName = true;
        }
        if (badName) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdsApplicationDialog.this.getNameTextField().requestFocus();
                }
            });
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        this.updateValues();
    }

    public boolean isCancelled() {
        return !this.isOk;
    }

    private void updateValues() {
        this.appObject.setName(this.getNameTextField().getText().trim());
        this.appObject.setDesc(this.getDescTextArea().getText());
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_ids_custom_signature_add_application";
    }
}

