/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class ExceptionPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 8873135024022966639L;
    static final String[] ACTION_ITEMS = new String[]{Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.Block"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.Allow")};
    static final float[] TABLE_COLUMN_WIDTH = new float[]{0.1f, 0.3f, 0.1f, 0.3f, 0.1f, 0.1f};
    static final String[] TABLE_COLUMN_NAME = new String[]{Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.EventId"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.EventName"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.Severity"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.Categories"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.Action"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.Log")};
    JPanel topPanel;
    JPanel centerPanel;
    JPanel bottomPanel;
    JTable exceptionTable;
    JButton addButton;
    JButton editButton;
    JButton deleteButton;
    Action addAction;
    Action editAction;
    Action deleteAction;
    private boolean readOnly;
    private PopupListener popupListener = new PopupListener();
    private JMenuItem addMenuItem;
    private JMenuItem editMenuItem;
    private JMenuItem deleteMenuItem;
    private JPopupMenu popupMenu;

    public ExceptionPanel() {
        this.initialize();
    }

    protected void initialize() {
        JPanel exceptionPanel = new JPanel();
        this.setLayout(new BorderLayout());
        exceptionPanel.setLayout(new GridBagLayout());
        this.add((Component)exceptionPanel, "North");
        exceptionPanel.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 0));
        exceptionPanel.add((Component)this.getTopPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        exceptionPanel.add((Component)this.getCenterPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        exceptionPanel.add((Component)this.getBottomPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        exceptionPanel.add(Box.createGlue(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.enableButtons();
    }

    protected JPanel getTopPanel() {
        if (this.topPanel == null) {
            String strPolicyTitle = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.title");
            String strPolicyDesc = Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.desc");
            this.topPanel = new AvTemplatePane(strPolicyTitle, strPolicyDesc, false);
        }
        return this.topPanel;
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel(new BorderLayout());
            this.centerPanel.setLayout(new BorderLayout());
            JScrollPane scroll = new JScrollPane(this.getExceptionTable());
            scroll.setOpaque(false);
            scroll.addMouseListener(this.popupListener);
            this.centerPanel.add((Component)scroll, "Center");
        }
        return this.centerPanel;
    }

    private JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
            UIUtilities.layoutButtonPanel(this.bottomPanel, new JButton[]{this.getAddButton(), this.getEditButton(), this.getDeleteButton()}, 0, 4, true);
        }
        return this.bottomPanel;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton(UIText.get(769));
            this.deleteButton.setAction(this.getDeleteAction());
        }
        return this.deleteButton;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_ids_exceptions";
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton(UIText.get(1024));
            this.editButton.setAction(this.getEditAction());
        }
        return this.editButton;
    }

    private Action getEditAction() {
        if (this.editAction == null) {
            this.editAction = new AbstractAction(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.Edit")){
                private static final long serialVersionUID = 7095325766080566340L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionPanel.this.editException();
                }
            };
        }
        return this.editAction;
    }

    private Action getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new AbstractAction(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.Delete")){
                private static final long serialVersionUID = -7742410577346773995L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionPanel.this.deleteException();
                }
            };
        }
        return this.deleteAction;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            String add = UIText.get(5);
            this.addButton = new JButton(add);
            this.addButton.setAction(this.getAddAction());
        }
        return this.addButton;
    }

    private Action getAddAction() {
        if (this.addAction == null) {
            this.addAction = new AbstractAction(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.Add")){
                private static final long serialVersionUID = -4913218948171136249L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionPanel.this.addException();
                }
            };
        }
        return this.addAction;
    }

    protected JTable getExceptionTable() {
        if (this.exceptionTable == null) {
            this.exceptionTable = new StripesTable(this.getExceptionModel());
            this.getExceptionModel().addMouseListenerToHeaderInTable(this.exceptionTable);
            this.exceptionTable.addMouseListener(this.popupListener);
            UIUtilities.setTableColumnWidth(this.exceptionTable, TABLE_COLUMN_WIDTH, (int)this.exceptionTable.getPreferredScrollableViewportSize().getWidth());
            this.exceptionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ExceptionPanel.this.enableButtons();
                }
            });
            this.exceptionTable.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(this.getActionCombo()));
            this.exceptionTable.setSelectionMode(2);
            this.exceptionTable.setAutoResizeMode(4);
        }
        return this.exceptionTable;
    }

    protected void enableButtons() {
        if (this.readOnly) {
            return;
        }
        int rowCount = this.getExceptionTable().getSelectedRowCount();
        boolean isSingleLineSelected = false;
        boolean isMultiLineSelected = false;
        if (rowCount == 1) {
            isSingleLineSelected = true;
        } else if (rowCount > 1) {
            isMultiLineSelected = true;
        }
        this.getEditAction().setEnabled(isSingleLineSelected);
        this.getDeleteAction().setEnabled(isSingleLineSelected || isMultiLineSelected);
    }

    protected void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    private void showPopup(MouseEvent event) {
        Point p = event.getPoint();
        int row = this.getExceptionTable().rowAtPoint(p);
        if (row == -1) {
            this.getExceptionTable().clearSelection();
        }
        if (event.isPopupTrigger()) {
            this.getPopupMenu().show(event.getComponent(), event.getX(), event.getY());
        }
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.editMenuItem = new JMenuItem(UIText.get(1024));
            this.editMenuItem.addActionListener(this.getEditAction());
            this.deleteMenuItem = new JMenuItem(UIText.get(769));
            this.deleteMenuItem.addActionListener(this.getDeleteAction());
            this.addMenuItem = new JMenuItem(UIText.get(5));
            this.addMenuItem.addActionListener(this.getAddAction());
            this.popupMenu.add(this.addMenuItem);
            this.popupMenu.add(this.editMenuItem);
            this.popupMenu.add(this.deleteMenuItem);
        }
        this.enablePopupMenuItems();
        return this.popupMenu;
    }

    protected abstract JComboBox<String> getActionCombo();

    private void enablePopupMenuItems() {
        int rowCount = this.getExceptionTable().getSelectedRowCount();
        boolean isSingleLineSelected = false;
        boolean isMultiLineSelected = false;
        if (rowCount == 1) {
            isSingleLineSelected = true;
        } else if (rowCount > 1) {
            isMultiLineSelected = true;
        }
        if (this.editMenuItem != null) {
            this.editMenuItem.setEnabled(isSingleLineSelected);
        }
        if (this.deleteMenuItem != null) {
            this.deleteMenuItem.setEnabled(isSingleLineSelected || isMultiLineSelected);
        }
    }

    protected abstract void addException();

    protected abstract void deleteException();

    protected abstract void editException();

    protected abstract SortableTableModel getExceptionModel();

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            ExceptionPanel.this.showPopup(event);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            ExceptionPanel.this.showPopup(event);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() >= 2) {
                ExceptionPanel.this.editException();
            }
        }
    }
}

