/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.ids.dialog.EventActionDialog;
import com.sygate.scm.console.ui.policy.ids.dialog.EventNoActionDialog;
import com.sygate.scm.console.ui.policy.ids.handler.IdsCategoryHandler;
import com.sygate.scm.console.ui.policy.ids.handler.IdsCategoryHelper;
import com.sygate.scm.console.ui.policy.ids.handler.IdsSeverityHandler;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsEventObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsMetadataEvent;
import com.sygate.scm.console.ui.policy.ids.logicobject.MetadataEventFilter;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class ExceptionListDialog
extends DialogBase
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1772891474189238856L;
    private static String[] TABLE_COLUMN_NAME = new String[]{Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.EventId"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.EventName"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.Severity"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.Categories"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.Action"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "IdsExceptionPanel.Log")};
    protected static final String ids_url1 = "<html><body><a href=\"https://www.symantec.com/avcenter/attack_sigs/index.html\"" + (AjaxSwingCommonUtil.isAjaxSwingRunning() ? " target=\"_blank\"" : "") + ">";
    protected static final String ids_url2 = "</a></body></html>";
    JPanel topPanel;
    JPanel centerPanel;
    JPanel bottomPanel;
    protected JPanel filterPanel;
    private JComboBox<Object> categoryList;
    private JComboBox<IdsSeverityHandler.IdsSeverityFilter> severityComBox;
    private JTable exceptionTable;
    private JPanel buttonPanel;
    private JButton selectAllButton;
    private JButton unselectAllButton;
    private JPanel southPanel;
    private SortableTableModel exceptionModel;
    private List<IdsEventObject> retList = new ArrayList<IdsEventObject>();
    protected MetadataEventFilter curFilter1;
    protected MetadataEventFilter curFilter2;
    private JPanel statusPanel;
    private JLabel numberLbl;

    public ExceptionListDialog(JFrame owner, String title, List<IdsMetadataEvent> data) throws HeadlessException {
        super(owner, title, true);
        this.initialized();
        this.initializeData(data);
        this.pack();
        this.setSize(this.getPreferredSize().width + 180, this.getPreferredSize().height);
        UiUtilities.centerComponent((Component)this);
    }

    @Override
    protected boolean ok() {
        if (!Env.isUnitTest() && !this.isValidate()) {
            return false;
        }
        this.isOk = true;
        this.commit();
        if (this.isOk) {
            this.dispose();
        }
        return true;
    }

    @Override
    protected void commit() {
        Boolean browswerProtectionExceptionSeclected = false;
        int[] indexList = this.getExceptionTable().getSelectedRows();
        browswerProtectionExceptionSeclected = this.isBrowserIPSExceptionSelected(indexList);
        DialogBase dlg = null;
        if (browswerProtectionExceptionSeclected.booleanValue()) {
            dlg = new EventNoActionDialog((Frame)Manager.getFrame(), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.EventDlgTitle"));
            dlg.setVisible(true);
            this.isOk = !((EventNoActionDialog)dlg).isCancelled();
        } else {
            dlg = new EventActionDialog((Frame)Manager.getFrame(), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.EventDlgTitle"));
            dlg.setVisible(true);
            boolean bl = this.isOk = !((EventActionDialog)dlg).isCancelled();
        }
        if (this.isOk) {
            boolean isBlock = false;
            boolean isLog = false;
            if (!browswerProtectionExceptionSeclected.booleanValue()) {
                isBlock = ((EventActionDialog)dlg).isBlock();
                isLog = ((EventActionDialog)dlg).isLog();
            }
            this.retList = new ArrayList<IdsEventObject>();
            for (int i = 0; i < indexList.length; ++i) {
                IdsMetadataEvent event = (IdsMetadataEvent)this.getExceptionModel().getRow(indexList[i]);
                IdsEventObject eventObj = null;
                eventObj = !this.isBrowserProtectionIDS(event) ? new IdsEventObject(event, browswerProtectionExceptionSeclected == false ? isBlock : event.isBlocked(), browswerProtectionExceptionSeclected == false ? isLog : event.isLog()) : new IdsEventObject(event, false, false);
                this.retList.add(eventObj);
            }
        }
    }

    protected boolean isBrowserProtectionIDS(IdsMetadataEvent event) {
        Integer eventId = Integer.valueOf(event.getId());
        return IdsCategoryHelper.isBrowserProtectionSignature(eventId);
    }

    @Override
    protected String getOkButtonText() {
        return Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.Next");
    }

    private void initializeData(List<IdsMetadataEvent> data) {
        Vector<TableRow> v = new Vector<TableRow>();
        v.addAll(this.stripGEMSignatures(data));
        this.getExceptionModel().setDataVector(v);
        this.getNumberLbl().setText(String.valueOf(v.size()));
    }

    protected List<IdsMetadataEvent> stripGEMSignatures(List<IdsMetadataEvent> data) {
        ArrayList<IdsMetadataEvent> modifiedList = new ArrayList<IdsMetadataEvent>();
        for (IdsMetadataEvent event : data) {
            if (Integer.parseInt(event.getId()) >= 61000 && Integer.parseInt(event.getId()) <= 61999) continue;
            modifiedList.add(event);
        }
        return modifiedList;
    }

    private void initialized() {
        this.getContentPane().add((Component)this.getTopPanel(), "North");
        this.getContentPane().add((Component)this.getCenterPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel(new BorderLayout());
            Border border = BorderFactory.createEmptyBorder(5, 40, 5, 40);
            this.centerPanel.setBorder(border);
            this.centerPanel.add((Component)this.getFilterPanel(), "North");
            JScrollPane sPane = new JScrollPane(this.getExceptionTable());
            this.centerPanel.add((Component)sPane, "Center");
            this.centerPanel.add((Component)this.getSouthPanel(), "South");
        }
        return this.centerPanel;
    }

    private JPanel getSouthPanel() {
        if (this.southPanel == null) {
            this.southPanel = new JPanel();
            this.southPanel.setLayout(new VerticalFlowLayout(0, 0));
            this.southPanel.add(this.getStatusAndButtonPanel());
            this.southPanel.add(this.getLinkPanel());
        }
        return this.southPanel;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel(new FlowLayout(3));
            JLabel label = new JLabel(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.total"));
            this.statusPanel.add(label);
            this.statusPanel.add(this.getNumberLbl());
        }
        return this.statusPanel;
    }

    protected JLabel getNumberLbl() {
        if (this.numberLbl == null) {
            this.numberLbl = new JLabel();
        }
        return this.numberLbl;
    }

    private JPanel getStatusAndButtonPanel() {
        if (this.buttonPanel == null) {
            JButton[] buttons = new JButton[]{this.getSelectAllButton(), this.getUnselectAllButton()};
            this.buttonPanel = new ButtonPane(buttons, 4);
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 10));
            JPanel wrap = new JPanel(new BorderLayout());
            wrap.add((Component)this.buttonPanel, "East");
            wrap.add((Component)this.getStatusPanel(), "West");
            this.buttonPanel = wrap;
        }
        return this.buttonPanel;
    }

    private JButton getUnselectAllButton() {
        if (this.unselectAllButton == null) {
            this.unselectAllButton = new JButton(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.UnselectAll"));
            this.unselectAllButton.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionListDialog.this.getExceptionTable().clearSelection();
                }
            });
        }
        return this.unselectAllButton;
    }

    private JButton getSelectAllButton() {
        if (this.selectAllButton == null) {
            this.selectAllButton = new JButton(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.SelectAll"));
            this.selectAllButton.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionListDialog.this.getExceptionTable().selectAll();
                }
            });
        }
        return this.selectAllButton;
    }

    private JTable getExceptionTable() {
        if (this.exceptionTable == null) {
            this.exceptionTable = new ExceptionTable(this.getExceptionModel());
            this.exceptionModel.addMouseListenerToHeaderInTable(this.exceptionTable);
            TableColumn column = this.exceptionTable.getColumnModel().getColumn(0);
            int col = this.exceptionTable.getColumnCount();
            int colWidth = column.getPreferredWidth();
            for (int i = 0; i < col; ++i) {
                double f = 0.8;
                if (i == 1) {
                    f = 3.0;
                } else if (i == 3) {
                    f = 2.5;
                }
                column = this.exceptionTable.getColumnModel().getColumn(i);
                column.setMinWidth((int)((double)colWidth * f));
            }
            ((DefaultTableCellRenderer)this.exceptionTable.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
        }
        return this.exceptionTable;
    }

    protected SortableTableModel getExceptionModel() {
        if (this.exceptionModel == null) {
            this.exceptionModel = new SortableTableModel();
            this.exceptionModel.setColumnNames(TABLE_COLUMN_NAME);
        }
        return this.exceptionModel;
    }

    private JPanel getFilterPanel() {
        if (this.filterPanel == null) {
            this.filterPanel = new JPanel(new GridBagLayout());
            this.getFilterComponents();
            Color background = UIManager.getColor("TableHeader.background");
            this.filterPanel.setBackground(background);
            this.filterPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(background.darker()), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            JPanel wrapper = new JPanel();
            wrapper.setLayout(new BoxLayout(wrapper, 1));
            wrapper.add(this.filterPanel);
            wrapper.add(Box.createVerticalStrut(5));
            this.filterPanel = wrapper;
        }
        return this.filterPanel;
    }

    protected JComboBox<IdsSeverityHandler.IdsSeverityFilter> getSeverityList() {
        if (this.severityComBox == null) {
            this.severityComBox = new JComboBox<IdsSeverityHandler.IdsSeverityFilter>(IdsSeverityHandler.getSeverityList());
            this.severityComBox.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionListDialog.this.fiterTable();
                }
            });
        }
        return this.severityComBox;
    }

    protected JComboBox<Object> getCategoryList() {
        if (this.categoryList == null) {
            this.categoryList = new JComboBox();
            this.categoryList.setModel(this.getCategoryListModel());
            this.categoryList.setRenderer(new CategoryListRenderer());
            this.categoryList.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionListDialog.this.fiterTable();
                }
            });
        }
        return this.categoryList;
    }

    private ComboBoxModel<Object> getCategoryListModel() {
        List<IdsCategoryHandler.IdsCategoryFilter> categoryList = null;
        try {
            categoryList = IdsCategoryHandler.getCategoryList();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.CannotGetCategoryList"));
        }
        if (categoryList == null) {
            categoryList = IdsCategoryHandler.getDefaultList();
        }
        return new DefaultComboBoxModel<Object>(categoryList.toArray());
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new AvTemplatePane(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.title"), Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "ExceptionListDialog.desc"));
        }
        return this.topPanel;
    }

    public List<IdsEventObject> getEventList() {
        return this.retList;
    }

    @Override
    protected boolean isOkButtonActive() {
        boolean allOK = true;
        boolean retVal = true;
        try {
            retVal = this.exceptionTable.getRowCount() >= 1 && this.exceptionTable.getSelectedRow() >= 0;
        }
        catch (Exception e) {
            allOK = false;
            LoggerUtilities.logException((Throwable)e);
        }
        if (allOK) {
            return retVal;
        }
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_ids_exceptions_add";
    }

    protected abstract boolean isBrowserIPSExceptionSelected(int[] var1);

    protected abstract void getFilterComponents();

    protected abstract void fiterTable();

    protected abstract JPanel getLinkPanel();

    static class CategoryListRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private static final long serialVersionUID = -799143426008496120L;
        JTextField textField = new JTextField();

        public CategoryListRenderer() {
            this.textField.setEditable(false);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            IdsCategoryHandler.IdsCategoryFilter categoryFilter = (IdsCategoryHandler.IdsCategoryFilter)value;
            if (index == -1) {
                this.textField.setText(categoryFilter.getName());
                return this.textField;
            }
            int level = categoryFilter.getLevel();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < level; ++i) {
                sb.append("   ");
            }
            sb.append(categoryFilter.getName());
            this.setText(sb.toString());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    class ExceptionTable
    extends StripesTable {
        private static final long serialVersionUID = 1L;

        public ExceptionTable(SortableTableModel model) {
            super(model);
        }

        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            ExceptionListDialog.this.jBOk.setEnabled(ExceptionListDialog.this.isOkButtonActive());
        }
    }
}

