/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids.dialog;

import com.sygate.scm.common.configobject.schema.PacketProcess;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EventActionDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static String[] ACTION_LIST = new String[]{EventActionDialog.getString("EventActionDialog.Block"), EventActionDialog.getString("EventActionDialog.Allow")};
    private static Map<String, Integer> ACTION_MAP = new HashMap<String, Integer>();
    private static String[] LOG_LIST = new String[]{EventActionDialog.getString("EventActionDialog.LogTraffic"), EventActionDialog.getString("EventActionDialog.UnlogTraffic")};
    private static Map<String, Boolean> LOG_MAP = new HashMap<String, Boolean>();
    private static Map<Integer, String> ACTION_STR_MAP = new HashMap<Integer, String>();
    private static Map<Boolean, String> LOG_STR_MAP = new HashMap<Boolean, String>();
    private JPanel centerPanel;
    private JComboBox<String> actionComboBox;
    private JComboBox<String> logComboBox;

    public EventActionDialog(Frame frame, String title) {
        super(Manager.getFrame(), title, true);
        this.initialize();
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    private void initialize() {
        this.getContentPane().add((Component)this.getCenterPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel(new GridBagLayout());
            JLabel actionLbl = new JLabel(EventActionDialog.getString("EventActionDialog.action"));
            this.centerPanel.add((Component)actionLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
            this.centerPanel.add(this.getActionComboBox(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 10, 0, 10), 0, 0));
            JLabel logLbl = new JLabel(EventActionDialog.getString("EventActionDialog.log"));
            this.centerPanel.add((Component)logLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
            this.centerPanel.add(this.getLogComboBox(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(10, 10, 0, 10), 0, 0));
            this.centerPanel.add((Component)new JLabel(""), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 12, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.centerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        return this.centerPanel;
    }

    private JComboBox<String> getLogComboBox() {
        if (this.logComboBox == null) {
            this.logComboBox = new JComboBox<String>(LOG_LIST);
        }
        return this.logComboBox;
    }

    private JComboBox<String> getActionComboBox() {
        if (this.actionComboBox == null) {
            this.actionComboBox = new JComboBox<String>(ACTION_LIST);
        }
        return this.actionComboBox;
    }

    private static String getString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", key);
    }

    public boolean isCancelled() {
        return !this.isOk;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_ids_exceptions_add_next";
    }

    public boolean isBlock() {
        Object actionObj = this.getActionComboBox().getSelectedItem();
        Integer process = ACTION_MAP.get(actionObj);
        return process.equals(PacketProcess.DROP);
    }

    public boolean isLog() {
        Object logObj = this.getLogComboBox().getSelectedItem();
        Boolean log = LOG_MAP.get(logObj);
        return log;
    }

    public void setObject(boolean isBlock, boolean isLog) {
        Integer action = PacketProcess.PASS;
        if (isBlock) {
            action = PacketProcess.DROP;
        }
        Boolean log = isLog;
        String strAction = ACTION_STR_MAP.get(action);
        String strLog = LOG_STR_MAP.get(log);
        this.getActionComboBox().setSelectedItem(strAction);
        this.getLogComboBox().setSelectedItem(strLog);
    }

    static {
        ACTION_MAP.put(EventActionDialog.getString("EventActionDialog.Block"), PacketProcess.DROP);
        ACTION_MAP.put(EventActionDialog.getString("EventActionDialog.Allow"), PacketProcess.PASS);
        LOG_MAP.put(EventActionDialog.getString("EventActionDialog.LogTraffic"), Boolean.TRUE);
        LOG_MAP.put(EventActionDialog.getString("EventActionDialog.UnlogTraffic"), Boolean.FALSE);
        ACTION_STR_MAP.put(PacketProcess.DROP, EventActionDialog.getString("EventActionDialog.Block"));
        ACTION_STR_MAP.put(PacketProcess.PASS, EventActionDialog.getString("EventActionDialog.Allow"));
        LOG_STR_MAP.put(Boolean.TRUE, EventActionDialog.getString("EventActionDialog.LogTraffic"));
        LOG_STR_MAP.put(Boolean.FALSE, EventActionDialog.getString("EventActionDialog.UnlogTraffic"));
    }
}

