/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.ids;

import com.sygate.scm.common.configobject.schema.IDS;
import com.sygate.scm.common.configobject.schema.IdsPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.IDSObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.PolicyHelper;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryPoolObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsPolicyObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsPolicyPoolObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class IdsLibraryPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryPanel.Enabled"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryPanel.LibName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryPanel.Desc"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryPanel.UpdateTime")};
    private JTable idsLibraryTable;
    private SortableTableModel model;
    private JComboBox<IdsPolicyObject> streamBox;
    private JButton selectButton;
    private JButton unselectButton;
    private Action selectAction;
    private Action unselectAction;
    private IdsLibraryPoolObject idsLibraryPoolObject;
    private IdsPolicyPoolObject idsPolicyPool;
    private IDSObject idsObject;
    boolean readOnly = false;
    LicenseObject myLicenseObj = LicenseObject.getInstance();

    void checkAllRows(boolean checked) {
        int rowCount = this.model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.model.setValueAt(checked, i, 0);
        }
    }

    public void disableAll() {
        this.streamBox.setEnabled(false);
        this.idsLibraryTable.setEnabled(false);
        this.selectButton.setEnabled(false);
        this.unselectButton.setEnabled(false);
    }

    private void init() {
        this.initDataComponents();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPacketPanel(), "Center");
        if (this.readOnly) {
            this.disableAll();
        }
    }

    private String getRes(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryPanel." + key);
    }

    private void initDataComponents() {
        String streamID = this.idsObject.getStreamPolicyID();
        IdsPolicyObject selectedStream = null;
        Vector<PolicyObjectBase> data = this.getIdsLibraries();
        Vector<TableRow> packet = new Vector<TableRow>();
        Vector<IdsPolicyObject> stream = new Vector<IdsPolicyObject>();
        IdsPolicy none = new IdsPolicy();
        none.setName(this.getRes("noStreamPolicy"));
        stream.add(new IdsPolicyObject(none));
        for (PolicyObjectBase o : data) {
            if (o instanceof IdsLibraryObject) {
                packet.add((IdsLibraryObject)o);
                continue;
            }
            if (!(o instanceof IdsPolicyObject)) continue;
            stream.add((IdsPolicyObject)o);
            IdsPolicyObject ipo = (IdsPolicyObject)o;
            if (!ipo.getIdsPolicy().getId().equals(streamID)) continue;
            selectedStream = ipo;
        }
        this.model = this.getIdsLibraryTableModel(packet);
        this.streamBox = new JComboBox(stream);
        if (selectedStream != null) {
            this.streamBox.setSelectedItem(selectedStream);
        }
    }

    private JTable getIdsLibraryTable() {
        if (this.idsLibraryTable == null) {
            this.idsLibraryTable = new StripesTable();
            this.model.addMouseListenerToHeaderInTable(this.idsLibraryTable);
            this.idsLibraryTable.setModel(this.model);
            this.idsLibraryTable.setSelectionMode(0);
            this.idsLibraryTable.setPreferredScrollableViewportSize(new Dimension(470, 200));
            UIUtilities.setTableColumnWidth(this.idsLibraryTable, new float[]{0.15f, 0.2f, 0.45f, 0.2f}, (int)this.idsLibraryTable.getPreferredScrollableViewportSize().getWidth());
        }
        return this.idsLibraryTable;
    }

    private SortableTableModel getIdsLibraryTableModel(Vector<TableRow> data) {
        if (this.model == null) {
            this.model = new SortableTableModel(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return column == 0;
                }
            };
            this.model.setColumnNames(columnNames);
            this.model.setDataVector(data);
            this.model.setEditMode(this.readOnly);
        }
        return this.model;
    }

    private IdsLibraryPoolObject getIdsLibraryPoolObject() {
        if (this.idsLibraryPoolObject == null) {
            try {
                this.idsLibraryPoolObject = IdsLibraryPoolObject.getIdsLibraryPoolObject();
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryPanel.error.ReadingIPSLibs"), ex.getMessage()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryPanel.title.Error"), 0);
                Manager.getFrame().showLoginPanel();
            }
        }
        return this.idsLibraryPoolObject;
    }

    private IdsPolicyPoolObject getIdsPolicyPool() {
        if (this.idsPolicyPool == null) {
            try {
                this.idsPolicyPool = IdsPolicyPoolObject.getIdsPolicyPool();
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryPanel.error.ReadingIPSLibs"), ex.getMessage()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryPanel.title.Error"), 0);
                Manager.getFrame().showLoginPanel();
            }
        }
        return this.idsPolicyPool;
    }

    private ObjInfoObject[] getPolicies() {
        return this.getIdsPolicyPool().getInfoObjectList();
    }

    private ObjInfoObject[] getLibraries() {
        return this.getIdsLibraryPoolObject().getInfoObjectList();
    }

    private Vector<PolicyObjectBase> getIdsObjects(ObjInfoObject[] infoObj) {
        Vector<PolicyObjectBase> idsLib = new Vector<PolicyObjectBase>();
        try {
            for (int i = 0; i < infoObj.length; ++i) {
                TreeItem item = PolicyHelper.getIdsLibraryObject(infoObj[i]);
                if (item instanceof IdsLibraryObject) {
                    IdsLibraryObject libObj = (IdsLibraryObject)item;
                    libObj.setIDS(this.idsObject);
                    if (!this.myLicenseObj.isIntrusionPreventionEnabled() && !libObj.isEnabled()) continue;
                    idsLib.add(libObj);
                    continue;
                }
                IdsPolicyObject policyObj = (IdsPolicyObject)item;
                if (!this.myLicenseObj.isIntrusionPreventionEnabled() && !policyObj.isEnabled()) continue;
                idsLib.add(policyObj);
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryPanel.error.ReadingIPSLibs"), ex.getMessage()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryPanel.title.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return idsLib;
    }

    private Vector<PolicyObjectBase> getIdsLibraries() {
        Vector<PolicyObjectBase> idsLib = new Vector<PolicyObjectBase>();
        idsLib.addAll(this.getIdsObjects(this.getPolicies()));
        idsLib.addAll(this.getIdsObjects(this.getLibraries()));
        return idsLib;
    }

    private JPanel getLabelsPanel() {
        JPanel result = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(this.getRes("mergedPolicies")), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        result.add((Component)p, "West");
        result.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        return result;
    }

    private JPanel getPacketPanel() {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTable)this.getIdsLibraryTable());
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)scrollPane, "Center");
        p.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        result.add((Component)this.getLabelsPanel(), "North");
        result.add((Component)p, "Center");
        result.add((Component)this.getButtonPanel(), "South");
        result.setBorder(BorderFactory.createTitledBorder(this.getRes("packetTitle")));
        return result;
    }

    private JPanel getButtonPanel() {
        JButton[] buttons = new JButton[]{this.getSelectButton(), this.getUnselectButton()};
        ButtonPane buttonPanel = new ButtonPane(buttons, 4);
        return buttonPanel;
    }

    private JButton getSelectButton() {
        if (this.selectButton == null) {
            this.selectButton = new JButton(this.getSelectAction());
        }
        return this.selectButton;
    }

    private JButton getUnselectButton() {
        if (this.unselectButton == null) {
            this.unselectButton = new JButton(this.getUnselectAction());
        }
        return this.unselectButton;
    }

    private Action getSelectAction() {
        if (this.selectAction == null) {
            this.selectAction = new AbstractAction(UIText.get(4614)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdsLibraryPanel.this.checkAllRows(true);
                }
            };
        }
        return this.selectAction;
    }

    private Action getUnselectAction() {
        if (this.unselectAction == null) {
            this.unselectAction = new AbstractAction(UIText.get(5120)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdsLibraryPanel.this.checkAllRows(false);
                }
            };
        }
        return this.unselectAction;
    }

    private void save() {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            IdsLibraryObject ilo = (IdsLibraryObject)this.model.getRow(i);
            this.idsObject.setEnable(ilo.isEnabled(), ilo.getFwIdsLibrary());
        }
        IdsPolicyObject ipo = (IdsPolicyObject)this.streamBox.getSelectedItem();
        this.idsObject.clearStreamPolicy();
        if (this.streamBox.getSelectedIndex() != 0) {
            this.idsObject.addStreamPolicy(ipo.getIdsPolicy());
        }
    }

    public void setObject(IDSObject idsObj) {
        this.idsObject = idsObj;
        IDS ids = this.idsObject.getIDS();
        if (ids != null) {
            System.out.println("IPS Count Read:" + ids.getObjReferenceCount());
        }
        this.init();
    }

    public IDSObject getIDSObject() {
        this.save();
        return this.idsObject;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }
}

