/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hostgroup;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.DnsDomain;
import com.sygate.scm.common.configobject.schema.DnsHost;
import com.sygate.scm.common.configobject.schema.FwNetworkHostGroup;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.Ipv6Address;
import com.sygate.scm.common.configobject.schema.Ipv6Range;
import com.sygate.scm.common.configobject.schema.Ipv6SubNet;
import com.sygate.scm.common.configobject.schema.LocalSubnet;
import com.sygate.scm.common.configobject.schema.MacAddress;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostObject;
import com.sygate.scm.console.util.ConsoleException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;

public class HostGroupObject
implements TableRow,
Comparable<Object> {
    private FwNetworkHostGroup hostGroup;

    public HostGroupObject(FwNetworkHostGroup hostGroup) {
        this.hostGroup = hostGroup;
    }

    public FwNetworkHostGroup getHostGroup() {
        return this.hostGroup;
    }

    public void setContainer(FwNetworkHostGroup newHostGroup) {
        this.hostGroup = newHostGroup;
    }

    public String getName() {
        return this.hostGroup.getName();
    }

    public void setName(String newName) {
        this.hostGroup.setName(newName);
    }

    public String getId() {
        return this.hostGroup.getId();
    }

    private Vector<MacAddress> getMacAddress() {
        return this.hostGroup.getFwHostContainer().getMacAddress();
    }

    private Vector<DnsDomain> getDnsDomain() {
        return this.hostGroup.getFwHostContainer().getDnsDomain();
    }

    private LocalSubnet getLocalSubnet() {
        return this.hostGroup.getFwHostContainer().getOptLocalSubnet();
    }

    private Vector<DnsHost> getDnsHost() {
        return this.hostGroup.getFwHostContainer().getDnsHost();
    }

    private Vector<IpAddress> getIpAddress() {
        return this.hostGroup.getFwHostContainer().getIpAddress();
    }

    private Vector<IpRange> getIpRange() {
        return this.hostGroup.getFwHostContainer().getIpRange();
    }

    private Vector<SubNet> getSubNet() {
        return this.hostGroup.getFwHostContainer().getSubNet();
    }

    private Vector<Ipv6Address> getIpv6Address() {
        return this.hostGroup.getFwHostContainer().getIpv6Address();
    }

    private Vector<Ipv6Range> getIpv6Range() {
        return this.hostGroup.getFwHostContainer().getIpv6Range();
    }

    private Vector<Ipv6SubNet> getIpv6SubNet() {
        return this.hostGroup.getFwHostContainer().getIpv6SubNet();
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.hostGroup.getName();
            }
            case 1: {
                return this.getDescription();
            }
        }
        return null;
    }

    public Class<String> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        ArrayList<HostObject> hostObjects = this.getHostObjects();
        for (int i = 0; i < hostObjects.size(); ++i) {
            HostObject obj = hostObjects.get(i);
            if (buffer.length() > 0) {
                buffer.append("; ");
            }
            buffer.append(obj.getType() + "[" + obj.getContent() + "]");
        }
        return buffer.toString();
    }

    @Override
    public int compareTo(Object obj) {
        if (!(obj instanceof HostGroupObject)) {
            return 1;
        }
        HostGroupObject obj2 = (HostGroupObject)obj;
        int ret = this.getName().compareTo(obj2.getName());
        if (ret != 0) {
            return ret;
        }
        ret = this.getDescription().compareTo(obj2.getDescription());
        return ret;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public ImageIcon getIcon() {
        return ConsoleMain.serviceIcon;
    }

    public void addHostObject(HostObject hostObject) {
        this.addAddress(hostObject.getAddress());
    }

    public void deleteHostObject(HostObject hostObject) {
        this.deleteAddress(hostObject.getAddress());
    }

    private void addAddress(Object address) {
        if (address instanceof IpAddress) {
            this.hostGroup.getFwHostContainer().addIpAddress((IpAddress)address);
        } else if (address instanceof IpRange) {
            this.hostGroup.getFwHostContainer().addIpRange((IpRange)address);
        } else if (address instanceof MacAddress) {
            String content = ((MacAddress)address).getContent();
            this.hostGroup.getFwHostContainer().addMacAddress((MacAddress)address);
            PolicyHandler.addMacAddress(content);
        } else if (address instanceof SubNet) {
            this.hostGroup.getFwHostContainer().addSubNet((SubNet)address);
        } else if (address instanceof DnsDomain) {
            this.hostGroup.getFwHostContainer().addDnsDomain((DnsDomain)address);
        } else if (address instanceof DnsHost) {
            this.hostGroup.getFwHostContainer().addDnsHost((DnsHost)address);
        } else if (address instanceof LocalSubnet) {
            this.hostGroup.getFwHostContainer().setOptLocalSubnet((LocalSubnet)address);
        } else if (address instanceof Ipv6Address) {
            this.hostGroup.getFwHostContainer().addIpv6Address((Ipv6Address)address);
        } else if (address instanceof Ipv6Range) {
            this.hostGroup.getFwHostContainer().addIpv6Range((Ipv6Range)address);
        } else if (address instanceof Ipv6SubNet) {
            this.hostGroup.getFwHostContainer().addIpv6SubNet((Ipv6SubNet)address);
        }
    }

    private void deleteAddress(Object address) {
        if (address instanceof IpAddress) {
            this.hostGroup.getFwHostContainer().removeIpAddress((IpAddress)address);
        } else if (address instanceof IpRange) {
            this.hostGroup.getFwHostContainer().removeIpRange((IpRange)address);
        } else if (address instanceof MacAddress) {
            String content = ((MacAddress)address).getContent();
            this.hostGroup.getFwHostContainer().removeMacAddress((MacAddress)address);
            PolicyHandler.deleteMacAddress(content);
        } else if (address instanceof SubNet) {
            this.hostGroup.getFwHostContainer().removeSubNet((SubNet)address);
        } else if (address instanceof DnsDomain) {
            this.hostGroup.getFwHostContainer().removeDnsDomain((DnsDomain)address);
        } else if (address instanceof DnsHost) {
            this.hostGroup.getFwHostContainer().removeDnsHost((DnsHost)address);
        } else if (address instanceof LocalSubnet) {
            this.hostGroup.getFwHostContainer().setOptLocalSubnet(null);
        } else if (address instanceof Ipv6Address) {
            this.hostGroup.getFwHostContainer().removeIpv6Address((Ipv6Address)address);
        } else if (address instanceof Ipv6Range) {
            this.hostGroup.getFwHostContainer().removeIpv6Range((Ipv6Range)address);
        } else if (address instanceof Ipv6SubNet) {
            this.hostGroup.getFwHostContainer().removeIpv6SubNet((Ipv6SubNet)address);
        }
    }

    public ArrayList<HostObject> getHostObjects() {
        ArrayList<HostObject> hostObjects = new ArrayList<HostObject>();
        this.createHostObjects(hostObjects);
        return hostObjects;
    }

    private void createHostObjects(ArrayList<HostObject> destList) {
        if (this.getMacAddress() != null) {
            this.addHostObjects(destList, this.getMacAddress(), HostObject.getTypeByIndex(0));
        }
        if (this.getIpAddress() != null) {
            this.addHostObjects(destList, this.getIpAddress(), HostObject.getTypeByIndex(1));
        }
        if (this.getIpRange() != null) {
            this.addHostObjects(destList, this.getIpRange(), HostObject.getTypeByIndex(2));
        }
        if (this.getSubNet() != null) {
            this.addHostObjects(destList, this.getSubNet(), HostObject.getTypeByIndex(3));
        }
        if (this.getDnsHost() != null) {
            this.addHostObjects(destList, this.getDnsHost(), HostObject.getTypeByIndex(4));
        }
        if (this.getDnsDomain() != null) {
            this.addHostObjects(destList, this.getDnsDomain(), HostObject.getTypeByIndex(5));
        }
        if (this.getLocalSubnet() != null) {
            Vector<LocalSubnet> vec = new Vector<LocalSubnet>();
            vec.add(this.getLocalSubnet());
            this.addHostObjects(destList, vec, HostObject.getTypeByIndex(7));
        }
        if (this.getIpv6Address() != null) {
            this.addHostObjects(destList, this.getIpv6Address(), HostObject.getTypeByIndex(8));
        }
        if (this.getIpv6Range() != null) {
            this.addHostObjects(destList, this.getIpv6Range(), HostObject.getTypeByIndex(9));
        }
        if (this.getIpv6SubNet() != null) {
            this.addHostObjects(destList, this.getIpv6SubNet(), HostObject.getTypeByIndex(10));
        }
    }

    public HostGroupObject getClone() throws ConsoleException {
        try {
            AbstractSchema hostGroupCopy = AbstractSchema.readXML((byte[])this.hostGroup.getBytes());
            System.out.println("Copy Host Container:" + hostGroupCopy.getClass().getName());
            return new HostGroupObject((FwNetworkHostGroup)hostGroupCopy);
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    private void addHostObjects(ArrayList<HostObject> destList, Vector<?> addresses, String type) {
        if (addresses == null) {
            return;
        }
        for (int i = 0; i < addresses.size(); ++i) {
            destList.add(new HostObject(addresses.get(i), type, ""));
            if (!MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostContainerObject.MACAddress").equals(type)) continue;
            MacAddress macAddress = (MacAddress)addresses.get(i);
            String content = macAddress.getContent();
            PolicyHandler.addMacAddress(content);
        }
    }

    public String toString() {
        return this.getName();
    }
}

