/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hostgroup;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.FwHostContainer;
import com.sygate.scm.common.configobject.schema.FwNetworkHostGroup;
import com.sygate.scm.common.configobject.schema.FwNetworkHostGroupPool;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.ObjectPool;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.firewall.dialog.HostContainerPanel;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.JPanelGB;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.ScmProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class HostGroupDialog
extends DialogBase {
    private static final long serialVersionUID = 8238532492228791837L;
    private static MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.ui.policy.hostgroup.hostgroup");
    private JPanelGB mainPanel = new JPanelGB();
    private JPanelGB namePanel = new JPanelGB();
    private JLabel nameL = new JLabel(res.getString("HostGroupDialog.label.hostGroupName"));
    private DescriptionTextArea warning = new DescriptionTextArea(res.getString("HostGroupDialog.DescriptionIpsWarning"));
    private JTextField nameTF = new JTextField();
    private HostContainerPanel hostContainerPanel = null;
    private FwNetworkHostGroup hostGroup = null;

    public HostGroupDialog() {
        this((FwNetworkHostGroup)null);
    }

    public HostGroupDialog(FwNetworkHostGroup hostGroup) {
        super(Manager.getFrame(), res.getString("HostGroupDialog.dialogTitle"), true);
        Container pane = this.getContentPane();
        if (hostGroup == null) {
            hostGroup = new FwNetworkHostGroup();
            hostGroup.setFwHostContainer(new FwHostContainer());
        }
        this.hostGroup = hostGroup;
        pane.setLayout(new BorderLayout());
        pane.add((Component)this.getMainPanel(), "Center");
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            this.nameTF.setEditable(false);
            UIUtilities.setContainerStatus(this.hostContainerPanel, false);
            this.resetOKButton(false);
        }
        this.setSize(495, 361);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    private JPanel getMainPanel() {
        RestrictedPlainDocument groupNameDoc = new RestrictedPlainDocument(990);
        this.nameTF.setDocument(groupNameDoc);
        this.nameTF.setText(this.hostGroup.getName());
        this.hostContainerPanel = new HostContainerPanel(this.hostGroup.getFwHostContainer(), -1);
        this.namePanel.constrain(this.nameL, 0, 0, 1, 1, 17, 0, 0, 0, 0, 0);
        this.namePanel.constrain(this.nameTF, 1, 0, 1, 1, 17, 2, 0, 5, 0, 0);
        this.mainPanel.constrain(this.namePanel, 0, 0, 1, 1, 17, 2, 5, 5, 5, 5);
        this.mainPanel.constrain(this.hostContainerPanel, 0, 1, 1, 1, 18, 1, 5, 5, 5, 5);
        this.mainPanel.constrain(this.warning, 0, 2, 1, 1, 13, 2, 5, 5, 5, 5);
        this.mainPanel.constrain(this.getButtonPanel(), 0, 3, 1, 1, 16, 2, 0, 0, 0, 0);
        return this.mainPanel;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    public FwNetworkHostGroup getFwNetworkHostGroup() {
        return this.hostGroup;
    }

    @Override
    protected boolean isValidate() {
        String newName = this.nameTF.getText().trim();
        boolean isValid = true;
        String message = "";
        if (newName.length() == 0) {
            message = res.getString("HostGroupDialog.message.NameRequired");
            isValid = false;
        } else {
            try {
                if (this.isNameDuplicate(newName)) {
                    message = MessageFormat.format(res.getString("HostGroupDialog.message.HostGroupNameExists"), newName);
                    isValid = false;
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), res.getString("HostGroupDialog.title.ConsoleError"), 0);
                if (ex.needRelogin()) {
                    Manager.getFrame().showLoginPanel();
                }
                return false;
            }
        }
        if (!isValid) {
            JOptionPane.showMessageDialog(Manager.getFrame(), message, res.getString("HostGroupDialog.title.InvalidName"), 0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HostGroupDialog.this.nameTF.requestFocus();
                }
            });
            return false;
        }
        return this.validateHostGroupSize(this.hostContainerPanel.getAllHostObjects().size());
    }

    boolean validateHostGroupSize(int hostSize) {
        if (hostSize == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), res.getString("HostGroupDialog.message.SpecifyHost"), res.getString("HostGroupDialog.title.InvalidHostGroup"), 0);
            return false;
        }
        if (hostSize > ScmProperties.getHostGroupMaxCountAllowed()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), res.getString("HostGroupDialog.message.MaxSizeLimitationWarning", new Object[]{ScmProperties.getHostGroupMaxCountAllowed()}), res.getString("HostGroupDialog.title.InvalidHostGroup"), 0);
            return false;
        }
        return true;
    }

    protected boolean isNameDuplicate(String newName) throws ConsoleException {
        SemDomain currentDomain = DataobjectManager.getInstance().getCurrentSemDomain();
        ObjectPool objectPool = currentDomain.getObjectPool();
        FwNetworkHostGroupPool hostGroupPool = objectPool.getOptFwNetworkHostGroupPool();
        if (hostGroupPool == null) {
            return false;
        }
        String id = this.hostGroup.getId();
        int hostGroupCount = hostGroupPool.getObjReferenceCount();
        for (int i = 0; i < hostGroupCount; ++i) {
            String name;
            String type;
            ObjReference ref = hostGroupPool.getObjReference(i);
            if (ref == null || !"FwNetworkHostGroup".equals(type = ref.getTargetType())) continue;
            String targetId = ref.getTargetId();
            TopLevelObject hostGroupObj = DataobjectManager.getInstance().getObjectByGUID(type, targetId);
            if (hostGroupObj == null || (name = ((FwNetworkHostGroup)hostGroupObj).getName()) == null || !name.equals(newName)) continue;
            return id == null || !id.equals(targetId);
        }
        return false;
    }

    @Override
    protected void commit() {
        this.hostGroup.setName(this.nameTF.getText().trim());
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_host_groups";
    }
}

