/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.predefined;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.SignatureObject;
import com.sygate.scm.console.ui.policy.hi.predefined.HiPredefinedPanelInt;
import com.sygate.scm.console.ui.policy.hi.predefined.RestorePanel;
import com.sygate.scm.console.ui.util.CalendarButton;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.hi.library.AvSignatureDateCriteria;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SignaturePanel
extends JPanel {
    private static final long serialVersionUID = 3694676242778269511L;
    private static final String[] AGE_UNIT = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "SignaturePanel.combo.Days"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "SignaturePanel.combo.Weeks")};
    private static final long[] AGE_VALUE = new long[]{86400L, 604800L};
    private static final long[] AGE_LIMIT = new long[]{18200L, 2600L};
    private static final long DEFAULT_SIG_AGE = 7L * AGE_VALUE[0];
    private JRadioButton[] jrbDate = new JRadioButton[]{new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "SignaturePanel.radiobutton.EnsureSigFileDateIsNotEqualTo")), new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "SignaturePanel.radiobutton.EnsureSigFileDateIsEqualTo")), new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "SignaturePanel.radiobutton.EnsureSigFileDateIsBefore")), new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "SignaturePanel.radiobutton.EnsureSigFileDateIsAfter"))};
    private static final Integer[] COMPARING_VALUE = new Integer[]{AvSignatureDateCriteria.NOT_EQUAL, AvSignatureDateCriteria.EQUAL, AvSignatureDateCriteria.LESS_THAN, AvSignatureDateCriteria.GREATER_THAN};
    private JCheckBox jCbxAge = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "SignaturePanel.checkbox.EnsureSigFileLessThan"));
    private ButtonGroup buttongroupDate = new ButtonGroup();
    private JTextField jTFAge = new JTextField(5);
    private JComboBox<String> jCmbAge = new JComboBox<String>(AGE_UNIT);
    private JCheckBox jCbxDate = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "SignaturePanel.checkbox.EnsureSigFileDateIs"));
    private String timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePattern");
    private CalendarButton[] calendarButton = new CalendarButton[]{new CalendarButton(this.timePattern), new CalendarButton(this.timePattern), new CalendarButton(this.timePattern), new CalendarButton(this.timePattern)};
    private RestorePanel restorePanel;
    private HiPredefinedPanelInt parent;
    private SignatureObject sigObj;
    private String osType = "Windows";

    public SignaturePanel(HiPredefinedPanelInt parent, String title, String osType) {
        this.parent = parent;
        if (osType != null) {
            this.osType = osType;
        }
        this.initialize(title);
    }

    public boolean isDownloadFileChecked() {
        return this.restorePanel.isDownloadFileChecked();
    }

    public boolean isValidate() throws GUICheckException {
        boolean checkAvAge = this.jCbxAge.isSelected();
        if (checkAvAge) {
            String strAge = this.jTFAge.getText().trim();
            if (strAge.length() == 0) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "SignaturePanel.error.SigFileAge"), this.jTFAge);
            }
            long age = Long.parseLong(strAge);
            if (age == 0L) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "SignaturePanel.error.SigFileAgeGTZero"), this.jTFAge);
            }
        }
        return this.restorePanel.isValidate();
    }

    public void commit() {
        boolean checkAvAge = this.jCbxAge.isSelected();
        this.sigObj.setEnableAge(checkAvAge);
        if (checkAvAge) {
            String strAge = this.jTFAge.getText().trim();
            long age = Long.parseLong(strAge);
            int index = this.jCmbAge.getSelectedIndex();
            this.sigObj.setAge(age * AGE_VALUE[index]);
        }
        boolean checkDate = this.jCbxDate.isSelected();
        this.sigObj.setEnableDate(checkDate);
        this.sigObj.setDateCompare(COMPARING_VALUE[this.DateGetSelectedIndex()]);
        if (checkDate) {
            long fullDateTime = this.calendarButton[this.DateGetSelectedIndex()].getDateTime();
            this.sigObj.setDate(Utility.getDatePortion((long)fullDateTime));
            if (this.calendarButton[this.DateGetSelectedIndex()].hasTime) {
                this.sigObj.setTime(Utility.getTimePortion((long)fullDateTime));
            } else {
                this.sigObj.setTime(-1L);
            }
            this.sigObj.setHasTimeZone(this.calendarButton[this.DateGetSelectedIndex()].hasTimeZone);
        }
        this.restorePanel.commit();
        this.sigObj.setSigRstObj(this.restorePanel.getRestoreObject());
    }

    public void setObject(SignatureObject sigObj) {
        boolean hasTime;
        this.sigObj = sigObj;
        this.jCbxAge.setSelected(sigObj.isEnableAge());
        long age = sigObj.getAge();
        if (age == 0L) {
            age = DEFAULT_SIG_AGE;
        }
        int index = PolicyHandler.getIndexOfValueFromList(age, AGE_VALUE);
        this.jCmbAge.setSelectedIndex(index);
        this.jTFAge.setText(String.valueOf(age / AGE_VALUE[index]));
        this.jCbxDate.setSelected(sigObj.isEnableDate());
        index = PolicyHandler.getIndexOfValue(sigObj.getDateCompare(), COMPARING_VALUE);
        this.jrbDate[index].setSelected(true);
        boolean hasTimeZone = sigObj.getHasTimeZone();
        boolean bl = hasTime = sigObj.getTime() != -1L;
        if (hasTime) {
            hasTimeZone = true;
            this.calendarButton[0].setDateTime(sigObj.getDate() + sigObj.getTime(), true, hasTime, hasTimeZone);
            this.calendarButton[1].setDateTime(sigObj.getDate() + sigObj.getTime(), true, hasTime, hasTimeZone);
            this.calendarButton[2].setDateTime(sigObj.getDate() + sigObj.getTime(), true, hasTime, hasTimeZone);
            this.calendarButton[3].setDateTime(sigObj.getDate() + sigObj.getTime(), true, hasTime, hasTimeZone);
        } else {
            this.calendarButton[0].setDateTime(sigObj.getDate(), true, hasTime, hasTimeZone);
            this.calendarButton[1].setDateTime(sigObj.getDate(), true, hasTime, hasTimeZone);
            this.calendarButton[2].setDateTime(sigObj.getDate(), true, hasTime, hasTimeZone);
            this.calendarButton[3].setDateTime(sigObj.getDate(), true, hasTime, hasTimeZone);
        }
        this.restorePanel.setObject(sigObj.getSigRstObj());
        this.ageUnitChanged();
        this.ageStatusChanged();
        this.dateStatusChanged();
    }

    public SignatureObject getSignatureObject() {
        return this.sigObj;
    }

    private void initialize(String title) {
        this.restorePanel = new RestorePanel(this.osType);
        String[] labels = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "SignaturePanel.label.UpdateSigFile"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "SignaturePanel.label.DownloadSigFile")};
        this.restorePanel.setTitles(labels);
        this.restorePanel.setParent(this.parent);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(title));
        this.add((Component)this.getAgePanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.getDatePanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.restorePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JComponent getAgePanel() {
        this.jCbxAge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SignaturePanel.this.ageStatusChanged();
            }
        });
        this.jTFAge.setHorizontalAlignment(4);
        this.jCmbAge.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SignaturePanel.this.ageUnitChanged();
                }
            }
        });
        Box box = new Box(0);
        box.add(this.jCbxAge);
        box.add(this.jTFAge);
        box.add(Box.createHorizontalStrut(2));
        box.add(this.jCmbAge);
        box.add(Box.createHorizontalStrut(2));
        return box;
    }

    private JComponent getDatePanel() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SignaturePanel.this.dateStatusChanged();
            }
        };
        this.jCbxDate.addActionListener(al);
        this.jCbxDate.setHorizontalAlignment(4);
        JPanel panel1 = new JPanel(new GridBagLayout());
        panel1.add((Component)this.jCbxDate, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel2 = new JPanel(new GridBagLayout());
        for (int i = 0; i < 4; ++i) {
            this.jrbDate[i].addActionListener(al);
            this.buttongroupDate.add(this.jrbDate[i]);
            panel2.add((Component)this.jrbDate[i], new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 3, 0), 0, 0));
            panel2.add((Component)this.calendarButton[i], new GridBagConstraints(1, i, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 5), 0, 0));
        }
        panel1.add((Component)panel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        return panel1;
    }

    private void ageStatusChanged() {
        boolean enableAvAge = this.jCbxAge.isSelected();
        this.jTFAge.setEnabled(enableAvAge);
        this.jCmbAge.setEnabled(enableAvAge);
        boolean enable = this.jCbxAge.isSelected() || this.jCbxDate.isSelected();
        this.restorePanel.setEnableStatus(enable);
        this.parent.updateRestoreCondition();
    }

    private void ageUnitChanged() {
        String ageStr = this.jTFAge.getText().trim();
        long ageLimit = AGE_LIMIT[this.jCmbAge.getSelectedIndex()];
        this.jTFAge.setDocument(new NumberPlainDocument(ageLimit, true));
        long time = ageStr.length() == 0 ? 0L : Long.parseLong(ageStr);
        this.jTFAge.setText(time <= ageLimit ? ageStr : String.valueOf(ageLimit));
    }

    private void dateStatusChanged() {
        boolean enableAvDate = this.jCbxDate.isSelected();
        for (int i = 0; i < 4; ++i) {
            this.jrbDate[i].setEnabled(enableAvDate);
            this.calendarButton[i].setEnabled(enableAvDate && i == this.DateGetSelectedIndex());
        }
        boolean enable = this.jCbxAge.isSelected() || this.jCbxDate.isSelected();
        this.restorePanel.setEnableStatus(enable);
        this.parent.updateRestoreCondition();
    }

    private int DateGetSelectedIndex() {
        for (int i = 0; i < 4; ++i) {
            if (!this.jrbDate[i].isSelected()) continue;
            return i;
        }
        return 0;
    }
}

