/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.predefined;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.OSPanel;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.HIUtility;
import com.sygate.scm.console.ui.policy.hi.logicobject.ServicePackInfoObject;
import com.sygate.scm.util.IntegerSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ServicePackSettingPanel
extends JPanel {
    private static final long serialVersionUID = 5764860555634135982L;
    private JTextField jTFPack = new JTextField(5);
    private OSPanel osPane = new OSPanel("", 1);
    private ServicePackInfoObject serviceInfo;

    public ServicePackSettingPanel() {
        this.initialize();
    }

    public void setObject(ServicePackInfoObject serviceInfo) {
        this.serviceInfo = serviceInfo;
        this.updatePanel();
    }

    public boolean isValidate() throws GUICheckException {
        if (this.jTFPack.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "ServicePackSettingPanel.error.SPNumber"), this.jTFPack);
        }
        IntegerSet intSet = this.serviceInfo.getOSObject().getOSSet();
        if (intSet == null || intSet.toArray() == null) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "ServicePackSettingPanel.error.SelectOS"), this.jTFPack);
        }
        return true;
    }

    public void commit() {
        this.serviceInfo.setServiceNumber(this.jTFPack.getText().trim());
        this.serviceInfo.setOSObject(this.osPane.getOSObject());
    }

    public ServicePackInfoObject getServicePackInfo() {
        return this.serviceInfo;
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTopPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        Dimension p = this.osPane.getPreferredSize();
        this.osPane.setPreferredSize(new Dimension(p.width, 300));
        this.add((Component)this.osPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private JComponent getTopPanel() {
        this.jTFPack.setDocument(HIUtility.createServicePackNumberDocument(this.jTFPack, 2));
        JPanel pane = new JPanel(new GridBagLayout());
        pane.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "ServicePackSettingPanel.label.SPNumber")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 2), 0, 0));
        pane.add((Component)this.jTFPack, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 2), 0, 0));
        return pane;
    }

    private void updatePanel() {
        this.jTFPack.setText(this.serviceInfo.getServiceNumber());
        this.osPane.setObject(this.serviceInfo.getOSObject());
    }
}

