/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.predefined;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.RestoreObject;
import com.sygate.scm.console.ui.policy.hi.predefined.HiPredefinedPanelInt;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.URLUtility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RestorePanel
extends JPanel {
    private static final long serialVersionUID = 147081681178333901L;
    private JCheckBox jCbxEnable = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "RestorePanel.checkbox.InstallIfNotInstalled"));
    private JCheckBox jCbxDownload = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "RestorePanel.checkbox.DownloadPkg"));
    private JLabel jLDownload = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "RestorePanel.label.DownloadURL"));
    private JTextField jTFDownload = new JTextField(20);
    private JTextField jTFExecute = new JTextField(20);
    private JPanel innerPanel;
    private HiPredefinedPanelInt parent;
    private RestoreObject restoreObj;
    private String osType = "Windows";

    public RestorePanel(String osType) {
        this.initialize();
        if (osType != null) {
            this.osType = osType;
        }
    }

    public void commit() {
        this.restoreObj.setEnable(this.jCbxEnable.isEnabled() && this.jCbxEnable.isSelected());
        boolean enableDownload = this.jCbxDownload.isSelected() && this.jCbxDownload.isEnabled();
        this.restoreObj.setEnableDownload(enableDownload);
        String dwURL = this.jTFDownload.getText().trim();
        if (dwURL != null && dwURL.trim().length() != 0 && this.osType.equals("Mac") && dwURL.contains("ftp") && dwURL.contains("$")) {
            dwURL = dwURL.replace("$", "\\$");
        }
        this.restoreObj.setDownloadURL(dwURL);
        this.restoreObj.setEnableExe(true);
        this.restoreObj.setCmd(this.jTFExecute.getText().trim());
    }

    private void initialize() {
        this.jCbxEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestorePanel.this.setEnableStatus();
                if (RestorePanel.this.parent != null) {
                    RestorePanel.this.parent.updateRestoreCondition();
                    if (RestorePanel.this.parent instanceof JPanel) {
                        ((JPanel)((Object)RestorePanel.this.parent)).repaint();
                    }
                }
            }
        });
        this.innerPanel = this.getInnerPanel();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jCbxEnable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.innerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
    }

    private JPanel getInnerPanel() {
        this.jCbxDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestorePanel.this.setDownloadStatus();
                if (RestorePanel.this.parent != null) {
                    RestorePanel.this.parent.updateRestoreCondition();
                }
            }
        });
        this.jTFDownload.setDocument(new RestrictedPlainDocument(1023));
        this.jTFExecute.setDocument(new RestrictedPlainDocument(512));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(5, 16, 5, 5)));
        panel.add((Component)this.jCbxDownload, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLDownload, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 0, 0), 0, 0));
        panel.add((Component)this.jTFDownload, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "RestorePanel.label.ExecCmd")), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 6, 0, 0), 0, 0));
        panel.add((Component)this.jTFExecute, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 8, 0, 0), 0, 0));
        return panel;
    }

    private void setDownloadStatus() {
        boolean isChecked = this.jCbxDownload.isEnabled() && this.jCbxDownload.isSelected() && this.jCbxEnable.isEnabled() && this.jCbxEnable.isSelected();
        this.jTFDownload.setEnabled(isChecked);
        this.jLDownload.setEnabled(isChecked);
    }

    private void updatePanel() {
        this.jCbxEnable.setSelected(this.restoreObj.getEnable());
        this.jCbxDownload.setSelected(this.restoreObj.getEnableDownload());
        String downloadURL = this.restoreObj.getDownloadURL();
        if (downloadURL != null && downloadURL.trim().length() != 0 && this.osType.equals("Mac") && downloadURL.contains("ftp") && downloadURL.contains("$")) {
            downloadURL = downloadURL.replace("\\", "");
        }
        this.jTFDownload.setText(downloadURL);
        this.jTFExecute.setText(this.restoreObj.getCmd());
        this.setEnableStatus();
    }

    private boolean validateURL(String urlStr) {
        if ("Mac".equalsIgnoreCase(this.osType)) {
            return URLUtility.isValidURLForMac((String)urlStr);
        }
        return URLUtility.isValidURLForWindows((String)urlStr);
    }

    private void setEnableStatus() {
        boolean isEnabled = this.jCbxEnable.isEnabled() && this.jCbxEnable.isSelected();
        UIUtilities.setContainerStatus(this.innerPanel, isEnabled);
        this.setDownloadStatus();
    }

    public void setObject(RestoreObject restoreObj) {
        this.restoreObj = restoreObj;
        this.updatePanel();
    }

    public boolean isValidate() throws GUICheckException {
        boolean enableDownload = this.jCbxDownload.isSelected() && this.jCbxDownload.isEnabled();
        String dwURL = this.jTFDownload.getText().trim();
        if (enableDownload && dwURL.length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "RestorePanel.error.EmptyDloadURL"), this.jTFDownload);
        }
        if (enableDownload && !this.validateURL(dwURL)) {
            throw new GUICheckException(MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "RestorePanel.error.InvalidURL"), dwURL), this.jTFDownload);
        }
        String cmd = this.jTFExecute.getText().trim();
        if (this.jTFExecute.isEnabled()) {
            if (cmd.length() == 0) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "RestorePanel.error.EmptyExecCmd"), this.jTFExecute);
            }
            if (!enableDownload && (cmd.equals("%F%") || cmd.equals("%f%"))) {
                throw new GUICheckException(MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "RestorePanel.error.InvalidExec"), this.jCbxDownload.getText().toLowerCase()), this.jTFExecute);
            }
        }
        return true;
    }

    public void setTitles(String[] labels) {
        this.jCbxEnable.setText(labels[0]);
        this.jCbxDownload.setText(labels[1]);
    }

    public RestoreObject getRestoreObject() {
        return this.restoreObj;
    }

    public void setParent(HiPredefinedPanelInt p) {
        this.parent = p;
    }

    public void setEnableStatus(boolean isEnabled) {
        this.jCbxEnable.setEnabled(isEnabled);
        this.setEnableStatus();
    }

    public boolean isDownloadFileChecked() {
        return this.jCbxDownload.isEnabled() && this.jCbxDownload.isSelected();
    }
}

