/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.predefined;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.RestoreConditionObject;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RestoreConditionPanel
extends JPanel {
    private static final long serialVersionUID = 2234582665363665471L;
    private static final String[] TIMEUNIT_DESC = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "RestoreConditionPanel.combo.Minutes"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "RestoreConditionPanel.combo.Hours"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "RestoreConditionPanel.combo.Days")};
    private static final long[] TIME_UNIT = new long[]{60L, 3600L, 86400L};
    private static final long[] MAXIMUM_TIME = new long[]{40320L, 672L, 28L};
    private static final long[] MINIMUM_TIME = new long[]{5L, 1L, 1L};
    JCheckBox jCbxRestore = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "RestoreConditionPanel.checkbox.IfFailWait"));
    JTextField jTFTime = new JTextField(5);
    JComboBox<String> jCmbTime = new JComboBox<String>(TIMEUNIT_DESC);
    JCheckBox jCbxCancel = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "RestoreConditionPanel.checkbox.AllowCancelDownload"));
    JCheckBox jCbxPass = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "RestoreConditionPanel.checkbox.AllowHICheckPass"));
    private RestoreConditionObject restoreCondiObj;

    public RestoreConditionPanel() {
        this.initialize();
        this.restoreStatusChanged();
        this.timeUnitChanged();
    }

    public boolean getCancelable() {
        return this.jCbxCancel.isSelected();
    }

    public void setCancelable(boolean cancel) {
        this.jCbxCancel.setSelected(cancel);
    }

    public void setObject(RestoreConditionObject restoreCondiObj) {
        this.restoreCondiObj = restoreCondiObj;
        this.updatePanel();
    }

    public void enableRestoration(boolean isEnable) {
        this.jCbxRestore.setEnabled(isEnable);
        this.restoreStatusChanged();
        this.jCbxCancel.setEnabled(isEnable);
    }

    public boolean isValidate() throws GUICheckException {
        if (this.jCbxRestore.isSelected()) {
            String strWait = this.jTFTime.getText().trim();
            long time = -1L;
            try {
                time = Long.parseLong(strWait);
            }
            catch (NumberFormatException nfe) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "RestoreConditionPanel.error.InvalidTime"), this.jTFTime);
            }
            if (time < MINIMUM_TIME[this.jCmbTime.getSelectedIndex()] || time > MAXIMUM_TIME[this.jCmbTime.getSelectedIndex()]) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "RestoreConditionPanel.error.InvalidTime"), this.jTFTime);
            }
        }
        return true;
    }

    public void commit() {
        boolean noWait = !this.jCbxRestore.isSelected();
        this.restoreCondiObj.setEnableDontWait(noWait);
        String strWait = this.jTFTime.getText().trim();
        int index = this.jCmbTime.getSelectedIndex();
        this.restoreCondiObj.setWaitTime(Long.parseLong(strWait) * TIME_UNIT[index]);
    }

    public RestoreConditionObject getRestoreConditionObject() {
        return this.restoreCondiObj;
    }

    public void setOptModeValue(String mode) {
        this.jCbxPass.setSelected(mode != null && mode.equals("TEST"));
    }

    public String getOptModeValue() {
        return this.jCbxPass.isSelected() ? "TEST" : "NORMAL";
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "West");
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getTimeLine(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jCbxCancel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.jCbxPass, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private Box getTimeLine() {
        this.jCbxRestore.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 565004659634770352L;

            @Override
            public void actionPerformed(ActionEvent e) {
                RestoreConditionPanel.this.restoreStatusChanged();
            }
        });
        this.jTFTime.setHorizontalAlignment(4);
        this.jCmbTime.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RestoreConditionPanel.this.timeUnitChanged();
                }
            }
        });
        Box panel = Box.createHorizontalBox();
        panel.add(this.jCbxRestore);
        panel.add(this.jTFTime);
        panel.add(Box.createHorizontalStrut(2));
        panel.add(this.jCmbTime);
        panel.add(Box.createHorizontalStrut(4));
        return panel;
    }

    private void restoreStatusChanged() {
        boolean isEnabled = this.jCbxRestore.isEnabled() && this.jCbxRestore.isSelected();
        this.jTFTime.setEnabled(isEnabled);
        this.jCmbTime.setEnabled(isEnabled);
    }

    private void timeUnitChanged() {
        int index = this.jCmbTime.getSelectedIndex();
        long minTime = MINIMUM_TIME[index];
        long maxTime = MAXIMUM_TIME[index];
        String timeStr = this.jTFTime.getText().trim();
        long time = timeStr.length() == 0 ? minTime : Long.parseLong(timeStr);
        this.jTFTime.setDocument(new NumberPlainDocument(maxTime, true));
        this.jTFTime.setText(time >= minTime && time <= maxTime ? Long.toString(time) : String.valueOf(minTime));
    }

    private void updatePanel() {
        this.jCbxRestore.setSelected(!this.restoreCondiObj.getEnableDontWait());
        boolean isWait = !this.restoreCondiObj.getEnableDontWait();
        this.jTFTime.setEnabled(isWait);
        this.jCmbTime.setEnabled(isWait);
        long waitTime = this.restoreCondiObj.getWaitTime();
        int index = PolicyHandler.getIndexOfValueFromList(waitTime, TIME_UNIT);
        this.jCmbTime.setSelectedIndex(index);
        this.jTFTime.setText((waitTime /= TIME_UNIT[index]) == 0L ? String.valueOf(MINIMUM_TIME[index]) : String.valueOf(waitTime));
    }
}

