/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.predefined;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_EnforceAsw;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_EnforceAv;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_EnforceFw;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_EnforcePatchObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_EnforceServicePackObject;
import com.sygate.scm.console.ui.policy.hi.predefined.AntiSpywarePanel;
import com.sygate.scm.console.ui.policy.hi.predefined.AntiVirusPanel;
import com.sygate.scm.console.ui.policy.hi.predefined.FirewallPanel;
import com.sygate.scm.console.ui.policy.hi.predefined.HiPredefinedType;
import com.sygate.scm.console.ui.policy.hi.predefined.PatchPanel;
import com.sygate.scm.console.ui.policy.hi.predefined.ServicePackPanel;
import com.sygate.scm.console.util.ConsoleException;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JPanel;

public class PredefinedType {
    public static final int CUSTOM = 0;
    public static final int ANTI_VIRUS = 1;
    public static final int PATCH = 2;
    public static final int SERVICE_PACK = 3;
    public static final int FIREWALL = 4;
    public static final int VPN_CLIENT = 5;
    public static final int ANTI_SPYWARE = 6;
    public static final int HI_TEMPLATE = 7;
    private static PredefinedType[] TYPES = new PredefinedType[]{new PredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.AVEnforcement"), 1), new PredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.ASEnforcement"), 6), new PredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.FWEnforcement"), 4), new PredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.PatchEnforcement"), 2), new PredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.SPEnforcement"), 3)};
    private static PredefinedType[] LINUX_MAC_TYPES = new PredefinedType[]{new PredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.AVEnforcement"), 1), new PredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.FWEnforcement"), 4)};
    private static final HiPredefinedType[] AV_TYPES = new HiPredefinedType[]{new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeAnyAV"), "AV_ANY"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeMcAfee"), "AV_MCAFEE"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeNAV"), "AV_NORTON"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeTrend"), "AV_PCCILLIN"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeTrendCorp"), "AV_OFFICESCAN"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeETrustAV"), "AV_INOCULATEIT"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypePandaAV"), "AV_PANDA"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeMcAfeeCorp"), "AV_MCAFEE_CORP"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeSEP"), "AV_NORTON_CORP_SEP"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeSophos"), "AV_SOPHOS")};
    private static final HiPredefinedType[] MAC_AV_TYPES = new HiPredefinedType[]{new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeAnyAV"), "AV_ANY"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeNAV"), "AV_NORTON"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeSEP"), "AV_NORTON_CORP_SEP"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeSAV"), "AV_SYMANTEC")};
    private static final HiPredefinedType[] ASW_TYPES = new HiPredefinedType[]{new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeAnyAS"), "AS_ANY"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeSygateAdAware"), "AS_SYGATE_ADAWARE"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeLavasoftAdAware"), "AS_LAVASOFT_ADAWARE"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeNAS"), "AS_NORTON")};
    private static final HiPredefinedType[] FW_TYPES = new HiPredefinedType[]{new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeAnyFW"), "FW_ANY"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeISSRealsecure"), "FW_ISS_REALSECURE"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeMcAfeeFW"), "FW_MCAFEE"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeMSICF"), "FW_MICROSOFT_ICF"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeNPF"), "FW_NORTON"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeSPA"), "FW_SSA_FIREWALL"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeSCS"), "FW_SSA_FIREWALL"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeZoneAlarm"), "FW_ZONEALARM"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeCheckPoint"), "FW_CHECKPOINT")};
    private static final HiPredefinedType[] MAC_FW_TYPES = new HiPredefinedType[]{new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeAnyFW"), "FW_ANY")};
    private static final HiPredefinedType[] HI_OS_TYPES = new HiPredefinedType[]{new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.OSType.Windows"), "Windows"), new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.OSType.MAC"), "Mac")};
    private static final HiPredefinedType[] HI_14_PLUS_OS_TYPES = new HiPredefinedType[]{new HiPredefinedType(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.OSType.Windows"), "Windows")};
    private int type;
    private String name;
    private JPanel panel;
    private ConfigObject param = null;
    private String funcName = null;

    public static PredefinedType[] getTYPES() {
        return (PredefinedType[])TYPES.clone();
    }

    public static PredefinedType getTYPESByIndex(int index) {
        int length = TYPES.length;
        if (index < 0 || index > length - 1) {
            return null;
        }
        return TYPES[index];
    }

    public static PredefinedType[] getLINUX_MAC_TYPES() {
        return (PredefinedType[])LINUX_MAC_TYPES.clone();
    }

    public static HiPredefinedType[] getAvTypes() {
        return (HiPredefinedType[])AV_TYPES.clone();
    }

    public static HiPredefinedType[] getMacAvTypes() {
        return (HiPredefinedType[])MAC_AV_TYPES.clone();
    }

    public static HiPredefinedType[] getAswTypes() {
        return (HiPredefinedType[])ASW_TYPES.clone();
    }

    public static HiPredefinedType[] getFwTypes() {
        return (HiPredefinedType[])FW_TYPES.clone();
    }

    public static HiPredefinedType[] getMacFwTypes() {
        return (HiPredefinedType[])MAC_FW_TYPES.clone();
    }

    public static HiPredefinedType[] getHiOsTypes() {
        return (HiPredefinedType[])HI_OS_TYPES.clone();
    }

    public static HiPredefinedType[] getHi14PlusOsTypes() {
        return (HiPredefinedType[])HI_14_PLUS_OS_TYPES.clone();
    }

    public PredefinedType(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            switch (this.type) {
                case 1: {
                    this.panel = new AntiVirusPanel();
                    break;
                }
                case 2: {
                    this.panel = new PatchPanel();
                    break;
                }
                case 3: {
                    this.panel = new ServicePackPanel();
                    break;
                }
                case 4: {
                    this.panel = new FirewallPanel();
                    break;
                }
                case 5: {
                    this.panel = new JPanel();
                    break;
                }
                case 0: {
                    this.panel = new JPanel();
                    break;
                }
                case 6: {
                    this.panel = new AntiSpywarePanel();
                    break;
                }
                default: {
                    this.panel = new JPanel();
                }
            }
        }
        return this.panel;
    }

    public byte[] getParameter() throws ConsoleException, IOException, ValidationException {
        if (this.param == null) {
            switch (this.type) {
                case 1: {
                    this.param = new HiParam_EnforceAv().getSchemaObject();
                    break;
                }
                case 3: {
                    this.param = new HiParam_EnforceServicePackObject().getSchemaObject();
                    break;
                }
                case 2: {
                    this.param = new HiParam_EnforcePatchObject().getSchemaObject();
                    break;
                }
                case 4: {
                    this.param = new HiParam_EnforceFw().getSchemaObject();
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    this.param = new HiParam_EnforceAsw().getSchemaObject();
                    break;
                }
            }
        }
        ConfigObject newObj = PolicyHandler.getCopyOfObj(this.param);
        newObj.init();
        return newObj.getBytes();
    }

    public String getFuncName() {
        if (this.funcName == null) {
            switch (this.type) {
                case 1: {
                    this.funcName = "EnforceAv";
                    break;
                }
                case 3: {
                    this.funcName = "EnforceServicePack";
                    break;
                }
                case 2: {
                    this.funcName = "EnforcePatch";
                    break;
                }
                case 4: {
                    this.funcName = "EnforceFw";
                    break;
                }
                case 5: {
                    this.funcName = "";
                    break;
                }
                case 6: {
                    this.funcName = "EnforceAsw";
                    break;
                }
                default: {
                    this.funcName = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.53");
                }
            }
        }
        return this.funcName;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    static {
        Arrays.sort(AV_TYPES);
        Arrays.sort(ASW_TYPES);
        Arrays.sort(FW_TYPES);
    }
}

