/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.predefined;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.logicobject.HiRequirementObject;
import com.sygate.scm.console.logicobject.HostIntegrityObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.predefined.AntiSpywarePanel;
import com.sygate.scm.console.ui.policy.hi.predefined.AntiVirusPanel;
import com.sygate.scm.console.ui.policy.hi.predefined.FirewallPanel;
import com.sygate.scm.console.ui.policy.hi.predefined.HiPredefinedPanelInt;
import com.sygate.scm.console.ui.policy.hi.predefined.PatchPanel;
import com.sygate.scm.console.ui.policy.hi.predefined.ServicePackPanel;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class PredefinedRequirementDlg
extends DialogBase {
    private static final long serialVersionUID = 2495486553302423889L;
    private HiRequirementObject reqObj;
    private HostIntegrityObject hiObj;
    private HiCALLObject hiCallObj;
    private JTextField jTFName = new JTextField(50);
    private HiPredefinedPanelInt typePanel;
    private JPanel upperPane;
    private JScrollPane scrollPane;
    private JPanel contentPane;

    public PredefinedRequirementDlg(HiRequirementObject reqObj, HostIntegrityObject hiObj, boolean isReadonly) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedRequirementDlg.title.PreDefHIReq"), true);
        try {
            this.reqObj = reqObj;
            this.hiObj = hiObj;
            this.hiCallObj = reqObj.getPredefinedCallObj();
            this.initialize();
            this.setObject();
            if (isReadonly) {
                UIUtilities.setContainerStatus(this.upperPane, false);
                this.resetOKButton(false);
            }
            this.pack();
            UiUtilities.centerComponent((Component)this);
            this.setVisible(true);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedRequirementDlg.title.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    protected boolean isValidate() {
        String name = this.jTFName.getText().trim();
        if (name.length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedRequirementDlg.error.EmptyName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedRequirementDlg.title.Error"), 0);
            this.jTFName.requestFocusInWindow();
            return false;
        }
        if (!this.hiObj.checkRequirementName(name, this.reqObj)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedRequirementDlg.error.NameInUse"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedRequirementDlg.title.Error"), 0);
            this.jTFName.requestFocusInWindow();
            return false;
        }
        try {
            this.typePanel.isValidate();
        }
        catch (GUICheckException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedRequirementDlg.title.Error"), 0);
            ex.getErrorComponent().requestFocusInWindow();
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        try {
            this.reqObj.setName(this.jTFName.getText().trim());
            this.typePanel.commit();
            this.hiCallObj.setParameter(this.typePanel.getParameter());
            this.reqObj.setCancelable(this.typePanel.getCancelable());
            this.reqObj.setOptModeValue(this.typePanel.getOptModeValue());
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedRequirementDlg.title.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void initialize() {
        this.scrollPane = new JScrollPane(20, 31);
        this.contentPane = new JPanel(new BorderLayout());
        this.upperPane = new JPanel(new BorderLayout());
        this.upperPane.add((Component)this.getNamePanel(), "North");
        this.upperPane.add((Component)this.getPredefinedTypePanel(), "Center");
        this.contentPane.add((Component)this.upperPane, "Center");
        this.contentPane.add((Component)this.getButtonPanel(), "South");
        this.contentPane.add(Box.createHorizontalStrut(10), "East");
        this.scrollPane.setViewportView(this.contentPane);
        this.setContentPane(this.scrollPane);
    }

    private JPanel getNamePanel() {
        RestrictedPlainDocument doc = new RestrictedPlainDocument(256);
        doc.setValidator("\"/\\*?<>|:", false);
        this.jTFName.setDocument(doc);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.fill = 0;
        cons.anchor = 17;
        cons.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedRequirementDlg.label.Name")), cons);
        cons.gridx = 1;
        cons.gridy = 0;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        cons.fill = 2;
        cons.anchor = 10;
        cons.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.jTFName, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.fill = 0;
        cons.anchor = 17;
        cons.insets = new Insets(5, 5, 0, 0);
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedRequirementDlg.label.ClientType")), cons);
        cons.gridx = 1;
        cons.gridy = 1;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        cons.fill = 2;
        cons.anchor = 10;
        cons.insets = new Insets(5, 10, 0, 0);
        JTextField clientTypeTF = new JTextField(50);
        clientTypeTF.setText(this.getClientTypeStr());
        clientTypeTF.setEditable(false);
        panel.add((Component)clientTypeTF, cons);
        return panel;
    }

    private JPanel getPredefinedTypePanel() {
        String funcName = this.hiCallObj.getFuncName();
        String clientType = this.reqObj.getClientTypeString();
        this.typePanel = funcName.equals("EnforceAv") ? new AntiVirusPanel(clientType) : (funcName.equals("EnforceAsw") ? new AntiSpywarePanel(clientType) : (funcName.equals("EnforceFw") ? new FirewallPanel(clientType) : (funcName.equals("EnforcePatch") ? new PatchPanel() : new ServicePackPanel())));
        return (JPanel)((Object)this.typePanel);
    }

    private void setObject() {
        this.jTFName.setText(this.reqObj.getName());
        this.typePanel.setObject(this.hiCallObj.getParameter(), this.reqObj.getCancelable(), this.reqObj.getOptModeValue());
    }

    private String getClientTypeStr() {
        String ret = "Windows";
        if (this.reqObj != null) {
            ret = this.reqObj.getClientTypeDisplayValue();
        }
        return ret;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        String funcName = this.hiCallObj.getFuncName();
        if (funcName.equals("EnforceAv")) {
            return "sesm_policies_dialog_hi_requirements_add_predefined_hi_requirement_av_enforcement";
        }
        if (funcName.equals("EnforceAsw")) {
            return "sesm_policies_dialog_hi_requirements_add_predefined_hi_requirement_asw_enforcement";
        }
        if (funcName.equals("EnforceFw")) {
            return "sesm_policies_dialog_hi_requirements_add_predefined_hi_requirement_firewall_enforcement";
        }
        if (funcName.equals("EnforcePatch")) {
            return "sesm_policies_dialog_hi_requirements_add_predefined_hi_requirement_patch_enforcement";
        }
        if (funcName.equals("EnforceServicePack")) {
            return "sesm_policies_dialog_hi_requirements_add_predefined_hi_requirement_service_pack_enforcement";
        }
        return null;
    }
}

