/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.predefined;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.OSPanel;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.PatchInfoObject;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.util.IntegerSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PatchSettingPanel
extends JPanel {
    private static final long serialVersionUID = 8270083684792480629L;
    private static final String TITLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PatchSettingPanel.title.ApplyPatchOnOS");
    private JTextField jTFName = new JTextField(20);
    private OSPanel osPane = new OSPanel(TITLE, 0);
    private PatchInfoObject patchInfo;

    public PatchSettingPanel() {
        this.initialize();
    }

    public void setObject(PatchInfoObject patchInfo) {
        this.patchInfo = patchInfo;
        this.updatePanel();
    }

    public boolean isValidate() throws GUICheckException {
        if (this.jTFName.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PatchSettingPanel.error.PatchName"), this.jTFName);
        }
        IntegerSet intSet = this.patchInfo.getOSObject().getOSSet();
        if (intSet == null || intSet.toArray() == null) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PatchSettingPanel.error.SelectOS"), this.jTFName);
        }
        return true;
    }

    public void commit() {
        this.patchInfo.setPatchName(this.jTFName.getText().trim());
        this.patchInfo.setOSObject(this.osPane.getOSObject());
    }

    public PatchInfoObject getPatchInfo() {
        return this.patchInfo;
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTopPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        Dimension p = this.osPane.getPreferredSize();
        this.osPane.setPreferredSize(new Dimension(p.width, 300));
        this.add((Component)this.osPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private JPanel getTopPanel() {
        this.jTFName.setDocument(new RestrictedPlainDocument(128));
        JPanel pane = new JPanel(new GridBagLayout());
        pane.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PatchSettingPanel.label.PatchName")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 2), 0, 0));
        pane.add((Component)this.jTFName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 2), 0, 0));
        pane.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PatchSettingPanel.label.ThatMustBeInstalled")), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 0, 2), 0, 0));
        return pane;
    }

    private void updatePanel() {
        this.jTFName.setText(this.patchInfo.getPatchName());
        this.osPane.setObject(this.patchInfo.getOSObject());
    }
}

