/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.predefined;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiParam_EnforcePatchObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.RestoreObject;
import com.sygate.scm.console.ui.policy.hi.predefined.PatchSettingPanel;
import com.sygate.scm.console.ui.policy.hi.predefined.PredefinedPanelBase;
import com.sygate.scm.console.ui.policy.hi.predefined.RestorePanel;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class PatchPanel
extends PredefinedPanelBase {
    private static final long serialVersionUID = 1978652152602964962L;
    private PatchSettingPanel patchPanel = new PatchSettingPanel();
    private JRadioButton jRBUserContext = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PatchPanel.radio.UserContext"));
    private JRadioButton jRBSysContext = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PatchPanel.radio.SysContext"));
    private HiParam_EnforcePatchObject enforcePT = new HiParam_EnforcePatchObject();

    public PatchPanel() {
        super("Windows");
        this.initialize();
    }

    public PatchPanel(String clientType) {
        super(clientType);
        this.initialize();
    }

    @Override
    public boolean isValidate() throws GUICheckException {
        return this.patchPanel.isValidate() && super.isValidate() && this.restoreCondPanel.isValidate();
    }

    @Override
    public void commit() {
        this.patchPanel.commit();
        this.enforcePT.setPatchInfo(this.patchPanel.getPatchInfo());
        this.restorePanel.commit();
        RestoreObject resObj = this.restorePanel.getRestoreObject();
        resObj.setUserContextForEnforcePathInstall(this.jRBSysContext.isSelected());
        this.enforcePT.setExeRestoreObject(resObj);
        this.restoreCondPanel.commit();
        this.enforcePT.setRestoreConditionObject(this.restoreCondPanel.getRestoreConditionObject());
    }

    @Override
    public ConfigObject getParameter() {
        return this.enforcePT.getSchemaObject();
    }

    @Override
    protected void setParameter(UnknownContent parameter) throws ConsoleException {
        this.enforcePT.setParameter(parameter);
    }

    @Override
    protected void updatePanel(boolean isCancelable, String mode) {
        RestoreObject restore = this.enforcePT.getExeRestoreObject();
        this.restorePanel.setObject(restore);
        this.restoreCondPanel.setObject(this.enforcePT.getRestoreConditionObject());
        this.patchPanel.setObject(this.enforcePT.getPatchInfo());
        this.restoreCondPanel.setCancelable(isCancelable);
        this.restoreCondPanel.setOptModeValue(mode);
        boolean systemContext = restore.isUserContextSystemForEnforcePathInstall();
        this.jRBSysContext.setSelected(systemContext);
        this.jRBUserContext.setSelected(!systemContext);
        this.updateRestoreCondition();
    }

    private void initialize() {
        this.restorePanel = this.createRestorePanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.add((Component)this.patchPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.restorePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.getUserContextPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.restoreCondPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    private RestorePanel createRestorePanel() {
        RestorePanel panel = new RestorePanel(this.getClientType());
        String[] labels = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PatchPanel.label.InstallPatch"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PatchPanel.label.DownloadPkg")};
        panel.setTitles(labels);
        panel.setParent(this);
        return panel;
    }

    private JComponent getUserContextPanel() {
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.jRBSysContext);
        group1.add(this.jRBUserContext);
        Box box = new Box(0);
        String labelText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PatchPanel.title.RunProgram");
        TitledBorder border = BorderFactory.createTitledBorder(labelText);
        if (border.getTitleFont() != null) {
            border.setTitleFont(border.getTitleFont().deriveFont(0));
        } else {
            border.setTitleFont(this.getFont());
        }
        box.setBorder(border);
        box.add(Box.createHorizontalStrut(20));
        box.add(this.jRBSysContext);
        box.add(Box.createHorizontalStrut(40));
        box.add(this.jRBUserContext);
        box.add(Box.createGlue());
        return box;
    }
}

