/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.predefined;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiExeObject;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExecutePanel
extends JPanel {
    private static final long serialVersionUID = -3017016555160586638L;
    private final JCheckBox jCbxExe = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "ExecutePanel.checkbox.StartIfNotRunning"));
    private final JLabel jLExe = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "ExecutePanel.label.ExecCmd"));
    private final JTextField jTFExe = new JTextField(20);
    private HiExeObject runObj;

    public ExecutePanel() {
        this.initialize();
    }

    private void initialize() {
        this.jCbxExe.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -4032822769066489180L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecutePanel.this.setEnableStatus();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jCbxExe, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.getInnerPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
    }

    private JPanel getInnerPanel() {
        this.jTFExe.setDocument(new RestrictedPlainDocument(512));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(15, 22, 5, 5)));
        panel.add((Component)this.jLExe, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFExe, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public void setTitles(String[] labels) {
        this.jCbxExe.setText(labels[0]);
    }

    private void updatePanel() {
        this.jCbxExe.setSelected(this.runObj.getEnableExe());
        this.jTFExe.setText(this.runObj.getCmd());
        this.setEnableStatus();
    }

    private void setEnableStatus() {
        boolean isEnabled = this.jCbxExe.isEnabled() && this.jCbxExe.isSelected();
        this.jLExe.setEnabled(isEnabled);
        this.jTFExe.setEnabled(isEnabled);
    }

    public void setEnableStatus(boolean isEnabled) {
        this.jCbxExe.setEnabled(isEnabled);
        this.setEnableStatus();
    }

    public void setObject(HiExeObject runObj) {
        this.runObj = runObj;
        this.updatePanel();
    }

    public boolean isValidate() throws GUICheckException {
        if (this.jCbxExe.isSelected() && this.jTFExe.getText().trim().length() == 0) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "ExecutePanel.error.EmptyCmdLine"), this.jTFExe);
        }
        return true;
    }

    public void commit() {
        this.runObj.setCmd(this.jTFExe.getText().trim());
        this.runObj.setEnableExe(this.jCbxExe.isSelected());
    }

    public HiExeObject getObject() {
        return this.runObj;
    }
}

