/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.hi.predefined;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.hi.logicobject.AVInfectedStatusObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiExeObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.RestoreConditionObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.RestoreObject;
import com.sygate.scm.console.ui.policy.hi.logicobject.SignatureObject;
import com.sygate.scm.console.ui.policy.hi.predefined.AVInfectedStatusPanel;
import com.sygate.scm.console.ui.policy.hi.predefined.ExecutePanel;
import com.sygate.scm.console.ui.policy.hi.predefined.HiPredefinedType;
import com.sygate.scm.console.ui.policy.hi.predefined.PredefinedPanelBase;
import com.sygate.scm.console.ui.policy.hi.predefined.PredefinedRequirementDlg;
import com.sygate.scm.console.ui.policy.hi.predefined.RestorePanel;
import com.sygate.scm.console.ui.policy.hi.predefined.SignaturePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AvAswFwPanelBase
extends PredefinedPanelBase {
    private static final long serialVersionUID = -100640101371221616L;
    protected JComboBox<HiPredefinedType> jCmbType;
    protected JPanel avInstalledPanel;
    protected ExecutePanel executePanel;
    protected SignaturePanel signaturePanel;
    protected AVInfectedStatusPanel avInfectedStatusPanel;
    protected String requiredName;
    private static final String FW_IPFW = "FW_IPFW";
    private int pannelHeight = 0;
    private JPanel replacedPanel = new JPanel();
    private int dialogHeight = 0;
    private static final int SCREEN_WIDTH_1024 = 1024;
    private static final int SCREEN_HEIGHT_768 = 768;
    private static final int DIALOG_HEIGHT_BASE = 50;
    private static final int TOP_BASE = 30;

    protected AvAswFwPanelBase(String clientType) {
        super(clientType);
        this.requiredName = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "AvAswFwPanelBase.label.RequiredAV");
        this.initialize();
        this.pannelHeight = (int)this.getPreferredSize().getHeight();
    }

    private int getParentDialogHeight() {
        Container parent = this.getParent();
        while (!(parent instanceof PredefinedRequirementDlg)) {
            if (null != parent) {
                parent = parent.getParent();
                continue;
            }
            return (int)this.getPreferredSize().getHeight();
        }
        return (int)parent.getPreferredSize().getHeight();
    }

    protected String getRequiredName() {
        return this.requiredName;
    }

    public void setRequiredName(String name) {
        this.requiredName = name;
    }

    @Override
    public void commit() {
        this.setTypeString(((HiPredefinedType)this.jCmbType.getSelectedItem()).getValue());
        this.restorePanel.commit();
        this.setRestoreObject(this.restorePanel.getRestoreObject());
        this.executePanel.commit();
        this.setExecuteObject(this.executePanel.getObject());
        if (this.signaturePanel != null) {
            this.signaturePanel.commit();
            this.setSignatureObject(this.signaturePanel.getSignatureObject());
        }
        if (this.avInfectedStatusPanel != null) {
            this.avInfectedStatusPanel.commit();
            this.setAVInfectedStatusObject(this.avInfectedStatusPanel.getAVInfectedStatusObject());
        }
        this.restoreCondPanel.commit();
        this.setRestoreCondObject(this.restoreCondPanel.getRestoreConditionObject());
    }

    @Override
    public void updateRestoreCondition() {
        boolean sigEnable = this.signaturePanel != null ? this.signaturePanel.isDownloadFileChecked() : false;
        boolean enable = sigEnable || this.restorePanel.isDownloadFileChecked();
        this.restoreCondPanel.enableRestoration(enable);
    }

    @Override
    public boolean isValidate() throws GUICheckException {
        boolean isValid = super.isValidate() && this.executePanel.isValidate() && this.restoreCondPanel.isValidate();
        return isValid && (this.signaturePanel == null || this.signaturePanel.isValidate());
    }

    protected abstract JComboBox<HiPredefinedType> createPredefinedType();

    protected RestorePanel createRestorePanel() {
        return new RestorePanel(this.getClientType());
    }

    protected abstract ExecutePanel createExecutePanel();

    protected abstract SignaturePanel createSignaturePanel();

    protected abstract AVInfectedStatusPanel createAVInfectedStatusPannel();

    protected abstract String getTypeAnyValue();

    protected abstract String getTypeString();

    protected abstract void setTypeString(String var1);

    protected abstract RestoreObject getRestoreObject();

    protected abstract void setRestoreObject(RestoreObject var1);

    protected abstract HiExeObject getExecuteObject();

    protected abstract void setExecuteObject(HiExeObject var1);

    protected abstract SignatureObject getSignatureObject();

    protected abstract void setSignatureObject(SignatureObject var1);

    protected abstract AVInfectedStatusObject getAVInfectedStatusObject();

    protected abstract void setAVInfectedStatusObject(AVInfectedStatusObject var1);

    protected abstract RestoreConditionObject getRestoreCondObject();

    protected abstract void setRestoreCondObject(RestoreConditionObject var1);

    @Override
    protected void updatePanel(boolean isCancelable, String mode) {
        String avType = this.getTypeString();
        int index = this.getIndexOfType(avType);
        index = index == -1 ? 0 : index;
        this.jCmbType.setSelectedIndex(index);
        this.restorePanel.setObject(this.getRestoreObject());
        this.executePanel.setObject(this.getExecuteObject());
        if (this.signaturePanel != null) {
            this.signaturePanel.setObject(this.getSignatureObject());
        }
        if (this.avInfectedStatusPanel != null) {
            this.avInfectedStatusPanel.setObject(this.getAVInfectedStatusObject());
        }
        this.restoreCondPanel.setObject(this.getRestoreCondObject());
        this.restoreCondPanel.setCancelable(isCancelable);
        this.restoreCondPanel.setOptModeValue(mode);
        this.typeChanged();
    }

    protected void typeChanged() {
        this.dialogHeight = this.getParentDialogHeight();
        HiPredefinedType objType = (HiPredefinedType)this.jCmbType.getSelectedItem();
        boolean isSelected = objType.getValue().equals(this.getTypeAnyValue());
        if (objType.getValue().equalsIgnoreCase(FW_IPFW)) {
            this.restorePanel.setEnableStatus(isSelected);
            this.executePanel.setEnableStatus(!isSelected);
        } else {
            this.restorePanel.setEnableStatus(!isSelected);
            this.executePanel.setEnableStatus(!isSelected);
        }
        if (objType.getValue().equalsIgnoreCase("AV_NORTON_CORP_SEP")) {
            this.resetAVInfectedStatusPannel();
        } else if (this.avInfectedStatusPanel != null) {
            this.replacedPanel.remove(this.avInfectedStatusPanel);
            this.replacedPanel.setPreferredSize(new Dimension(193, 1));
            Dimension newSize = new Dimension();
            newSize.setSize(this.getPreferredSize().width, this.pannelHeight);
            this.setPreferredSize(newSize);
            this.validate();
            this.reChangeDialogSize(-50, -30);
            this.avInfectedStatusPanel = null;
        }
        this.updateRestoreCondition();
    }

    private void initialize() {
        this.jCmbType = this.createPredefinedType();
        this.restorePanel = this.createRestorePanel();
        this.executePanel = this.createExecutePanel();
        this.signaturePanel = this.createSignaturePanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 6, 0, 5));
        this.avInstalledPanel = new JPanel(new GridBagLayout());
        this.avInstalledPanel.add((Component)new JLabel(this.getRequiredName()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.avInstalledPanel.add(this.jCmbType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.avInstalledPanel.setPreferredSize(new Dimension(193, 50));
        this.add((Component)this.avInstalledPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.restorePanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.executePanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        if (this.signaturePanel != null) {
            this.add((Component)this.signaturePanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        }
        this.replacedPanel.setPreferredSize(new Dimension(193, 1));
        this.replacedPanel.setLayout(new BorderLayout());
        this.add((Component)this.replacedPanel, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.restoreCondPanel, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    private boolean resetAVInfectedStatusPannel() {
        if (null != this.avInfectedStatusPanel) {
            this.replacedPanel.remove(this.avInfectedStatusPanel);
            Dimension newSize = new Dimension();
            newSize.setSize(this.getPreferredSize().width, this.pannelHeight + 50);
            this.setPreferredSize(newSize);
            this.validate();
        }
        this.avInfectedStatusPanel = this.createAVInfectedStatusPannel();
        this.avInfectedStatusPanel.setObject(this.getAVInfectedStatusObject());
        if (this.avInfectedStatusPanel != null) {
            this.replacedPanel.setPreferredSize(new Dimension(193, 51));
            this.replacedPanel.add((Component)this.avInfectedStatusPanel, "Center");
            this.validate();
            this.reChangeDialogSize(50, 30);
            return true;
        }
        return false;
    }

    private void reChangeDialogSize(int base, int topBase) {
        Container parent = this.getParent();
        while (!(parent instanceof PredefinedRequirementDlg)) {
            parent = parent.getParent();
        }
        Dimension mySize = parent.getPreferredSize();
        mySize.setSize(mySize.getWidth(), (double)(this.dialogHeight + base));
        parent.setPreferredSize(mySize);
        ((PredefinedRequirementDlg)parent).pack();
        int height = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        int width = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        Point point = parent.getLocation();
        if (height == 768 && width == 1024 && point.y > topBase) {
            parent.setLocation(point.x, point.y - topBase);
        }
        parent.validate();
    }

    private int getIndexOfType(String value) {
        DefaultComboBoxModel mode = (DefaultComboBoxModel)this.jCmbType.getModel();
        for (int i = 0; i < mode.getSize(); ++i) {
            HiPredefinedType item = (HiPredefinedType)mode.getElementAt(i);
            if (PolicyHandler.compareTwoObject(item.getValue(), value) != 0) continue;
            return i;
        }
        return -1;
    }
}

